import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton, DotLink } from '@digital-ai/dot-components';
import { mountWithTheme } from '../../../../tests/unit/testing-utils';
import { LinkButton, LinkButtonProps } from './link-button.component';

describe('LinkButton', () => {
    let wrapper: ReactWrapper;
    const dataTestId = 'link-button-test';
    const href = 'www.test.com';

    const defaultProps: LinkButtonProps = {
        href: 'www.test.com',
        dataTestId,
    };

    const getButton = () => wrapper.find(DotButton);
    const getLink = () => wrapper.find(DotLink);

    const mountComponent = (props: LinkButtonProps = defaultProps) => {
        wrapper = mountWithTheme(<LinkButton {...props}>My link</LinkButton>);
    };

    it('should render DotButton with correct props', () => {
        mountComponent();
        const buttonComponent = getButton();
        expect(buttonComponent).toExist();
        const buttonProps = buttonComponent.props();
        expect(buttonProps.className).toBe('link-button');
        expect(buttonProps['data-testid']).toBe(dataTestId);
    });

    it('should render DotLink with correct props', () => {
        mountComponent();
        const linkComponent = getLink();
        expect(linkComponent).toExist();
        const linkProps = linkComponent.props();
        expect(linkProps.href).toBe(href);
        expect(linkProps.underline).toBe('none');
    });
});
