/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class ArchivingSettings
extends BaseConfiguration {
    public static final String ARCHIVING_SETTINGS_ID = "Configuration/settings/ArchivingSettings";
    public static final int DEFAULT_SEARCH_PAGE_SIZE = 20;
    private static final String DEFAULT_SEARCH_PAGE_SIZE_AS_STRING = "20";
    @Property(defaultValue="720", required=false, label="Archive completed releases older than")
    private Integer releaseAgeToDeleteFromJcr;
    @Property(defaultValue="16 * * * * *", required=false, hidden=true, label="Schedule for the job that checks for releases to archive (advanced)")
    private String archivingJobCronSchedule;
    @Property(defaultValue="true", required=false, hidden=true, label="Enable archiving")
    private boolean enabled;
    @Property(defaultValue="true", required=false, hidden=false, label="Enable pre-archiving")
    private boolean preArchivingEnabled;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of archivable releases to retrieve from the repository in a single search query")
    private Integer searchPageSize;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    private Integer maxSecondsPerRun;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between archiving individual releases within a single run")
    private Integer sleepSecondsBetweenReleases;
    @Property(defaultValue="false", required=false, label="Enable purging of archived releases")
    private boolean purgingEnabled;
    @Property(defaultValue="purged", required=false, label="Path relative to installation to store purged releases")
    private String purgeExportPath;
    @Property(defaultValue="true", required=false, label="Export release data when purging")
    private boolean exportOnPurgeEnabled;
    @Property(defaultValue="8760", required=false, label="Maximum archive retention period")
    private Integer maximumArchiveRetentionPeriod;
    @Property(defaultValue="40 0/10 * * * *", required=false, hidden=true, label="Schedule for the job that checks for releases to purge from the archive (advanced)")
    private String purgingJobCronSchedule;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of purgable releases to retrieve from the repository in a single search query")
    private Integer purgingSearchPageSize;
    @Property(defaultValue="30", required=false, hidden=true, label="Number of seconds that purging is allowed to run before it is paused until the next time it is scheduled")
    private Integer purgingMaxSecondsPerRun;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between purging individual releases within a single run")
    private Integer purgingSleepSecondsBetweenReleases;
    @Property(defaultValue="false", required=false, label="Allow releases to skip archiving")
    private boolean skipArchiveAllowed;

    public void validate() {
        Preconditions.checkArgument((this.releaseAgeToDeleteFromJcr >= 0 ? 1 : 0) != 0, (Object)"releaseAgeToDeleteFromJcr must be greater than or equal to 0 hours.");
        if (this.purgingEnabled) {
            Preconditions.checkArgument((this.maximumArchiveRetentionPeriod >= 1 ? 1 : 0) != 0, (Object)"If purging is enabled the maximumArchiveRetentionPeriod must be greater than or equal to 1 hour");
        }
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.releaseAgeToDeleteFromJcr;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingJobCronSchedule;
    }

    public void setReleaseAgeToDeleteFromJcr(Integer releaseAgeToDeleteFromJcr) {
        this.releaseAgeToDeleteFromJcr = releaseAgeToDeleteFromJcr;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getPreArchivingEnabled() {
        return this.preArchivingEnabled;
    }

    public void setPreArchivingEnabled(Boolean enabled) {
        this.preArchivingEnabled = enabled;
    }

    public Integer getSearchPageSize() {
        return this.searchPageSize;
    }

    public Integer getMaxSecondsPerRun() {
        return this.maxSecondsPerRun;
    }

    public Integer getSleepSecondsBetweenReleases() {
        return this.sleepSecondsBetweenReleases;
    }

    public boolean getPurgingEnabled() {
        return this.purgingEnabled;
    }

    public void setPurgingEnabled(boolean enabled) {
        this.purgingEnabled = enabled;
    }

    public String getPurgeExportPath() {
        return this.purgeExportPath;
    }

    public void setPurgeExportPath(String location) {
        this.purgeExportPath = location;
    }

    public boolean getExportOnPurgeEnabled() {
        return this.exportOnPurgeEnabled;
    }

    public void setExportOnPurgeEnabled(boolean enabled) {
        this.exportOnPurgeEnabled = enabled;
    }

    public Integer getMaximumArchiveRetentionPeriod() {
        return this.maximumArchiveRetentionPeriod;
    }

    public void setMaximumArchiveRetentionPeriod(Integer maximumArchiveRetentionPeriod) {
        this.maximumArchiveRetentionPeriod = maximumArchiveRetentionPeriod;
    }

    public String getPurgingJobCronSchedule() {
        return this.purgingJobCronSchedule;
    }

    public Integer getPurgingSearchPageSize() {
        return this.purgingSearchPageSize;
    }

    public Integer getPurgingMaxSecondsPerRun() {
        return this.purgingMaxSecondsPerRun;
    }

    public Integer getPurgingSleepSecondsBetweenReleases() {
        return this.purgingSleepSecondsBetweenReleases;
    }

    public boolean getSkipArchiveAllowed() {
        return this.skipArchiveAllowed;
    }

    public void setSkipArchiveAllowed(boolean skipArchiveAllowed) {
        this.skipArchiveAllowed = skipArchiveAllowed;
    }
}

