/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.scheduler.JobOverview;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskIdAndExecutionId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJob;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNode;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNodeAndStatus;
import com.xebialabs.xlrelease.scheduler.sql.JobRowMapper;
import com.xebialabs.xlrelease.scheduler.sql.SqlJobFiltersQueryBuilder$;
import com.xebialabs.xlrelease.scheduler.sql.SqlJobOverviewQueryBuilder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001\u0002\u0014(\u0001IB\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\tI\u0002\u0011\t\u0011)A\u00051\"AQ\r\u0001BC\u0002\u0013\u0005a\r\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003h\u0011%y\bA!b\u0001\n\u0003\t\t\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u0007Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002B!9\u00111\u000b\u0001\u0005\n\u0005U\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0011!\tY\u0007\u0001Q\u0001\n\u0005u\u0003\"CA7\u0001\t\u0007I\u0011BA \u0011!\ty\u0007\u0001Q\u0001\n\u0005\u0005\u0003bBA9\u0001\u0011\u0005\u00131\u000f\u0005\n\u0003\u007f\u0002!\u0019!C\u0005\u0003\u007fA\u0001\"!!\u0001A\u0003%\u0011\u0011\t\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011%\tY\u000b\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BA!\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a1\u0001\t\u0003\n)\rC\u0004\u0002t\u0002!\t%!>\t\u0013\t\u0015\u0001A1A\u0005\n\u0005}\u0002\u0002\u0003B\u0004\u0001\u0001\u0006I!!\u0011\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!I!Q\u0003\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0005/\u0001\u0001\u0015!\u0003\u0002B!I!\u0011\u0004\u0001C\u0002\u0013%\u0011q\b\u0005\t\u00057\u0001\u0001\u0015!\u0003\u0002B!I!Q\u0004\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0005?\u0001\u0001\u0015!\u0003\u0002B!9!\u0011\u0005\u0001\u0005B\t\r\u0002b\u0002B\u0019\u0001\u0011\u0005#1\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0005A\u0019\u0016\u000f\u001c&pEJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!C:dQ\u0016$W\u000f\\3s\u0015\taS&A\u0005yYJ,G.Z1tK*\u0011afL\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001M\u0001\u0004G>l7\u0001A\n\b\u0001MJthR&O!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0011!(P\u0007\u0002w)\u0011A(K\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001 <\u00055QuN\u0019*fa>\u001c\u0018\u000e^8ssB\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002)\t*\u0011AhK\u0005\u0003\r\u0006\u0013!\u0003U3sg&\u001cH/\u001a8dKN+\b\u000f]8siB\u0011\u0001*S\u0007\u0002O%\u0011!j\n\u0002\r\u0015>\u0014'k\\<NCB\u0004XM\u001d\t\u0003\u00012K!!T!\u0003\u000bU#\u0018\u000e\\:\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016!B:mMRR'\"A*\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0016)\u0003\u000f1{wmZ5oO\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t\u0001\f\u0005\u0002ZE6\t!L\u0003\u0002\\9\u0006!1m\u001c:f\u0015\tif,\u0001\u0003kI\n\u001c'BA0a\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A1\u0002\u0007=\u0014x-\u0003\u0002d5\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nq\u0001Z5bY\u0016\u001cG/F\u0001h!\tA7P\u0004\u0002jq:\u0011!N\u001e\b\u0003WRt!\u0001\\:\u000f\u00055\u0014hB\u00018r\u001b\u0005y'B\u000192\u0003\u0019a$o\\8u}%\t\u0001'\u0003\u0002/_%\u0011A&L\u0005\u0003k.\n!\u0001\u001a2\n\u0005!:(BA;,\u0013\tI(0\u0001\u0006Tc2\u0014U/\u001b7eKJT!\u0001K<\n\u0005ql(a\u0002#jC2,7\r\u001e\u0006\u0003sj\f\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005\u001dQ\"\u0001#\n\u0007\u0005%AI\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b*fa>\u001c\u0018\u000e^8ss\u0002\na\u0001P5oSRtD\u0003CA\t\u0003'\t)\"a\u0006\u0011\u0005!\u0003\u0001\"\u0002,\b\u0001\u0004A\u0006\"B3\b\u0001\u00049\u0007BB@\b\u0001\u0004\t\u0019!\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003;\t)\u0003\u0005\u0003\u0002 \u0005\u0005R\"A\u0015\n\u0007\u0005\r\u0012F\u0001\u0004K_\n\u0014vn\u001e\u0005\b\u0003OA\u0001\u0019AA\u000f\u0003\rQwNY\u0001\be\u0016\u0004H.Y2f)\u0011\ti\"!\f\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002\u001e!\u001a\u0011\"!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e{\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005m\u0012Q\u0007\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006y1\u000bV'U?&s5+\u0012*U?*{%)\u0006\u0002\u0002BA!\u00111IA&\u001d\u0011\t)%a\u0012\u0011\u00059,\u0014bAA%k\u00051\u0001K]3eK\u001aLA!!\u0014\u0002P\t11\u000b\u001e:j]\u001eT1!!\u00136\u0003A\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u0015>\u0013\u0005%A\u0007de\u0016\fG/\u001a+bg.TuN\u0019\u000b\u0005\u0003;\t9\u0006C\u0004\u0002(1\u0001\r!!\b\u0002?A\u0013VIV%P+N{f+\u0012*T\u0013>su\fU!S\u00036+E+\u0012*`\u001d\u0006kU)\u0006\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001\u00027b]\u001eT!!a\u001a\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\n\t'\u0001\u0011Q%\u00163\u0016jT+T?Z+%kU%P\u001d~\u0003\u0016IU!N\u000bR+%k\u0018(B\u001b\u0016\u0003\u0013!D*U\u001bR{FjT\"L?*{%)\u0001\bT)6#v\fT(D\u0017~SuJ\u0011\u0011\u0002-U\u0004H-\u0019;f/&$\bNV3sg&|gn\u00115fG.$B!!\u001e\u0002|A\u0019A'a\u001e\n\u0007\u0005eTG\u0001\u0003V]&$\bbBA\u0014#\u0001\u0007\u0011Q\u0004\u0015\u0004#\u0005E\u0012!I*U\u001bR{f)\u0013(E?R\u000b5kS0J\tN{&)W0S\u000b2+\u0015iU#`+&#\u0015AI*U\u001bR{f)\u0013(E?R\u000b5kS0J\tN{&)W0S\u000b2+\u0015iU#`+&#\u0005%A\u000fgS:$\u0017+^3vK\u0012$\u0016m]6JIN\u0014\u0015PU3mK\u0006\u001cX-V5e)\u0011\t9)!'\u0011\r\u0005%\u00151SA!\u001d\u0011\tY)a$\u000f\u00079\fi)C\u00017\u0013\r\t\t*N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)*a&\u0003\u0007M+\u0017OC\u0002\u0002\u0012VBq!a'\u0015\u0001\u0004\ti*\u0001\u0006sK2,\u0017m]3VS\u0012\u0004B!a\u0018\u0002 &!\u0011\u0011UA1\u0005\u001dIe\u000e^3hKJD3\u0001FAS!\u0011\t\u0019$a*\n\t\u0005%\u0016Q\u0007\u0002\u000b\u0013N\u0014V-\u00193P]2L\u0018aF*U\u001bR{f)\u0013(E?Z+%kU%P\u001d~\u0013\u0015lX%E\u0003a\u0019F+\u0014+`\r&sEi\u0018,F%NKuJT0C3~KE\tI\u0001\u0010M&tGMV3sg&|gNQ=JIR!\u00111WA]!\u0015!\u0014QWAO\u0013\r\t9,\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005mv\u00031\u0001\u0002>\u0006\u0011\u0011\u000e\u001a\t\u0004i\u0005}\u0016bAAak\t!Aj\u001c8h\u0003\u001d1\u0017N\u001c3BY2$b!a2\u0002X\u0006\u001d\bCBAe\u0003'\fi\"\u0004\u0002\u0002L*!\u0011QZAh\u0003\u0019!w.\\1j]*\u0019\u0011\u0011\u001b0\u0002\t\u0011\fG/Y\u0005\u0005\u0003+\fYM\u0001\u0003QC\u001e,\u0007bBAm1\u0001\u0007\u00111\\\u0001\u000bU>\u0014g)\u001b7uKJ\u001c\b\u0003BAo\u0003Gl!!a8\u000b\u0007\u0005\u0005\u0018&A\u0004gS2$XM]:\n\t\u0005\u0015\u0018q\u001c\u0002\u000b\u0015>\u0014g)\u001b7uKJ\u001c\bbBAu1\u0001\u0007\u00111^\u0001\ta\u0006<W-\u00192mKB!\u0011\u0011ZAw\u0013\u0011\ty/a3\u0003\u0011A\u000bw-Z1cY\u0016D3\u0001GAS\u0003I1\u0017N\u001c3BY2TuNY(wKJ4\u0018.Z<\u0015\r\u0005]\u0018q B\u0001!\u0019\tI-a5\u0002zB!\u0011qDA~\u0013\r\ti0\u000b\u0002\f\u0015>\u0014wJ^3sm&,w\u000fC\u0004\u0002Zf\u0001\r!a7\t\u000f\u0005%\u0018\u00041\u0001\u0002l\"\u001a\u0011$!*\u00027M#V\nV0G\u0013:#u\fR%T)&s5\tV0O\u001f\u0012+u,\u0013#T\u0003q\u0019F+\u0014+`\r&sEi\u0018#J'RKej\u0011+`\u001d>#UiX%E'\u0002\n1CZ5oI\u0012K7\u000f^5oGRtu\u000eZ3JIN$\"A!\u0004\u0011\r\u0005\r#qBA!\u0013\u0011\u0011\t\"a\u0014\u0003\u0007M+G\u000fK\u0002\u001d\u0003K\u000bqb\u0015+N)~#U\tT#U\u000b~SuJQ\u0001\u0011'RkEk\u0018#F\u0019\u0016#Vi\u0018&P\u0005\u0002\n1d\u0015+N)~#U\tT#U\u000b~\u0013\u0015l\u0018+B'.{\u0016\nR0I\u0003NC\u0015\u0001H*U\u001bR{F)\u0012'F)\u0016{&)W0U\u0003N[u,\u0013#`\u0011\u0006\u001b\u0006\nI\u0001-'RkEk\u0018#F\u0019\u0016#Vi\u0018\"Z?R\u000b5kS0J\t~C\u0015i\u0015%`\u0003:#u,\u0012-F\u0007V#\u0016j\u0014(`\u0013\u0012\u000bQf\u0015+N)~#U\tT#U\u000b~\u0013\u0015l\u0018+B'.{\u0016\nR0I\u0003NCu,\u0011(E?\u0016CViQ+U\u0013>su,\u0013#!\u0003\u0019!W\r\\3uKR!\u0011Q\u000fB\u0013\u0011\u001d\u00119c\ta\u0001\u0005S\t\u0011\u0002Z3mKR,'j\u001c2\u0011\u0007i\u0012Y#C\u0002\u0003.m\u0012\u0011\u0002R3mKR,'j\u001c2)\u0007\r\n\t$\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0005k\u00119\u0004E\u00035\u0003k\u000bi\u0002C\u0004\u0003:\u0011\u0002\rAa\u000f\u0002\u0013U\u0004H-\u0019;f\u0015>\u0014\u0007c\u0001\u001e\u0003>%\u0019!qH\u001e\u0003\u0013U\u0003H-\u0019;f\u0015>\u0014\u0007f\u0001\u0013\u00022\u00051\u0002.\u00198eY\u0016|\u0005\u000f^5nSN$\u0018nY+qI\u0006$X\r\u0006\u0004\u0003H\tM#Q\u000b\t\bi\t%#QJA;\u0013\r\u0011Y%\u000e\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019AGa\u0014\n\u0007\tESGA\u0002J]RDq!a\n&\u0001\u0004\ti\u0002C\u0004\u0003X\u0015\u0002\rA!\u0017\u0002\u001b1|wMU3d_Z,'/\u001f$o!\u0015!\u0014Q\u0017B.!\u0015!$QLA!\u0013\r\u0011y&\u000e\u0002\n\rVt7\r^5p]B\u0002")
public class SqlJobRepository
implements JobRepository,
PersistenceSupport,
JobRowMapper,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final TaskRepository taskRepository;
    private final String STMT_INSERT_JOB;
    private final String PREVIOUS_VERSION_PARAMETER_NAME;
    private final String STMT_LOCK_JOB;
    private final String STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    private final String STMT_FIND_VERSION_BY_ID;
    private final String STMT_FIND_DISTINCT_NODE_IDS;
    private final String STMT_DELETE_JOB;
    private final String STMT_DELETE_BY_TASK_ID_HASH;
    private final String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public RowMapper<JobRow> jobMapper() {
        return JobRowMapper.jobMapper$(this);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public JobRow create(JobRow job) {
        JobRow jobRow;
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(13).append("creating job ").append(job).toString());
        try {
            jobRow = this.createTaskJob(job);
        }
        catch (Exception exception) {
            jobRow = this.replace(job);
        }
        return jobRow;
    }

    @IsTransactional
    public JobRow replace(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(14).append("replacing job ").append(job).toString());
        this.delete((DeleteJob)new DeleteByTaskId(job.taskId()));
        return this.createTaskJob(job);
    }

    private String STMT_INSERT_JOB() {
        return this.STMT_INSERT_JOB;
    }

    private JobRow createTaskJob(JobRow job) {
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID()), (Object)job.taskId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(job.taskId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)job.releaseUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.JOB_TYPE()), (Object)job.jobType().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()), (Object)Timestamp.from(job.submitTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()), (Object)Timestamp.from(job.scheduledStartTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)job.executionId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node())}));
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.namedTemplate().update(this.STMT_INSERT_JOB(), (SqlParameterSource)this.paramMap2MapSqlParameterSource((Map<String, Object>)params), (KeyHolder)holder, (String[])((Object[])new String[]{this.pkName(Schema.TASK_JOBS$.MODULE$.ID())}));
        return job.copy(holder.getKey().longValue(), job.copy$default$2(), job.copy$default$3(), job.copy$default$4(), job.copy$default$5(), job.copy$default$6(), job.copy$default$7(), job.copy$default$8(), job.copy$default$9(), job.copy$default$10(), job.copy$default$11());
    }

    private String PREVIOUS_VERSION_PARAMETER_NAME() {
        return this.PREVIOUS_VERSION_PARAMETER_NAME;
    }

    private String STMT_LOCK_JOB() {
        return this.STMT_LOCK_JOB;
    }

    @IsTransactional
    public void updateWithVersionCheck(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(38).append("going to update with version check to ").append(job).toString());
        long previousVersion = job.version() - 1L;
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.START_TIME()), Option$.MODULE$.apply((Object)job.startTime()).map((Function1 & Serializable)x$1 -> Timestamp.from(x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)job.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PREVIOUS_VERSION_PARAMETER_NAME()), (Object)BoxesRunTime.boxToLong((long)previousVersion))}));
        this.sqlUpdate(this.STMT_LOCK_JOB(), this.paramMap2MapSqlParameterSource((Map<String, Object>)params), (Function1)this.handleOptimisticUpdate(job, (Option<Function0<String>>)new Some((Function0 & Serializable)() -> (String)this.findVersionById(job.id()).map((Function1 & Serializable)version -> new StringBuilder(19).append("current version is ").append(version).toString()).getOrElse((Function0 & Serializable)() -> "record not found"))));
    }

    private String STMT_FIND_TASK_IDS_BY_RELEASE_UID() {
        return this.STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    }

    @IsReadOnly
    public Seq<String> findQueuedTaskIdsByReleaseUid(Integer releaseUid) {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_TASK_IDS_BY_RELEASE_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)releaseUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)JobStatus.QUEUED.name())})), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.TASK_ID())));
    }

    private String STMT_FIND_VERSION_BY_ID() {
        return this.STMT_FIND_VERSION_BY_ID;
    }

    private Option<Integer> findVersionById(long id) {
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_VERSION_BY_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)id))})), (Function1 & Serializable)rs -> BoxesRunTime.boxToInteger((int)rs.getInt(Schema.TASK_JOBS$.MODULE$.VERSION()))));
    }

    @IsReadOnly
    public Page<JobRow> findAll(JobFilters jobFilters, Pageable pageable) {
        return SqlJobFiltersQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.taskRepository()).from(jobFilters).withPageable(pageable).build().execute();
    }

    @IsReadOnly
    public Page<JobOverview> findAllJobOverview(JobFilters jobFilters, Pageable pageable) {
        return SqlJobOverviewQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.taskRepository()).from(jobFilters).withPageable(pageable).build().execute();
    }

    private String STMT_FIND_DISTINCT_NODE_IDS() {
        return this.STMT_FIND_DISTINCT_NODE_IDS;
    }

    @IsReadOnly
    public Set<String> findDistinctNodeIds() {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_DISTINCT_NODE_IDS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Nil$.MODULE$), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.NODE()))).toSet();
    }

    private String STMT_DELETE_JOB() {
        return this.STMT_DELETE_JOB;
    }

    private String STMT_DELETE_BY_TASK_ID_HASH() {
        return this.STMT_DELETE_BY_TASK_ID_HASH;
    }

    private String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID() {
        return this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    }

    @IsTransactional
    public void delete(DeleteJob deleteJob) {
        DeleteJob deleteJob2 = deleteJob;
        if (deleteJob2 instanceof DeleteById) {
            DeleteById deleteById = (DeleteById)deleteJob2;
            long id = deleteById.id();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(24).append("deleting job with jobId ").append(id).toString());
            int deletedRows = BoxesRunTime.unboxToInt(this.sqlUpdate(this.STMT_DELETE_JOB(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)id))}))), (Function1)(JFunction1.mcII.sp & Serializable)rows -> rows));
            if (deletedRows != 1) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(58).append(deletedRows).append(" rows deleted when trying to delete scheduled job with id ").append(id).toString());
                return;
            }
            return;
        }
        if (deleteJob2 instanceof DeleteByTaskId) {
            DeleteByTaskId deleteByTaskId = (DeleteByTaskId)deleteJob2;
            String taskId = deleteByTaskId.taskId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(25).append("deleting job with taskId ").append(taskId).toString());
            this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId))})), x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute()));
            return;
        }
        if (deleteJob2 instanceof DeleteByTaskIdAndExecutionId) {
            DeleteByTaskIdAndExecutionId deleteByTaskIdAndExecutionId = (DeleteByTaskIdAndExecutionId)deleteJob2;
            String taskId = deleteByTaskIdAndExecutionId.taskId();
            String executionId = deleteByTaskIdAndExecutionId.executionId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(42).append("deleting job with taskId ").append(taskId).append(" and executionId ").append(executionId).toString());
            this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)executionId)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(27).append(deleteJob).append(" operation is not supported").toString());
    }

    @IsTransactional
    public Option<JobRow> update(UpdateJob updateJob) {
        JobRow jobRow;
        UpdateJob updateJob2 = updateJob;
        if (updateJob2 instanceof UpdateNode) {
            UpdateNode updateNode = (UpdateNode)updateJob2;
            JobRow job = updateNode.job();
            String nodeId = updateNode.nodeId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(22).append("changing job ").append(job).append(" node to ").append(nodeId).toString());
            long x$1 = job.version() + 1L;
            String x$2 = nodeId;
            long x$32 = job.copy$default$1();
            JobType x$4 = job.copy$default$3();
            JobStatus x$5 = job.copy$default$4();
            Instant x$6 = job.copy$default$6();
            Instant x$7 = job.copy$default$7();
            Instant x$8 = job.copy$default$8();
            String x$9 = job.copy$default$9();
            Integer x$10 = job.copy$default$10();
            String x$11 = job.copy$default$11();
            jobRow = job.copy(x$32, x$2, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11);
        } else if (updateJob2 instanceof UpdateJobStatus) {
            UpdateJobStatus updateJobStatus = (UpdateJobStatus)updateJob2;
            JobRow job = updateJobStatus.job();
            JobStatus jobStatus = updateJobStatus.status();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(27).append("changing status of job ").append(job).append(" to ").append(jobStatus).toString());
            long x$12 = job.version() + 1L;
            JobStatus x$13 = jobStatus;
            long x$14 = job.copy$default$1();
            String x$15 = job.copy$default$2();
            JobType x$16 = job.copy$default$3();
            Instant x$17 = job.copy$default$6();
            Instant x$18 = job.copy$default$7();
            Instant x$19 = job.copy$default$8();
            String x$20 = job.copy$default$9();
            Integer x$21 = job.copy$default$10();
            String x$22 = job.copy$default$11();
            jobRow = job.copy(x$14, x$15, x$16, x$13, x$12, x$17, x$18, x$19, x$20, x$21, x$22);
        } else if (updateJob2 instanceof UpdateNodeAndStatus) {
            UpdateNodeAndStatus updateNodeAndStatus = (UpdateNodeAndStatus)updateJob2;
            JobRow job = updateNodeAndStatus.job();
            String nodeId = updateNodeAndStatus.nodeId();
            JobStatus jobStatus = updateNodeAndStatus.status();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("changing job ").append(job).append(" node to ").append(nodeId).append(" and status to ").append(jobStatus).toString());
            long x$23 = job.version() + 1L;
            String x$24 = nodeId;
            JobStatus x$25 = jobStatus;
            long x$26 = job.copy$default$1();
            JobType x$27 = job.copy$default$3();
            Instant x$28 = job.copy$default$6();
            Instant x$29 = job.copy$default$7();
            Instant x$30 = job.copy$default$8();
            String x$31 = job.copy$default$9();
            Integer x$32 = job.copy$default$10();
            String x$33 = job.copy$default$11();
            jobRow = job.copy(x$26, x$24, x$27, x$25, x$23, x$28, x$29, x$30, x$31, x$32, x$33);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(27).append(updateJob).append(" operation is not supported").toString());
        }
        JobRow newJobRow = jobRow;
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.updateWithVersionCheck(newJobRow)).map((Function1 & Serializable)x$3 -> newJobRow).toOption();
    }

    private PartialFunction<Object, BoxedUnit> handleOptimisticUpdate(JobRow job, Option<Function0<String>> logRecoveryFn) {
        return new Serializable(this, job, logRecoveryFn){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlJobRepository $outer;
            private final JobRow job$7;
            private final Option logRecoveryFn$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                switch (A1) {
                    case 0: {
                        String msg = new StringBuilder(38).append("Unable to update Job row ").append(this.job$7).append(" of version ").append(this.job$7.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                        this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                        throw new OptimisticLockingFailureException(msg);
                    }
                    case 1: {
                        this.$outer.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Successfully updated job to ").append($this.job$7).toString());
                        return (B1)BoxedUnit.UNIT;
                    }
                }
                String msg = new StringBuilder(47).append("More than one row updated for job ").append(this.job$7.id()).append(" of version ").append(this.job$7.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                throw new IllegalStateException(msg);
            }

            public final boolean isDefinedAt(int x1) {
                int n = x1;
                switch (n) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.job$7 = job$7;
                this.logRecoveryFn$1 = logRecoveryFn$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Function0 ), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(java.lang.String ), $anonfun$applyOrElse$4(com.xebialabs.xlrelease.scheduler.sql.SqlJobRepository$$anonfun$handleOptimisticUpdate$1 ), $anonfun$applyOrElse$5(scala.Function0 ), $anonfun$applyOrElse$6(), $anonfun$applyOrElse$7(java.lang.String )}, serializedLambda);
            }
        };
    }

    public SqlJobRepository(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect, TaskRepository taskRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.taskRepository = taskRepository;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        JobRowMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(302).append("INSERT INTO ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append(" (\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | ) VALUES (\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | )\n       |").toString()));
        this.PREVIOUS_VERSION_PARAMETER_NAME = "PREVIOUS_VERSION";
        this.STMT_LOCK_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(125).append("UPDATE ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | SET\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" AND ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(this.PREVIOUS_VERSION_PARAMETER_NAME()).append("\n       |").toString()));
        this.STMT_FIND_TASK_IDS_BY_RELEASE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" AND\n       | ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append("\n       |").toString()));
        this.STMT_FIND_VERSION_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(76).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_FIND_DISTINCT_NODE_IDS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n       |SELECT DISTINCT\n       | ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |").toString()));
        this.STMT_DELETE_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       | AND ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append("\n       |").toString()));
    }
}

