import sys
import urllib

from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from jenkins import JenkinsServer

"""
Calls Jenkins API in order to know if a job expects parameters
When expecting a parameter named "param", the JSON looks like:

    "actions" : [
        {
            "parameterDefinitions" : [
                {
                    "defaultParameterValue" : {
                        "name" : "param",
                        "value" : ""
                    },
                    "description" : "",
                    "name" : "param",
                    "type" : "StringParameterDefinition"
                }
            ]
        }
    ]

In last versions of Jenkins the parameters are defined in "property" field, leaving "actions" for old versions
"""

CONTENT_TYPE='application/json'

def isJobParameterized(request, jobContext, headers):
    jobInfo = request.get(jobContext + 'api/json?depth=0&tree=actions[parameterDefinitions],property[parameterDefinitions]',
                          contentType=CONTENT_TYPE, headers=headers)
    jobProperties = JsonPathResult(jobInfo.response, 'property').get()
    if jobProperties is not None:
        for prop in jobProperties:
            if (prop is not None and 'parameterDefinitions' in prop):
                return True

    jobActions = JsonPathResult(jobInfo.response, 'actions').get()
    if jobActions is not None:
        for action in jobActions:
            if (action is not None and 'parameterDefinitions' in action):
                return True

    return False

"""
With an input that looks like:
param1=value 1\n
param2=value 2\n

Produces: ?param1=value%201&param2=value%202 to be used as a query string
"""
def buildQueryString(params):
    if (params is not None):
        queryParams = []
        delimiter = '~~'
        if '~~' not in params and params.count('=') > 1:
            delimiter = '\n'
        for param in params.split(delimiter):
            if param:
                tokens = param.split('=', 1)
                queryParams.append(tokens[0].strip() + "=" + urllib.quote(tokens[1]))
        return "?" + "&".join(queryParams)
    else:
        return ""

if jenkinsServer is None:
    print "No server provided."
    sys.exit(1)

jenkinsURL = jenkinsServer['url']
jobContext = '/job/' + urllib.quote(jobName) + '/'

# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
# Headers for CSRF Protection and apiToken based authentication
headers = jenkins.create_api_token_header(request)

response = request.get(jobContext + 'api/json?depth=0&tree=name,_class,jobs[name,url]', contentType=CONTENT_TYPE, headers=headers)

if response.isSuccessful():
    jobClass = JsonPathResult(response.response, '_class').get()

    if "WorkflowMultiBranchProject" in jobClass:

        jobs = JsonPathResult(response.response, 'jobs').get()
        if branch:
            jobUrl = None
            if "/" in branch:
                encoded_branch = branch.replace("/", "%2F")
            else:
                encoded_branch = branch
            for job in jobs:
                if job['name'] == encoded_branch:
                    jobUrl = job['url']

            if jobUrl is None:
                print ("Incorrect Branch %s." % encoded_branch)
                sys.exit(1)
            else:
                jobUrl = jobUrl.replace(jenkinsURL, '')
                jobContext = jobUrl.replace(jenkinsURL, '')
        else:
            print ("Mandatory Branch field for MultiBranch Pipeline is empty")
            sys.exit(1)

    if isJobParameterized(request, jobContext, headers):
        buildContext = jobContext + 'buildWithParameters' + buildQueryString(jobParameters)
    else:
        buildContext = jobContext + 'build'

    buildResponse = request.post(buildContext, '', contentType=CONTENT_TYPE, headers=headers)
    print ("Build response from jenkins is %s " % buildResponse.getStatus())

    if buildResponse.getStatus() in [200, 201, 202]:
        # query the location header which gives a queue item position (more reliable for retrieving the correct job later)
        location = None
        for key in buildResponse.getHeaders().keys():
            if key.lower() == 'location' and '/queue/item/' in buildResponse.getHeaders()[key]:
                location = '/queue/item/' + filter(None, buildResponse.getHeaders()[key].split('/'))[-1] + '/'

        task.setStatusLine("Build queued")
        task.schedule("jenkins/Build.wait-for-queue.py")
    else:
        print ("Build request failed. Please check the parameters and job name.")
        print (buildResponse.getStatus())
        print (buildResponse.getHeaders())
        print (buildResponse.response)
        sys.exit(1)
else:
    print "Failed to connect at %s." % (jenkinsURL + jobContext)
    response.errorDump()
    sys.exit(1)