/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import jnr.ffi.Pointer;
import jnr.ffi.byref.PointerByReference;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.ByteBufferProxy;
import org.lmdbjava.CopyFlags;
import org.lmdbjava.Cursor;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.EnvInfo;
import org.lmdbjava.Library;
import org.lmdbjava.LmdbException;
import org.lmdbjava.LmdbNativeException;
import org.lmdbjava.MaskedFlag;
import org.lmdbjava.ResultCodeMapper;
import org.lmdbjava.Stat;
import org.lmdbjava.Txn;
import org.lmdbjava.TxnFlags;

public final class Env<T>
implements AutoCloseable {
    public static final String DISABLE_CHECKS_PROP = "lmdbjava.disable.checks";
    public static final boolean SHOULD_CHECK = !Boolean.getBoolean("lmdbjava.disable.checks");
    private boolean closed;
    private final int maxKeySize;
    private final BufferProxy<T> proxy;
    private final Pointer ptr;
    private final boolean readOnly;

    private Env(BufferProxy<T> proxy, Pointer ptr, boolean readOnly) {
        this.proxy = proxy;
        this.readOnly = readOnly;
        this.ptr = ptr;
        this.maxKeySize = Library.LIB.mdb_env_get_maxkeysize(ptr);
    }

    public static Builder<ByteBuffer> create() {
        return new Builder<ByteBuffer>(ByteBufferProxy.PROXY_OPTIMAL);
    }

    public static <T> Builder<T> create(BufferProxy<T> proxy) {
        return new Builder<T>(proxy);
    }

    public static Env<ByteBuffer> open(File path, int size, EnvFlags ... flags) {
        return new Builder<ByteBuffer>(ByteBufferProxy.PROXY_OPTIMAL).setMapSize((long)size * 1024L * 1024L).open(path, flags);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Library.LIB.mdb_env_close(this.ptr);
    }

    public void copy(File path, CopyFlags ... flags) {
        Objects.requireNonNull(path);
        if (!path.exists()) {
            throw new InvalidCopyDestination("Path must exist");
        }
        if (!path.isDirectory()) {
            throw new InvalidCopyDestination("Path must be a directory");
        }
        String[] files = path.list();
        if (files != null && files.length > 0) {
            throw new InvalidCopyDestination("Path must contain no files");
        }
        int flagsMask = MaskedFlag.mask(flags);
        ResultCodeMapper.checkRc(Library.LIB.mdb_env_copy2(this.ptr, path.getAbsolutePath(), flagsMask));
    }

    public List<byte[]> getDbiNames() {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        Dbi<T> names = this.openDbi((byte[])null, new DbiFlags[0]);
        try (Txn<T> txn = this.txnRead();
             Cursor<T> cursor = names.openCursor(txn);){
            if (!cursor.first()) {
                List<byte[]> list = Collections.emptyList();
                return list;
            }
            do {
                byte[] name = this.proxy.getBytes(cursor.key());
                result.add(name);
            } while (cursor.next());
        }
        return result;
    }

    public void setMapSize(long mapSize) {
        ResultCodeMapper.checkRc(Library.LIB.mdb_env_set_mapsize(this.ptr, mapSize));
    }

    public int getMaxKeySize() {
        return this.maxKeySize;
    }

    public EnvInfo info() {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        Library.MDB_envinfo info = new Library.MDB_envinfo(Library.RUNTIME);
        ResultCodeMapper.checkRc(Library.LIB.mdb_env_info(this.ptr, info));
        long mapAddress = info.f0_me_mapaddr.get() == null ? 0L : info.f0_me_mapaddr.get().address();
        return new EnvInfo(mapAddress, info.f1_me_mapsize.longValue(), info.f2_me_last_pgno.longValue(), info.f3_me_last_txnid.longValue(), info.f4_me_maxreaders.intValue(), info.f5_me_numreaders.intValue());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Dbi<T> openDbi(String name, DbiFlags ... flags) {
        byte[] nameBytes = name == null ? null : name.getBytes(StandardCharsets.UTF_8);
        return this.openDbi(nameBytes, flags);
    }

    public Dbi<T> openDbi(String name, Comparator<T> comparator, DbiFlags ... flags) {
        byte[] nameBytes = name == null ? null : name.getBytes(StandardCharsets.UTF_8);
        return this.openDbi(nameBytes, comparator, flags);
    }

    public Dbi<T> openDbi(byte[] name, DbiFlags ... flags) {
        try (Txn<T> txn = this.readOnly ? this.txnRead() : this.txnWrite();){
            Dbi<T> dbi = new Dbi<T>(this, txn, name, null, flags);
            txn.commit();
            Dbi<T> dbi2 = dbi;
            return dbi2;
        }
    }

    public Dbi<T> openDbi(byte[] name, Comparator<T> comparator, DbiFlags ... flags) {
        try (Txn<T> txn = this.readOnly ? this.txnRead() : this.txnWrite();){
            Dbi<T> dbi = new Dbi<T>(this, txn, name, comparator, flags);
            txn.commit();
            Dbi<T> dbi2 = dbi;
            return dbi2;
        }
    }

    public Stat stat() {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        Library.MDB_stat stat = new Library.MDB_stat(Library.RUNTIME);
        ResultCodeMapper.checkRc(Library.LIB.mdb_env_stat(this.ptr, stat));
        return new Stat(stat.f0_ms_psize.intValue(), stat.f1_ms_depth.intValue(), stat.f2_ms_branch_pages.longValue(), stat.f3_ms_leaf_pages.longValue(), stat.f4_ms_overflow_pages.longValue(), stat.f5_ms_entries.longValue());
    }

    public void sync(boolean force) {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        int f = force ? 1 : 0;
        ResultCodeMapper.checkRc(Library.LIB.mdb_env_sync(this.ptr, f));
    }

    public Txn<T> txn(Txn<T> parent, TxnFlags ... flags) {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        return new Txn<T>(this, parent, this.proxy, flags);
    }

    public Txn<T> txnRead() {
        return this.txn(null, TxnFlags.MDB_RDONLY_TXN);
    }

    public Txn<T> txnWrite() {
        return this.txn(null, new TxnFlags[0]);
    }

    Pointer pointer() {
        return this.ptr;
    }

    public static final class VersionMismatchException
    extends LmdbNativeException {
        static final int MDB_VERSION_MISMATCH = -30794;
        private static final long serialVersionUID = 1L;

        VersionMismatchException() {
            super(-30794, "Environment version mismatch");
        }
    }

    public static final class ReadersFullException
    extends LmdbNativeException {
        static final int MDB_READERS_FULL = -30790;
        private static final long serialVersionUID = 1L;

        ReadersFullException() {
            super(-30790, "Environment maxreaders reached");
        }
    }

    public static final class MapFullException
    extends LmdbNativeException {
        static final int MDB_MAP_FULL = -30792;
        private static final long serialVersionUID = 1L;

        MapFullException() {
            super(-30792, "Environment mapsize reached");
        }
    }

    public static final class InvalidCopyDestination
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public InvalidCopyDestination(String message) {
            super(message);
        }
    }

    public static final class FileInvalidException
    extends LmdbNativeException {
        static final int MDB_INVALID = -30793;
        private static final long serialVersionUID = 1L;

        FileInvalidException() {
            super(-30793, "File is not a valid LMDB file");
        }
    }

    public static final class Builder<T> {
        static final int MAX_READERS_DEFAULT = 126;
        private long mapSize = 0x100000L;
        private int maxDbs = 1;
        private int maxReaders = 126;
        private boolean opened;
        private final BufferProxy<T> proxy;

        Builder(BufferProxy<T> proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
        }

        public Env<T> open(File path, int mode, EnvFlags ... flags) {
            Objects.requireNonNull(path);
            if (this.opened) {
                throw new AlreadyOpenException();
            }
            this.opened = true;
            PointerByReference envPtr = new PointerByReference();
            ResultCodeMapper.checkRc(Library.LIB.mdb_env_create(envPtr));
            Pointer ptr = (Pointer)envPtr.getValue();
            try {
                ResultCodeMapper.checkRc(Library.LIB.mdb_env_set_mapsize(ptr, this.mapSize));
                ResultCodeMapper.checkRc(Library.LIB.mdb_env_set_maxdbs(ptr, this.maxDbs));
                ResultCodeMapper.checkRc(Library.LIB.mdb_env_set_maxreaders(ptr, this.maxReaders));
                int flagsMask = MaskedFlag.mask(flags);
                boolean readOnly = MaskedFlag.isSet(flagsMask, EnvFlags.MDB_RDONLY_ENV);
                ResultCodeMapper.checkRc(Library.LIB.mdb_env_open(ptr, path.getAbsolutePath(), flagsMask, mode));
                return new Env(this.proxy, ptr, readOnly);
            }
            catch (LmdbNativeException e) {
                Library.LIB.mdb_env_close(ptr);
                throw e;
            }
        }

        public Env<T> open(File path, EnvFlags ... flags) {
            return this.open(path, 436, flags);
        }

        public Builder<T> setMapSize(long mapSize) {
            if (this.opened) {
                throw new AlreadyOpenException();
            }
            if (mapSize < 0L) {
                throw new IllegalArgumentException("Negative value; overflow?");
            }
            this.mapSize = mapSize;
            return this;
        }

        public Builder<T> setMaxDbs(int dbs) {
            if (this.opened) {
                throw new AlreadyOpenException();
            }
            this.maxDbs = dbs;
            return this;
        }

        public Builder<T> setMaxReaders(int readers) {
            if (this.opened) {
                throw new AlreadyOpenException();
            }
            this.maxReaders = readers;
            return this;
        }
    }

    public static final class AlreadyOpenException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public AlreadyOpenException() {
            super("Environment has already been opened");
        }
    }

    public static final class AlreadyClosedException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public AlreadyClosedException() {
            super("Environment has already been closed");
        }
    }
}

