/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.Pattern;

class RepeatPattern
extends Pattern {
    private final int n;
    private final Pattern pattern;

    RepeatPattern(int n, Pattern pattern) {
        this.n = n;
        this.pattern = pattern;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        return RepeatPattern.matchRepeat(this.n, this.pattern, src, end, begin, 0);
    }

    public String toString() {
        return this.pattern.toString() + '{' + this.n + '}';
    }

    static int matchRepeat(int n, Pattern pattern, CharSequence src, int len, int from, int acc) {
        int end = from;
        for (int i = 0; i < n; ++i) {
            int l = pattern.match(src, end, len);
            if (l == -1) {
                return -1;
            }
            end += l;
        }
        return end - from + acc;
    }
}

