/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.util.Hexdump;

public class Type1Message
extends NtlmMessage {
    private static final int DEFAULT_FLAGS = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
    private static final String DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String DEFAULT_WORKSTATION;
    private String suppliedDomain;
    private String suppliedWorkstation;

    public Type1Message() {
        this(Type1Message.getDefaultFlags(), Type1Message.getDefaultDomain(), Type1Message.getDefaultWorkstation());
    }

    public Type1Message(int flags, String suppliedDomain, String suppliedWorkstation) {
        this.setFlags(Type1Message.getDefaultFlags() | flags);
        this.setSuppliedDomain(suppliedDomain);
        if (suppliedWorkstation == null) {
            suppliedWorkstation = Type1Message.getDefaultWorkstation();
        }
        this.setSuppliedWorkstation(suppliedWorkstation);
    }

    public Type1Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public String getSuppliedDomain() {
        return this.suppliedDomain;
    }

    public void setSuppliedDomain(String suppliedDomain) {
        this.suppliedDomain = suppliedDomain;
    }

    public String getSuppliedWorkstation() {
        return this.suppliedWorkstation;
    }

    public void setSuppliedWorkstation(String suppliedWorkstation) {
        this.suppliedWorkstation = suppliedWorkstation;
    }

    public byte[] toByteArray() {
        try {
            String suppliedDomain = this.getSuppliedDomain();
            String suppliedWorkstation = this.getSuppliedWorkstation();
            int flags = this.getFlags();
            boolean hostInfo = false;
            byte[] domain = new byte[]{};
            if (suppliedDomain != null && suppliedDomain.length() != 0) {
                hostInfo = true;
                flags |= 0x1000;
                domain = suppliedDomain.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                flags &= 0xFFFFEFFF;
            }
            byte[] workstation = new byte[]{};
            if (suppliedWorkstation != null && suppliedWorkstation.length() != 0) {
                hostInfo = true;
                flags |= 0x2000;
                workstation = suppliedWorkstation.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                flags &= 0xFFFFDFFF;
            }
            byte[] type1 = new byte[hostInfo ? 32 + domain.length + workstation.length : 16];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, type1, 0, 8);
            Type1Message.writeULong(type1, 8, 1);
            Type1Message.writeULong(type1, 12, flags);
            if (hostInfo) {
                Type1Message.writeSecurityBuffer(type1, 16, 32, domain);
                Type1Message.writeSecurityBuffer(type1, 24, 32 + domain.length, workstation);
            }
            return type1;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        String suppliedDomain = this.getSuppliedDomain();
        String suppliedWorkstation = this.getSuppliedWorkstation();
        return "Type1Message[suppliedDomain=" + (suppliedDomain == null ? "null" : suppliedDomain) + ",suppliedWorkstation=" + (suppliedWorkstation == null ? "null" : suppliedWorkstation) + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return DEFAULT_FLAGS;
    }

    public static String getDefaultDomain() {
        return DEFAULT_DOMAIN;
    }

    public static String getDefaultWorkstation() {
        return DEFAULT_WORKSTATION;
    }

    private void parse(byte[] material) throws IOException {
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type1Message.readULong(material, 8) != 1) {
            throw new IOException("Not a Type 1 message.");
        }
        int flags = Type1Message.readULong(material, 12);
        String suppliedDomain = null;
        if ((flags & 0x1000) != 0) {
            byte[] domain = Type1Message.readSecurityBuffer(material, 16);
            suppliedDomain = new String(domain, Type1Message.getOEMEncoding());
        }
        String suppliedWorkstation = null;
        if ((flags & 0x2000) != 0) {
            byte[] workstation = Type1Message.readSecurityBuffer(material, 24);
            suppliedWorkstation = new String(workstation, Type1Message.getOEMEncoding());
        }
        this.setFlags(flags);
        this.setSuppliedDomain(suppliedDomain);
        this.setSuppliedWorkstation(suppliedWorkstation);
    }

    static {
        String defaultWorkstation = null;
        try {
            defaultWorkstation = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DEFAULT_WORKSTATION = defaultWorkstation;
    }
}

