/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Gauge;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.ryantenney.metrics.annotation.Counted;
import com.ryantenney.metrics.annotation.Metric;
import java.lang.reflect.Member;

class Util {
    private Util() {
    }

    static String forTimedMethod(Class<?> klass, Member member, Timed annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String forMeteredMethod(Class<?> klass, Member member, Metered annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String forGauge(Class<?> klass, Member member, Gauge annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String forCachedGauge(Class<?> klass, Member member, CachedGauge annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String forExceptionMeteredMethod(Class<?> klass, Member member, ExceptionMetered annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, "exceptions");
    }

    static String forCountedMethod(Class<?> klass, Member member, com.codahale.metrics.annotation.Counted annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String forMetricField(Class<?> klass, Member member, com.codahale.metrics.annotation.Metric annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    @Deprecated
    static String forCachedGauge(Class<?> klass, Member member, com.ryantenney.metrics.annotation.CachedGauge annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    @Deprecated
    static String forCountedMethod(Class<?> klass, Member member, Counted annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    @Deprecated
    static String forMetricField(Class<?> klass, Member member, Metric annotation) {
        return Util.chooseName(annotation.name(), annotation.absolute(), klass, member, new String[0]);
    }

    static String chooseName(String explicitName, boolean absolute, Class<?> klass, Member member, String ... suffixes) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricRegistry.name((String)klass.getCanonicalName(), (String[])new String[]{explicitName});
        }
        return MetricRegistry.name((String)MetricRegistry.name((String)klass.getCanonicalName(), (String[])new String[]{member.getName()}), (String[])suffixes);
    }
}

