/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class SvnAnnotateItem {
    private long revision;
    private SVNProperties revisionProperties;
    private SVNProperties mergedRevisionProperties;
    private String line;
    private long mergedRevision;
    private String mergedPath;
    private int lineNumber;
    private File contents;
    private boolean isEof;
    private boolean isRevision;
    private boolean isLine;
    private boolean returnResult;

    public SvnAnnotateItem(boolean isEof) {
        this.isEof = true;
    }

    public SvnAnnotateItem(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) {
        this.isLine = true;
        this.revisionProperties = this.createRevisionProperties(author, date);
        this.revision = revision;
        this.line = line;
        this.mergedRevisionProperties = this.createRevisionProperties(mergedAuthor, mergedDate);
        this.mergedRevision = mergedRevision;
        this.mergedPath = mergedPath;
        this.lineNumber = lineNumber;
    }

    public SvnAnnotateItem(Date date, long revision, String author, File contents) {
        this.isRevision = true;
        this.revisionProperties = this.createRevisionProperties(author, date);
        this.revision = revision;
        this.contents = contents;
    }

    public Date getDate() {
        return this.getDate(this.getRevisionProperties());
    }

    public long getRevision() {
        return this.revision;
    }

    public SVNProperties getRevisionProperties() {
        return this.revisionProperties;
    }

    public String getAuthor() {
        return this.getAuthor(this.getRevisionProperties());
    }

    public Date getMergedDate() {
        return this.getDate(this.getMergedRevisionProperties());
    }

    public String getLine() {
        return this.line;
    }

    public long getMergedRevision() {
        return this.mergedRevision;
    }

    public SVNProperties getMergedRevisionProperties() {
        return this.mergedRevisionProperties;
    }

    public String getMergedAuthor() {
        return this.getAuthor(this.getMergedRevisionProperties());
    }

    public String getMergedPath() {
        return this.mergedPath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public File getContents() {
        return this.contents;
    }

    public boolean isEof() {
        return this.isEof;
    }

    public boolean isLine() {
        return this.isLine;
    }

    public boolean isRevision() {
        return this.isRevision;
    }

    public void setReturnResult(boolean returnResult) {
        this.returnResult = returnResult;
    }

    public boolean getReturnResult() {
        return this.returnResult;
    }

    private SVNProperties createRevisionProperties(String author, Date date) {
        if (author == null && date == null) {
            return null;
        }
        SVNProperties properties = new SVNProperties();
        if (author != null) {
            properties.put("svn:author", author);
        }
        if (date != null) {
            properties.put("svn:date", SVNDate.fromDate(date).format());
        }
        return properties;
    }

    private String getAuthor(SVNProperties revisionProperties) {
        if (revisionProperties == null) {
            return null;
        }
        return revisionProperties.getStringValue("svn:author");
    }

    private Date getDate(SVNProperties revisionProperties) {
        if (revisionProperties == null) {
            return null;
        }
        String dateString = revisionProperties.getStringValue("svn:date");
        if (dateString == null) {
            return null;
        }
        return SVNDate.parseDate(dateString);
    }
}

