/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.session.DelegatingIndexResolver;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcIndexedSessionRepository
implements FindByIndexNameSessionRepository<JdbcSession> {
    public static final String DEFAULT_TABLE_NAME = "SPRING_SESSION";
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final String CREATE_SESSION_QUERY = "INSERT INTO %TABLE_NAME% (PRIMARY_ID, SESSION_ID, CREATION_TIME, LAST_ACCESS_TIME, MAX_INACTIVE_INTERVAL, EXPIRY_TIME, PRINCIPAL_NAME) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES (SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?)";
    private static final String GET_SESSION_QUERY = "SELECT S.PRIMARY_ID, S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.PRIMARY_ID = SA.SESSION_PRIMARY_ID WHERE S.SESSION_ID = ?";
    private static final String UPDATE_SESSION_QUERY = "UPDATE %TABLE_NAME% SET SESSION_ID = ?, LAST_ACCESS_TIME = ?, MAX_INACTIVE_INTERVAL = ?, EXPIRY_TIME = ?, PRINCIPAL_NAME = ? WHERE PRIMARY_ID = ?";
    private static final String UPDATE_SESSION_ATTRIBUTE_QUERY = "UPDATE %TABLE_NAME%_ATTRIBUTES SET ATTRIBUTE_BYTES = ? WHERE SESSION_PRIMARY_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_ATTRIBUTE_QUERY = "DELETE FROM %TABLE_NAME%_ATTRIBUTES WHERE SESSION_PRIMARY_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_QUERY = "DELETE FROM %TABLE_NAME% WHERE SESSION_ID = ? AND MAX_INACTIVE_INTERVAL >= 0";
    private static final String LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT S.PRIMARY_ID, S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.PRIMARY_ID = SA.SESSION_PRIMARY_ID WHERE S.PRINCIPAL_NAME = ?";
    private static final String DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY = "DELETE FROM %TABLE_NAME% WHERE EXPIRY_TIME < ?";
    private static final Log logger = LogFactory.getLog(JdbcIndexedSessionRepository.class);
    private final JdbcOperations jdbcOperations;
    private final TransactionOperations transactionOperations;
    private final ResultSetExtractor<List<JdbcSession>> extractor = new SessionResultSetExtractor();
    private String tableName = "SPRING_SESSION";
    private String createSessionQuery;
    private String createSessionAttributeQuery;
    private String getSessionQuery;
    private String updateSessionQuery;
    private String updateSessionAttributeQuery;
    private String deleteSessionAttributeQuery;
    private String deleteSessionQuery;
    private String listSessionsByPrincipalNameQuery;
    private String deleteSessionsByExpiryTimeQuery;
    private Integer defaultMaxInactiveInterval;
    private IndexResolver<Session> indexResolver = new DelegatingIndexResolver(new IndexResolver[]{new PrincipalNameIndexResolver()});
    private ConversionService conversionService = JdbcIndexedSessionRepository.createDefaultConversionService();
    private LobHandler lobHandler = new DefaultLobHandler();
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;

    public JdbcIndexedSessionRepository(JdbcOperations jdbcOperations, TransactionOperations transactionOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations must not be null");
        Assert.notNull((Object)transactionOperations, (String)"transactionOperations must not be null");
        this.jdbcOperations = jdbcOperations;
        this.transactionOperations = transactionOperations;
        this.prepareQueries();
    }

    public void setTableName(String tableName) {
        Assert.hasText((String)tableName, (String)"Table name must not be empty");
        this.tableName = tableName.trim();
        this.prepareQueries();
    }

    public void setCreateSessionQuery(String createSessionQuery) {
        Assert.hasText((String)createSessionQuery, (String)"Query must not be empty");
        this.createSessionQuery = this.getQuery(createSessionQuery);
    }

    public void setCreateSessionAttributeQuery(String createSessionAttributeQuery) {
        Assert.hasText((String)createSessionAttributeQuery, (String)"Query must not be empty");
        this.createSessionAttributeQuery = this.getQuery(createSessionAttributeQuery);
    }

    public void setGetSessionQuery(String getSessionQuery) {
        Assert.hasText((String)getSessionQuery, (String)"Query must not be empty");
        this.getSessionQuery = this.getQuery(getSessionQuery);
    }

    public void setUpdateSessionQuery(String updateSessionQuery) {
        Assert.hasText((String)updateSessionQuery, (String)"Query must not be empty");
        this.updateSessionQuery = this.getQuery(updateSessionQuery);
    }

    public void setUpdateSessionAttributeQuery(String updateSessionAttributeQuery) {
        Assert.hasText((String)updateSessionAttributeQuery, (String)"Query must not be empty");
        this.updateSessionAttributeQuery = this.getQuery(updateSessionAttributeQuery);
    }

    public void setDeleteSessionAttributeQuery(String deleteSessionAttributeQuery) {
        Assert.hasText((String)deleteSessionAttributeQuery, (String)"Query must not be empty");
        this.deleteSessionAttributeQuery = this.getQuery(deleteSessionAttributeQuery);
    }

    public void setDeleteSessionQuery(String deleteSessionQuery) {
        Assert.hasText((String)deleteSessionQuery, (String)"Query must not be empty");
        this.deleteSessionQuery = this.getQuery(deleteSessionQuery);
    }

    public void setListSessionsByPrincipalNameQuery(String listSessionsByPrincipalNameQuery) {
        Assert.hasText((String)listSessionsByPrincipalNameQuery, (String)"Query must not be empty");
        this.listSessionsByPrincipalNameQuery = this.getQuery(listSessionsByPrincipalNameQuery);
    }

    public void setDeleteSessionsByExpiryTimeQuery(String deleteSessionsByExpiryTimeQuery) {
        Assert.hasText((String)deleteSessionsByExpiryTimeQuery, (String)"Query must not be empty");
        this.deleteSessionsByExpiryTimeQuery = this.getQuery(deleteSessionsByExpiryTimeQuery);
    }

    public void setDefaultMaxInactiveInterval(Integer defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexResolver = indexResolver;
    }

    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"LobHandler must not be null");
        this.lobHandler = lobHandler;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode must not be null");
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public JdbcSession createSession() {
        MapSession delegate = new MapSession();
        if (this.defaultMaxInactiveInterval != null) {
            delegate.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
        }
        JdbcSession session = new JdbcSession(delegate, UUID.randomUUID().toString(), true);
        session.flushIfRequired();
        return session;
    }

    public void save(JdbcSession session) {
        session.save();
    }

    public JdbcSession findById(String id) {
        JdbcSession session = (JdbcSession)this.transactionOperations.execute(status -> {
            List sessions = (List)this.jdbcOperations.query(this.getSessionQuery, ps -> ps.setString(1, id), this.extractor);
            if (sessions.isEmpty()) {
                return null;
            }
            return (JdbcSession)sessions.get(0);
        });
        if (session != null) {
            if (session.isExpired()) {
                this.deleteById(id);
            } else {
                return session;
            }
        }
        return null;
    }

    public void deleteById(String id) {
        this.transactionOperations.executeWithoutResult(status -> this.jdbcOperations.update(this.deleteSessionQuery, new Object[]{id}));
    }

    public Map<String, JdbcSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        List sessions = (List)this.transactionOperations.execute(status -> (List)this.jdbcOperations.query(this.listSessionsByPrincipalNameQuery, ps -> ps.setString(1, indexValue), this.extractor));
        HashMap<String, JdbcSession> sessionMap = new HashMap<String, JdbcSession>(sessions.size());
        for (JdbcSession session : sessions) {
            sessionMap.put(session.getId(), session);
        }
        return sessionMap;
    }

    private void insertSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        block19: {
            Assert.notEmpty(attributeNames, (String)"attributeNames must not be null or empty");
            try (final LobCreator lobCreator = this.lobHandler.getLobCreator();){
                if (attributeNames.size() > 1) {
                    try {
                        this.jdbcOperations.batchUpdate(this.createSessionAttributeQuery, new BatchPreparedStatementSetter(){

                            public void setValues(PreparedStatement ps, int i) throws SQLException {
                                String attributeName = (String)attributeNames.get(i);
                                ps.setString(1, session.primaryKey);
                                ps.setString(2, attributeName);
                                lobCreator.setBlobAsBytes(ps, 3, JdbcIndexedSessionRepository.this.serialize(session.getAttribute(attributeName)));
                            }

                            public int getBatchSize() {
                                return attributeNames.size();
                            }
                        });
                        break block19;
                    }
                    catch (DuplicateKeyException ex) {
                        throw ex;
                    }
                    catch (DataIntegrityViolationException ex) {
                        break block19;
                    }
                }
                try {
                    this.jdbcOperations.update(this.createSessionAttributeQuery, ps -> {
                        String attributeName = (String)attributeNames.get(0);
                        ps.setString(1, session.primaryKey);
                        ps.setString(2, attributeName);
                        lobCreator.setBlobAsBytes(ps, 3, this.serialize(session.getAttribute(attributeName)));
                    });
                }
                catch (DuplicateKeyException ex) {
                    throw ex;
                }
                catch (DataIntegrityViolationException dataIntegrityViolationException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        Assert.notEmpty(attributeNames, (String)"attributeNames must not be null or empty");
        try (final LobCreator lobCreator = this.lobHandler.getLobCreator();){
            if (attributeNames.size() > 1) {
                this.jdbcOperations.batchUpdate(this.updateSessionAttributeQuery, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        String attributeName = (String)attributeNames.get(i);
                        lobCreator.setBlobAsBytes(ps, 1, JdbcIndexedSessionRepository.this.serialize(session.getAttribute(attributeName)));
                        ps.setString(2, session.primaryKey);
                        ps.setString(3, attributeName);
                    }

                    public int getBatchSize() {
                        return attributeNames.size();
                    }
                });
            } else {
                this.jdbcOperations.update(this.updateSessionAttributeQuery, ps -> {
                    String attributeName = (String)attributeNames.get(0);
                    lobCreator.setBlobAsBytes(ps, 1, this.serialize(session.getAttribute(attributeName)));
                    ps.setString(2, session.primaryKey);
                    ps.setString(3, attributeName);
                });
            }
        }
    }

    private void deleteSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        Assert.notEmpty(attributeNames, (String)"attributeNames must not be null or empty");
        if (attributeNames.size() > 1) {
            this.jdbcOperations.batchUpdate(this.deleteSessionAttributeQuery, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String attributeName = (String)attributeNames.get(i);
                    ps.setString(1, session.primaryKey);
                    ps.setString(2, attributeName);
                }

                public int getBatchSize() {
                    return attributeNames.size();
                }
            });
        } else {
            this.jdbcOperations.update(this.deleteSessionAttributeQuery, ps -> {
                String attributeName = (String)attributeNames.get(0);
                ps.setString(1, session.primaryKey);
                ps.setString(2, attributeName);
            });
        }
    }

    public void cleanUpExpiredSessions() {
        Integer deletedCount = (Integer)this.transactionOperations.execute(status -> this.jdbcOperations.update(this.deleteSessionsByExpiryTimeQuery, new Object[]{System.currentTimeMillis()}));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaned up " + deletedCount + " expired sessions"));
        }
    }

    private static GenericConversionService createDefaultConversionService() {
        GenericConversionService converter = new GenericConversionService();
        converter.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        converter.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
        return converter;
    }

    private String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%TABLE_NAME%", (String)this.tableName);
    }

    private void prepareQueries() {
        this.createSessionQuery = this.getQuery(CREATE_SESSION_QUERY);
        this.createSessionAttributeQuery = this.getQuery(CREATE_SESSION_ATTRIBUTE_QUERY);
        this.getSessionQuery = this.getQuery(GET_SESSION_QUERY);
        this.updateSessionQuery = this.getQuery(UPDATE_SESSION_QUERY);
        this.updateSessionAttributeQuery = this.getQuery(UPDATE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionAttributeQuery = this.getQuery(DELETE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionQuery = this.getQuery(DELETE_SESSION_QUERY);
        this.listSessionsByPrincipalNameQuery = this.getQuery(LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY);
        this.deleteSessionsByExpiryTimeQuery = this.getQuery(DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY);
    }

    private LobHandler getLobHandler() {
        return this.lobHandler;
    }

    private byte[] serialize(Object object) {
        return (byte[])this.conversionService.convert(object, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class));
    }

    private Object deserialize(byte[] bytes) {
        return this.conversionService.convert((Object)bytes, TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    private static <T> Supplier<T> value(T value) {
        return value != null ? () -> value : null;
    }

    private static <T> Supplier<T> lazily(final Supplier<T> supplier) {
        Supplier lazySupplier = new Supplier<T>(){
            private T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
        return supplier != null ? lazySupplier : null;
    }

    private class SessionResultSetExtractor
    implements ResultSetExtractor<List<JdbcSession>> {
        private SessionResultSetExtractor() {
        }

        public List<JdbcSession> extractData(ResultSet rs) throws SQLException, DataAccessException {
            ArrayList<JdbcSession> sessions = new ArrayList<JdbcSession>();
            while (rs.next()) {
                JdbcSession session;
                String id = rs.getString("SESSION_ID");
                if (sessions.size() > 0 && this.getLast(sessions).getId().equals(id)) {
                    session = this.getLast(sessions);
                } else {
                    MapSession delegate = new MapSession(id);
                    String primaryKey = rs.getString("PRIMARY_ID");
                    delegate.setCreationTime(Instant.ofEpochMilli(rs.getLong("CREATION_TIME")));
                    delegate.setLastAccessedTime(Instant.ofEpochMilli(rs.getLong("LAST_ACCESS_TIME")));
                    delegate.setMaxInactiveInterval(Duration.ofSeconds(rs.getInt("MAX_INACTIVE_INTERVAL")));
                    session = new JdbcSession(delegate, primaryKey, false);
                }
                String attributeName = rs.getString("ATTRIBUTE_NAME");
                if (attributeName != null) {
                    byte[] bytes = JdbcIndexedSessionRepository.this.getLobHandler().getBlobAsBytes(rs, "ATTRIBUTE_BYTES");
                    session.delegate.setAttribute(attributeName, (Object)JdbcIndexedSessionRepository.lazily(() -> JdbcIndexedSessionRepository.this.deserialize(bytes)));
                }
                sessions.add(session);
            }
            return sessions;
        }

        private JdbcSession getLast(List<JdbcSession> sessions) {
            return sessions.get(sessions.size() - 1);
        }
    }

    final class JdbcSession
    implements Session {
        private final Session delegate;
        private final String primaryKey;
        private boolean isNew;
        private boolean changed;
        private Map<String, DeltaValue> delta = new HashMap<String, DeltaValue>();

        JdbcSession(MapSession delegate, String primaryKey, boolean isNew) {
            this.delegate = delegate;
            this.primaryKey = primaryKey;
            this.isNew = isNew;
            if (this.isNew || JdbcIndexedSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put((String)attributeName, DeltaValue.UPDATED));
            }
        }

        boolean isNew() {
            return this.isNew;
        }

        boolean isChanged() {
            return this.changed;
        }

        Map<String, DeltaValue> getDelta() {
            return this.delta;
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.changed = false;
            this.delta.clear();
        }

        Instant getExpiryTime() {
            if (this.getMaxInactiveInterval().isNegative()) {
                return Instant.ofEpochMilli(Long.MAX_VALUE);
            }
            return this.getLastAccessedTime().plus(this.getMaxInactiveInterval());
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String changeSessionId() {
            this.changed = true;
            return this.delegate.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            Supplier supplier = (Supplier)this.delegate.getAttribute(attributeName);
            if (supplier == null) {
                return null;
            }
            Object attributeValue = supplier.get();
            if (attributeValue != null && JdbcIndexedSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(attributeName, DeltaValue.UPDATED);
            }
            return attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            boolean attributeRemoved;
            boolean attributeExists = this.delegate.getAttribute(attributeName) != null;
            boolean bl = attributeRemoved = attributeValue == null;
            if (!attributeExists && attributeRemoved) {
                return;
            }
            if (attributeExists) {
                if (attributeRemoved) {
                    this.delta.merge(attributeName, DeltaValue.REMOVED, (oldDeltaValue, deltaValue) -> oldDeltaValue == DeltaValue.ADDED ? null : deltaValue);
                } else {
                    this.delta.merge(attributeName, DeltaValue.UPDATED, (oldDeltaValue, deltaValue) -> oldDeltaValue == DeltaValue.ADDED ? oldDeltaValue : deltaValue);
                }
            } else {
                this.delta.merge(attributeName, DeltaValue.ADDED, (oldDeltaValue, deltaValue) -> oldDeltaValue == DeltaValue.ADDED ? oldDeltaValue : DeltaValue.UPDATED);
            }
            this.delegate.setAttribute(attributeName, (Object)JdbcIndexedSessionRepository.value(attributeValue));
            if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(attributeName) || JdbcIndexedSessionRepository.SPRING_SECURITY_CONTEXT.equals(attributeName)) {
                this.changed = true;
            }
            this.flushIfRequired();
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.changed = true;
            this.flushIfRequired();
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.delegate.setMaxInactiveInterval(interval);
            this.changed = true;
            this.flushIfRequired();
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        private void flushIfRequired() {
            if (JdbcIndexedSessionRepository.this.flushMode == FlushMode.IMMEDIATE) {
                this.save();
            }
        }

        private void save() {
            if (this.isNew) {
                JdbcIndexedSessionRepository.this.transactionOperations.executeWithoutResult(status -> {
                    Map indexes = JdbcIndexedSessionRepository.this.indexResolver.resolveIndexesFor((Session)this);
                    JdbcIndexedSessionRepository.this.jdbcOperations.update(JdbcIndexedSessionRepository.this.createSessionQuery, ps -> {
                        ps.setString(1, this.primaryKey);
                        ps.setString(2, this.getId());
                        ps.setLong(3, this.getCreationTime().toEpochMilli());
                        ps.setLong(4, this.getLastAccessedTime().toEpochMilli());
                        ps.setInt(5, (int)this.getMaxInactiveInterval().getSeconds());
                        ps.setLong(6, this.getExpiryTime().toEpochMilli());
                        ps.setString(7, (String)indexes.get(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME));
                    });
                    Set<String> attributeNames = this.getAttributeNames();
                    if (!attributeNames.isEmpty()) {
                        JdbcIndexedSessionRepository.this.insertSessionAttributes(this, new ArrayList<String>(attributeNames));
                    }
                });
            } else {
                JdbcIndexedSessionRepository.this.transactionOperations.executeWithoutResult(status -> {
                    List removedAttributeNames;
                    List updatedAttributeNames;
                    List addedAttributeNames;
                    if (this.changed) {
                        Map indexes = JdbcIndexedSessionRepository.this.indexResolver.resolveIndexesFor((Session)this);
                        JdbcIndexedSessionRepository.this.jdbcOperations.update(JdbcIndexedSessionRepository.this.updateSessionQuery, ps -> {
                            ps.setString(1, this.getId());
                            ps.setLong(2, this.getLastAccessedTime().toEpochMilli());
                            ps.setInt(3, (int)this.getMaxInactiveInterval().getSeconds());
                            ps.setLong(4, this.getExpiryTime().toEpochMilli());
                            ps.setString(5, (String)indexes.get(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME));
                            ps.setString(6, this.primaryKey);
                        });
                    }
                    if (!(addedAttributeNames = this.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.ADDED).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                        JdbcIndexedSessionRepository.this.insertSessionAttributes(this, addedAttributeNames);
                    }
                    if (!(updatedAttributeNames = this.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.UPDATED).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                        JdbcIndexedSessionRepository.this.updateSessionAttributes(this, updatedAttributeNames);
                    }
                    if (!(removedAttributeNames = this.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.REMOVED).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                        JdbcIndexedSessionRepository.this.deleteSessionAttributes(this, removedAttributeNames);
                    }
                });
            }
            this.clearChangeFlags();
        }
    }

    private static enum DeltaValue {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

