/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCustomizeCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;

public class ChecksCopyCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "copy"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        String string = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        object = ((CommandScope)object).getConfiguredValue(CHECK_NAME_ARG).getValue();
        CheckSettingsConfigHelper checkSettingsConfigHelper = new CheckSettingsConfigHelper(string);
        List<AbstractLiquibaseRule> list = ChecksCopyCommandStep.listAllRules();
        CheckSettingsConfig checkSettingsConfig = checkSettingsConfigHelper.read(list);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        ChecksCopyCommandStep.doCopy(checkSettingsConfig, (String)object, list, string, commandResultsBuilder, checkSettingsConfigHelper);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public static void doCopy(CheckSettingsConfig checkSettingsConfig, String object2, List<AbstractLiquibaseRule> object3, String string2, CommandResultsBuilder commandResultsBuilder, CheckSettingsConfigHelper checkSettingsConfigHelper) {
        DynamicRule dynamicRule = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)object2, "does not have customization options and can't be copied because it would be redundant with the original check");
        object3 = ChecksCopyCommandStep.findConfigurableParentRule(dynamicRule, object3, (String)object2, "does not have customization options and can't be copied because it would be redundant with the original check");
        if (((AbstractLiquibaseRule)object3).getParameters().isEmpty()) {
            throw new CommandExecutionException("\n\nCheck '" + (String)object2 + "' does not have customization options." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        String string3 = ChecksCopyCommandStep.createDefaultName((String)object2, checkSettingsConfig);
        string3 = Scope.getCurrentScope().getUI().prompt("\nGive your check a short name for easier identification (up to 64 alpha-numeric characters only)", string3, (string, object) -> {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            object = string;
            if (!((String)((Object)object)).chars().allMatch(Character::isLetterOrDigit)) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': Only alpha-numeric characters are allowed for a short name", string));
            }
            if (((String)((Object)object)).length() > 64) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': New check name '%s' exceeds %s characters.  Please try again", string, object, 64));
            }
            if (checkSettingsConfig.getDynamicRuleByShortName((String)((Object)object)) != null) {
                throw new IllegalArgumentException(String.format("Invalid value: '%s': A check with the short name '%s' already exists", string, object));
            }
            return string;
        }, String.class);
        Scope.getCurrentScope().getUI().sendMessage(String.format("New check '%s' created from '%s'\n", string3, object2));
        object2 = ChecksCopyCommandStep.createCopyFromOriginal(dynamicRule, string3, (AbstractLiquibaseRule)object3);
        ChecksCopyCommandStep.modifySeverity((AbstractConfigurableRule)object2);
        object3 = ChecksCustomizeCommandStep.promptForParameters(((AbstractLiquibaseRule)object3).getParameters(), dynamicRule);
        ((DynamicRule)object2).getParameters().addAll((Collection<DynamicRuleParameter>)object3);
        checkSettingsConfig.getRules().add((AbstractConfigurableRule)object2);
        checkSettingsConfigHelper.write(checkSettingsConfig);
        Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
    }

    private static String createDefaultName(String string, CheckSettingsConfig checkSettingsConfig) {
        int n2;
        Object object = Pattern.compile(".*(\\d+$)").matcher(string);
        if (!((Matcher)object).find()) {
            n2 = 1;
        } else {
            object = ((Matcher)object).group(1);
            string = string.replaceAll((String)object, "");
            n2 = Integer.parseInt((String)object) + 1;
        }
        String string2 = null;
        boolean bl2 = false;
        while (!bl2) {
            string2 = string + Integer.valueOf(n2).toString();
            if (checkSettingsConfig.getDynamicRuleByShortName(string2) == null) {
                bl2 = true;
                continue;
            }
            ++n2;
        }
        return string2;
    }

    private static DynamicRule createCopyFromOriginal(DynamicRule dynamicRule, String string, AbstractLiquibaseRule abstractLiquibaseRule) {
        boolean bl2 = !abstractLiquibaseRule.hasDefaultParameterValues() || dynamicRule.isEnabled();
        return new DynamicRule(bl2, dynamicRule.getSeverity(), UUID.nameUUIDFromBytes(StringUtil.getBytesWithEncoding(string)), string, dynamicRule.getName(), dynamicRule.getDescription(), dynamicRule.getParentRuleId() != null ? dynamicRule.getParentRuleId() : dynamicRule.getId(), new ArrayList<DynamicRuleParameter>());
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Create a copy of an existing check and provide new customization options for the copy");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

