/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;

public class OctetString
extends AbstractVariable
implements AssignableFromByteArray,
AssignableFromString {
    private static final long serialVersionUID = 4125661211046256289L;
    private static final char DEFAULT_HEX_DELIMITER = ':';
    private byte[] value = new byte[0];

    public OctetString() {
    }

    public OctetString(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public OctetString(byte[] byArray, int n, int n2) {
        this.value = new byte[n2];
        System.arraycopy(byArray, n, this.value, 0, n2);
    }

    public OctetString(String string) {
        this.value = string.getBytes();
    }

    public OctetString(OctetString octetString) {
        this.value = new byte[0];
        this.append(octetString);
    }

    public void append(byte by) {
        byte[] byArray = new byte[this.value.length + 1];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        byArray[this.value.length] = by;
        this.value = byArray;
    }

    public void append(byte[] byArray) {
        byte[] byArray2 = new byte[this.value.length + byArray.length];
        System.arraycopy(this.value, 0, byArray2, 0, this.value.length);
        System.arraycopy(byArray, 0, byArray2, this.value.length, byArray.length);
        this.value = byArray2;
    }

    public void append(OctetString octetString) {
        this.append(octetString.getValue());
    }

    public void append(String string) {
        this.append(string.getBytes());
    }

    public void clear() {
        this.value = new byte[0];
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeString(outputStream, (byte)4, this.getValue());
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        byte[] byArray = BER.decodeString(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 4) {
            throw new IOException("Wrong type encountered when decoding OctetString: " + mutableByte.getValue());
        }
        this.setValue(byArray);
    }

    public int getBERLength() {
        return this.value.length + BER.getBERLengthOfLength(this.value.length) + 1;
    }

    public int getSyntax() {
        return 4;
    }

    public final byte get(int n) {
        return this.value[n];
    }

    public final void set(int n, byte by) {
        this.value[n] = by;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n += this.value[i] * 31 ^ this.value.length - 1 - i;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            return Arrays.equals(this.value, octetString.value);
        }
        if (object instanceof byte[]) {
            return Arrays.equals(this.value, (byte[])object);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            int n = Math.min(this.value.length, octetString.value.length);
            for (int i = 0; i < n; ++i) {
                if (this.value[i] == octetString.value[i]) continue;
                if ((this.value[i] & 0xFF) < (octetString.value[i] & 0xFF)) {
                    return -1;
                }
                return 1;
            }
            return this.value.length - octetString.value.length;
        }
        throw new ClassCastException(object.getClass().getName());
    }

    public OctetString substring(int n, int n2) {
        if (n < 0 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n2 - n];
        System.arraycopy(this.value, n, byArray, 0, byArray.length);
        return new OctetString(byArray);
    }

    public boolean startsWith(OctetString octetString) {
        if (octetString == null || octetString.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < octetString.length(); ++i) {
            if (octetString.get(i) == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isPrintable() {
        for (int i = 0; i < this.value.length; ++i) {
            char c = (char)this.value[i];
            if (!Character.isISOControl(c) && (this.value[i] & 0xFF) < 128 || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isPrintable()) {
            return new String(this.value);
        }
        return this.toHexString();
    }

    public String toHexString() {
        return this.toHexString(':');
    }

    public String toHexString(char c) {
        return this.toString(c, 16);
    }

    public static OctetString fromHexString(String string) {
        return OctetString.fromHexString(string, ':');
    }

    public static OctetString fromHexString(String string, char c) {
        return OctetString.fromString(string, c, 16);
    }

    public static OctetString fromString(String string, char c, int n) {
        String string2 = "";
        string2 = string2 + c;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            byArray[n2] = (byte)Integer.parseInt(string3, n);
            ++n2;
        }
        return new OctetString(byArray);
    }

    public static OctetString fromString(String string, int n) {
        int n2 = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(n));
        byte[] byArray = new byte[string.length() / n2];
        for (int i = 0; i < string.length(); i += n2) {
            String string2 = string.substring(i, i + n2);
            byArray[i / n2] = (byte)Integer.parseInt(string2, n);
        }
        return new OctetString(byArray);
    }

    public String toString(char c, int n) {
        int n2 = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(n));
        StringBuffer stringBuffer = new StringBuffer(this.value.length * (n2 + 1));
        for (int i = 0; i < this.value.length; ++i) {
            if (i > 0) {
                stringBuffer.append(c);
            }
            int n3 = this.value[i] & 0xFF;
            String string = Integer.toString(n3, n);
            for (int j = 0; j < n2 - string.length(); ++j) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString(int n) {
        int n2 = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(n));
        StringBuffer stringBuffer = new StringBuffer(this.value.length * (n2 + 1));
        for (int i = 0; i < this.value.length; ++i) {
            int n3 = this.value[i] & 0xFF;
            String string = Integer.toString(n3, n);
            for (int j = 0; j < n2 - string.length(); ++j) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toASCII(char c) {
        StringBuffer stringBuffer = new StringBuffer(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            if (Character.isISOControl((char)this.value[i]) || (this.value[i] & 0xFF) >= 128) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append((char)this.value[i]);
        }
        return stringBuffer.toString();
    }

    public void setValue(String string) {
        this.setValue(string.getBytes());
    }

    public void setValue(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("OctetString must not be assigned a null value");
        }
        this.value = byArray;
    }

    public byte[] getValue() {
        return this.value;
    }

    public final int length() {
        return this.value.length;
    }

    public Object clone() {
        return new OctetString(this.value);
    }

    public int getBERPayloadLength() {
        return this.value.length;
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OctetString mask(OctetString octetString) {
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        for (int i = 0; i < octetString.length() && i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] & octetString.get(i));
        }
        return new OctetString(byArray);
    }

    public OID toSubIndex(boolean bl) {
        int[] nArray;
        int n = 0;
        if (!bl) {
            nArray = new int[this.length() + 1];
            nArray[n++] = this.length();
        } else {
            nArray = new int[this.length()];
        }
        for (int i = 0; i < this.length(); ++i) {
            nArray[n + i] = this.get(i) & 0xFF;
        }
        return new OID(nArray);
    }

    public void fromSubIndex(OID oID, boolean bl) {
        if (bl) {
            this.setValue(oID.toByteArray());
        } else {
            OID oID2 = new OID(oID.getValue(), 1, oID.size() - 1);
            this.setValue(oID2.toByteArray());
        }
    }

    public static final Collection split(OctetString octetString, OctetString octetString2) {
        int n;
        int n2;
        LinkedList<OctetString> linkedList = new LinkedList<OctetString>();
        int n3 = -1;
        for (n2 = 0; n2 < octetString2.length(); ++n2) {
            n = octetString2.get(n2) & 0xFF;
            if (n <= n3) continue;
            n3 = n;
        }
        n2 = 0;
        for (n = 0; n < octetString.length(); ++n) {
            int n4 = octetString.value[n] & 0xFF;
            boolean bl = false;
            if (n4 <= n3) {
                for (int i = 0; i < octetString2.length(); ++i) {
                    if (n4 != (octetString2.get(i) & 0xFF)) continue;
                    if (n2 >= 0 && n > n2) {
                        linkedList.add(new OctetString(octetString.value, n2, n - n2));
                    }
                    n2 = -1;
                    bl = true;
                }
            }
            if (bl || n2 >= 0) continue;
            n2 = n;
        }
        if (n2 >= 0) {
            linkedList.add(new OctetString(octetString.value, n2, octetString.length() - n2));
        }
        return linkedList;
    }

    public static OctetString fromByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new OctetString(byArray);
    }

    public byte[] toByteArray() {
        return this.getValue();
    }
}

