/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class Slf4jReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<Slf4jReporter> {
    public static final String PERIOD = "period";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";
    public static final String MARKER = "marker";
    public static final String LOGGER = "logger";
    public static final String LEVEL = "level";

    @Override
    public Class<Slf4jReporter> getObjectType() {
        return Slf4jReporter.class;
    }

    @Override
    protected Slf4jReporter createInstance() {
        Slf4jReporter.Builder reporter = Slf4jReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        reporter.prefixedWith(this.getPrefix());
        if (this.hasProperty(MARKER)) {
            reporter.markWith(MarkerFactory.getMarker((String)this.getProperty(MARKER)));
        }
        if (this.hasProperty(LOGGER)) {
            reporter.outputTo(LoggerFactory.getLogger((String)this.getProperty(LOGGER)));
        }
        if (this.hasProperty(LEVEL)) {
            reporter.withLoggingLevel(this.getProperty(LEVEL, Slf4jReporter.LoggingLevel.class));
        }
        return reporter.build();
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }
}

