/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.grant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class Grant
implements Statement {
    private String role;
    private List<String> privileges;
    private List<String> objectName = new ArrayList<String>();
    private List<String> users;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<String> list) {
        this.privileges = list;
    }

    public String getObjectName() {
        if (this.objectName.size() == 0) {
            return null;
        }
        return this.objectName.stream().map(string -> {
            if (string == null) {
                return "";
            }
            return string;
        }).collect(Collectors.joining("."));
    }

    public List<String> getObjectNameParts() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName.clear();
        this.objectName.add(string);
    }

    public void setObjectName(List<String> list) {
        this.objectName.clear();
        this.objectName.addAll(list);
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> list) {
        this.users = list;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GRANT ");
        if (this.role != null) {
            stringBuilder.append(this.role);
        } else {
            for (n2 = 0; n2 < this.getPrivileges().size(); ++n2) {
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.privileges.get(n2));
            }
            stringBuilder.append(" ON ");
            stringBuilder.append(this.getObjectName());
        }
        stringBuilder.append(" TO ");
        for (n2 = 0; n2 < this.getUsers().size(); ++n2) {
            if (n2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.users.get(n2));
        }
        return stringBuilder.toString();
    }

    public Grant withRole(String string) {
        this.setRole(string);
        return this;
    }

    public Grant withPrivileges(List<String> list) {
        this.setPrivileges(list);
        return this;
    }

    public Grant withObjectName(String string) {
        this.setObjectName(string);
        return this;
    }

    public Grant withObjectName(List<String> list) {
        this.setObjectName(list);
        return this;
    }

    public Grant withUsers(List<String> list) {
        this.setUsers(list);
        return this;
    }

    public Grant addPrivileges(String ... stringArray) {
        List list = Optional.ofNullable(this.getPrivileges()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withPrivileges(list);
    }

    public Grant addPrivileges(Collection<String> collection) {
        List list = Optional.ofNullable(this.getPrivileges()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withPrivileges(list);
    }

    public Grant addUsers(String ... stringArray) {
        List list = Optional.ofNullable(this.getUsers()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withUsers(list);
    }

    public Grant addUsers(Collection<String> collection) {
        List list = Optional.ofNullable(this.getUsers()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withUsers(list);
    }
}

