/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.qpid.jms.JmsConnectionConsumer;
import org.apache.qpid.jms.JmsConnectionListener;
import org.apache.qpid.jms.JmsConnectionMetaData;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.JmsMessageProducer;
import org.apache.qpid.jms.JmsQueueSession;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.JmsTemporaryQueue;
import org.apache.qpid.jms.JmsTemporaryTopic;
import org.apache.qpid.jms.JmsTopicSession;
import org.apache.qpid.jms.exceptions.JmsConnectionFailedException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsMessageTransformation;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionId;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.tracing.JmsTracer;
import org.apache.qpid.jms.util.FifoMessageQueue;
import org.apache.qpid.jms.util.MessageQueue;
import org.apache.qpid.jms.util.PriorityMessageQueue;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.apache.qpid.jms.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnection
implements AutoCloseable,
Connection,
TopicConnection,
QueueConnection,
ProviderListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnection.class);
    private final Map<JmsSessionId, JmsSession> sessions = new ConcurrentHashMap<JmsSessionId, JmsSession>();
    private final Map<JmsConsumerId, JmsConnectionConsumer> connectionConsumers = new ConcurrentHashMap<JmsConsumerId, JmsConnectionConsumer>();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicReference<Exception> failureCause = new AtomicReference();
    private final JmsConnectionInfo connectionInfo;
    private final ThreadPoolExecutor executor;
    private ExceptionListener exceptionListener;
    private JmsMessageFactory messageFactory;
    private Provider provider;
    private final Set<JmsConnectionListener> connectionListeners = new CopyOnWriteArraySet<JmsConnectionListener>();
    private final Map<JmsTemporaryDestination, JmsTemporaryDestination> tempDestinations = new ConcurrentHashMap<JmsTemporaryDestination, JmsTemporaryDestination>();
    private final AtomicLong sessionIdGenerator = new AtomicLong();
    private final AtomicLong tempDestIdGenerator = new AtomicLong();
    private final AtomicLong transactionIdGenerator = new AtomicLong();
    private final AtomicLong connectionConsumerIdGenerator = new AtomicLong();
    private final Map<AsyncResult, AsyncResult> requests = new ConcurrentHashMap<AsyncResult, AsyncResult>();

    protected JmsConnection(JmsConnectionInfo connectionInfo, Provider provider) throws JMSException {
        this.executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new QpidJMSThreadFactory("QpidJMS Connection Executor: " + connectionInfo.getId(), connectionInfo.isUseDaemonThread()));
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.provider = provider;
        this.provider.setProviderListener(this);
        try {
            this.provider.start();
        }
        catch (Exception e) {
            this.executor.shutdown();
            throw JmsExceptionSupport.create(e);
        }
        this.connectionInfo = connectionInfo;
        this.connectionInfo.setConnection(this);
    }

    JmsConnection connect() throws JMSException {
        if (this.provider == null) {
            throw new IllegalStateException("Remote provider instance not set.");
        }
        try {
            this.provider.connect(this.connectionInfo);
        }
        catch (Exception ex) {
            URI remoteURI = this.connectionInfo.getConfiguredURI();
            LOG.error("Failed to connect to remote at: {}", (Object)(remoteURI.getScheme() + "://" + remoteURI.getHost() + ":" + remoteURI.getPort()));
            LOG.trace("Error: ", (Throwable)ex);
            try {
                this.provider.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.executor.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw JmsExceptionSupport.create(ex);
        }
        if (this.connectionInfo.isExplicitClientID() || !this.connectionInfo.isAwaitClientID()) {
            this.createJmsConnection();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        boolean interrupted = Thread.interrupted();
        for (JmsSession session : this.sessions.values()) {
            session.checkIsDeliveryThread();
            session.checkIsCompletionThread();
        }
        try {
            if (!this.closed.get() && !this.isFailed()) {
                this.doStop(false);
            }
            JmsConnection jmsConnection = this;
            synchronized (jmsConnection) {
                block31: {
                    if (!this.closed.get()) break block31;
                    return;
                }
                this.closing.set(true);
                for (JmsSession session : this.sessions.values()) {
                    session.shutdown();
                }
                for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
                    connectionConsumer.shutdown();
                }
                if (this.isConnected() && !this.isFailed()) {
                    ProviderFuture request = this.provider.newProviderFuture();
                    this.requests.put(request, request);
                    try {
                        this.provider.destroy(this.connectionInfo, request);
                        try {
                            request.sync();
                        }
                        catch (Exception ex) {
                            if (ex.getCause() instanceof InterruptedException) {
                                throw (InterruptedException)ex.getCause();
                            }
                            LOG.debug("Failed destroying Connection resource: {}", (Object)ex.getMessage());
                        }
                    }
                    catch (ProviderException prodiverError) {
                        LOG.debug("Ignoring provider exception during connection close");
                    }
                    finally {
                        this.requests.remove(request);
                    }
                }
                this.sessions.clear();
                this.tempDestinations.clear();
                this.connected.set(false);
                this.started.set(false);
                this.closing.set(false);
                this.closed.set(true);
                this.connectionInfo.getTracer().close();
            }
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
        finally {
            try {
                ThreadPoolUtils.shutdown(this.executor);
            }
            catch (Throwable e) {
                LOG.warn("Error shutting down thread pool: " + this.executor + ". This exception will be ignored.", e);
            }
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Exception cause) throws JMSException {
        this.connectionInfo.setState(JmsResource.ResourceState.CLOSED);
        for (JmsSession session : this.sessions.values()) {
            session.shutdown(cause);
        }
        for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
            connectionConsumer.shutdown();
        }
        if (this.isConnected() && !this.isFailed() && !this.closing.get()) {
            this.destroyResource(this.connectionInfo);
        }
        this.tempDestinations.clear();
        this.started.set(false);
        this.connected.set(false);
    }

    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public Session createSession(int acknowledgeMode) throws JMSException {
        return this.createSession(acknowledgeMode == 0, acknowledgeMode);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsSession result = new JmsSession(this, this.getNextSessionId(), ackMode);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public synchronized String getClientID() throws JMSException {
        this.checkClosedOrFailed();
        return this.connected.get() ? this.connectionInfo.getClientId() : null;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosedOrFailed();
        return JmsConnectionMetaData.INSTANCE;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        this.checkClosedOrFailed();
        if (this.connectionInfo.isExplicitClientID()) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (clientID == null || clientID.isEmpty()) {
            throw new InvalidClientIDException("Cannot have a null or empty clientID");
        }
        if (this.connected.get()) {
            throw new IllegalStateException("Cannot set the client id once connected.");
        }
        this.connectionInfo.setClientId(clientID, true);
        this.createJmsConnection();
    }

    public void start() throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        if (this.started.compareAndSet(false, true)) {
            try {
                for (JmsSession session : this.sessions.values()) {
                    session.start();
                }
                for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
                    connectionConsumer.start();
                }
            }
            catch (Exception e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    public void stop() throws JMSException {
        this.doStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop(boolean checkClosed) throws JMSException {
        if (checkClosed) {
            this.checkClosedOrFailed();
        }
        for (JmsSession session : this.sessions.values()) {
            session.checkIsDeliveryThread();
        }
        if (this.started.compareAndSet(true, false)) {
            Map<JmsConsumerId, JmsConnectionConsumer> map = this.sessions;
            synchronized (map) {
                for (JmsSession session : this.sessions.values()) {
                    session.stop();
                }
            }
            map = this.connectionConsumers;
            synchronized (map) {
                for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
                    connectionConsumer.stop();
                }
            }
        }
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, subscriptionName, false, true);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, subscriptionName, true, true);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, subscriptionName, true, false);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages, null, false, false);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages, null, false, false);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        return this.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages, null, false, false);
    }

    private ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, boolean durable, boolean shared) throws JMSException {
        JmsDestination jmsDestination = JmsMessageTransformation.transformDestination(this, destination);
        int configuredPrefetch = this.getPrefetchPolicy().getConfiguredPrefetch(null, jmsDestination, durable, false);
        MessageQueue messageQueue = this.isLocalMessagePriority() ? new PriorityMessageQueue() : new FifoMessageQueue(configuredPrefetch);
        JmsConsumerInfo consumerInfo = new JmsConsumerInfo(this.getNextConnectionConsumerId(), null);
        consumerInfo.setExplicitClientID(this.isExplicitClientID());
        consumerInfo.setSelector(messageSelector);
        consumerInfo.setDurable(durable);
        consumerInfo.setSubscriptionName(subscriptionName);
        consumerInfo.setShared(shared);
        consumerInfo.setDestination(jmsDestination);
        consumerInfo.setAcknowledgementMode(1);
        consumerInfo.setNoLocal(false);
        consumerInfo.setBrowser(false);
        consumerInfo.setPrefetchSize(configuredPrefetch);
        consumerInfo.setRedeliveryPolicy(this.getRedeliveryPolicy().copy());
        consumerInfo.setLocalMessageExpiry(this.isLocalMessageExpiry());
        consumerInfo.setPresettle(false);
        consumerInfo.setDeserializationPolicy(this.getDeserializationPolicy().copy());
        consumerInfo.setMaxMessages(maxMessages);
        consumerInfo.setConnectionConsumer(true);
        JmsConnectionConsumer consumer = new JmsConnectionConsumer(this, consumerInfo, messageQueue, sessionPool);
        try {
            consumer.init();
            if (this.started.get()) {
                consumer.start();
            }
            return consumer;
        }
        catch (JMSException jmsEx) {
            consumer.close();
            throw jmsEx;
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsTopicSession result = new JmsTopicSession(this, this.getNextSessionId(), ackMode);
        this.addSession(result.getSessionInfo(), result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosedOrFailed();
        this.createJmsConnection();
        int ackMode = this.getSessionAcknowledgeMode(transacted, acknowledgeMode);
        JmsQueueSession result = new JmsQueueSession(this, this.getNextSessionId(), ackMode);
        this.addSession(result.getSessionInfo(), result);
        if (this.started.get()) {
            result.start();
        }
        return result;
    }

    public void onException(Exception ex) {
        this.onException(JmsExceptionSupport.create(ex));
    }

    public void onException(JMSException ex) {
        ExceptionListener listener = this.exceptionListener;
        if (listener != null) {
            listener.onException(JmsExceptionSupport.create(ex));
        }
    }

    protected int getSessionAcknowledgeMode(boolean transacted, int acknowledgeMode) throws JMSException {
        int result = acknowledgeMode;
        if (!transacted && acknowledgeMode == 0) {
            throw new JMSException("acknowledgeMode SESSION_TRANSACTED cannot be used for an non-transacted Session");
        }
        if (transacted) {
            result = 0;
        } else {
            try {
                JmsSession.validateSessionMode(acknowledgeMode);
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException("acknowledgeMode " + acknowledgeMode + " cannot be used for an non-transacted Session");
            }
        }
        return result;
    }

    protected void removeSession(JmsSessionInfo sessionInfo) {
        this.sessions.remove(sessionInfo.getId());
    }

    protected void addSession(JmsSessionInfo sessionInfo, JmsSession session) {
        this.sessions.put(sessionInfo.getId(), session);
    }

    protected void removeConnectionConsumer(JmsConsumerInfo consumerInfo) {
        this.connectionConsumers.remove(consumerInfo.getId());
    }

    protected void addConnectionConsumer(JmsConsumerInfo consumerInfo, JmsConnectionConsumer consumer) {
        this.connectionConsumers.put(consumerInfo.getId(), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJmsConnection() throws JMSException {
        if (this.isConnected() || this.closed.get()) {
            return;
        }
        JmsConnectionInfo jmsConnectionInfo = this.connectionInfo;
        synchronized (jmsConnectionInfo) {
            if (this.isConnected() || this.closed.get()) {
                return;
            }
            if (this.connectionInfo.getClientId() == null || this.connectionInfo.getClientId().trim().isEmpty()) {
                throw new IllegalArgumentException("Client ID cannot be null or empty string");
            }
            this.createResource(this.connectionInfo);
            this.connected.set(true);
        }
    }

    protected TemporaryQueue createTemporaryQueue() throws JMSException {
        String destinationName = this.connectionInfo.getId() + ":" + this.tempDestIdGenerator.incrementAndGet();
        JmsTemporaryQueue queue = new JmsTemporaryQueue(destinationName);
        this.createResource(queue);
        this.tempDestinations.put(queue, queue);
        queue.setConnection(this);
        return queue;
    }

    protected TemporaryTopic createTemporaryTopic() throws JMSException {
        String destinationName = this.connectionInfo.getId() + ":" + this.tempDestIdGenerator.incrementAndGet();
        JmsTemporaryTopic topic = new JmsTemporaryTopic(destinationName);
        this.createResource(topic);
        this.tempDestinations.put(topic, topic);
        topic.setConnection(this);
        return topic;
    }

    protected void deleteTemporaryDestination(JmsTemporaryDestination destination) throws JMSException {
        this.checkClosedOrFailed();
        try {
            for (JmsSession session : this.sessions.values()) {
                if (!session.isDestinationInUse(destination)) continue;
                throw new IllegalStateException("A consumer is consuming from the temporary destination");
            }
            this.tempDestinations.remove(destination);
            this.destroyResource(destination);
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    protected void checkClosedOrFailed() throws JMSException {
        this.checkClosed();
        if (this.failureCause.get() != null) {
            throw new JmsConnectionFailedException(this.failureCause.get());
        }
    }

    protected void checkConsumeFromTemporaryDestination(JmsTemporaryDestination destination) throws JMSException {
        if (!this.equals(destination.getConnection())) {
            throw new InvalidDestinationException("Can't consume from a temporary destination created using another connection");
        }
    }

    protected boolean isTemporaryDestinationDeleted(JmsDestination destination) {
        return !this.tempDestinations.containsKey(destination);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The Connection is closed");
        }
    }

    protected JmsSessionId getNextSessionId() {
        return new JmsSessionId(this.connectionInfo.getId(), this.sessionIdGenerator.incrementAndGet());
    }

    protected JmsTransactionId getNextTransactionId() {
        return new JmsTransactionId(this.connectionInfo.getId(), this.transactionIdGenerator.incrementAndGet());
    }

    protected JmsConsumerId getNextConnectionConsumerId() {
        return new JmsConsumerId(this.connectionInfo.getId().toString(), -1L, this.connectionConsumerIdGenerator.incrementAndGet());
    }

    protected synchronized boolean isExplicitClientID() {
        return this.connectionInfo.isExplicitClientID();
    }

    void createResource(JmsResource resource) throws JMSException {
        this.createResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createResource(JmsResource resource, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.create(resource, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ex) {
            throw JmsExceptionSupport.create(ex);
        }
    }

    void startResource(JmsResource resource) throws JMSException {
        this.startResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startResource(JmsResource resource, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.start(resource, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void stopResource(JmsResource resource) throws JMSException {
        this.stopResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopResource(JmsResource resource, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.stop(resource, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void destroyResource(JmsResource resource) throws JMSException {
        this.destroyResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyResource(JmsResource resource, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.destroy(resource, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(JmsOutboundMessageDispatch envelope, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.send(envelope, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        this.acknowledge(envelope, ackType, null);
    }

    void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.provider.acknowledge(envelope, ackType, (AsyncResult)request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void acknowledge(JmsSessionId sessionId, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        this.acknowledge(sessionId, ackType, null);
    }

    void acknowledge(JmsSessionId sessionId, ProviderConstants.ACK_TYPE ackType, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.provider.acknowledge(sessionId, ackType, (AsyncResult)request);
            request.sync();
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void unsubscribe(String name) throws JMSException {
        this.unsubscribe(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribe(String name, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.unsubscribe(name, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void commit(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId) throws JMSException {
        this.commit(transactionInfo, nextTransactionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.commit(transactionInfo, nextTransactionId, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void rollback(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId) throws JMSException {
        this.rollback(transactionInfo, nextTransactionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionId, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.rollback(transactionInfo, nextTransactionId, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void recover(JmsSessionId sessionId) throws JMSException {
        this.recover(sessionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recover(JmsSessionId sessionId, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.recover(sessionId, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    void pull(JmsConsumerId consumerId, long timeout) throws JMSException {
        this.pull(consumerId, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pull(JmsConsumerId consumerId, long timeout, ProviderSynchronization synchronization) throws JMSException {
        this.checkClosedOrFailed();
        try {
            ProviderFuture request = this.provider.newProviderFuture(synchronization);
            this.requests.put(request, request);
            try {
                this.provider.pull(consumerId, timeout, request);
                request.sync();
            }
            finally {
                this.requests.remove(request);
            }
        }
        catch (Exception ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosedOrFailed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosedOrFailed();
        this.exceptionListener = listener;
    }

    public void addConnectionListener(JmsConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public boolean removeConnectionListener(JmsConnectionListener listener) {
        return this.connectionListeners.remove(listener);
    }

    public boolean isForceAsyncSend() {
        return this.connectionInfo.isForceAsyncSend();
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.connectionInfo.setForceAsyncSend(forceAsyncSend);
    }

    public boolean isForceSyncSend() {
        return this.connectionInfo.isForceSyncSend();
    }

    public void setForceSyncSend(boolean alwaysSyncSend) {
        this.connectionInfo.setForceSyncSend(alwaysSyncSend);
    }

    public String getTopicPrefix() {
        return this.connectionInfo.getTopicPrefix();
    }

    public void setTopicPrefix(String topicPrefix) {
        this.connectionInfo.setTopicPrefix(topicPrefix);
    }

    public String getQueuePrefix() {
        return this.connectionInfo.getQueuePrefix();
    }

    public void setQueuePrefix(String queuePrefix) {
        this.connectionInfo.setQueuePrefix(queuePrefix);
    }

    public boolean isValidatePropertyNames() {
        return this.connectionInfo.isValidatePropertyNames();
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.connectionInfo.setValidatePropertyNames(validatePropertyNames);
    }

    public boolean isValidateSelector() {
        return this.connectionInfo.isValidateSelector();
    }

    public void setValidateSelector(boolean validateSelector) {
        this.connectionInfo.setValidateSelector(validateSelector);
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        return this.connectionInfo.getPrefetchPolicy();
    }

    public void setPrefetchPolicy(JmsPrefetchPolicy prefetchPolicy) {
        this.connectionInfo.setPrefetchPolicy(prefetchPolicy);
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        return this.connectionInfo.getRedeliveryPolicy();
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        this.connectionInfo.setRedeliveryPolicy(redeliveryPolicy);
    }

    public JmsPresettlePolicy getPresettlePolicy() {
        return this.connectionInfo.getPresettlePolicy();
    }

    public void setPresettlePolicy(JmsPresettlePolicy presettlePolicy) {
        this.connectionInfo.setPresettlePolicy(presettlePolicy);
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        return this.connectionInfo.getDeserializationPolicy();
    }

    public void setDeserializationPolicy(JmsDeserializationPolicy deserializationPolicy) {
        this.connectionInfo.setDeserializationPolicy(deserializationPolicy);
    }

    public boolean isReceiveLocalOnly() {
        return this.connectionInfo.isReceiveLocalOnly();
    }

    public void setReceiveLocalOnly(boolean receiveLocalOnly) {
        this.connectionInfo.setReceiveLocalOnly(receiveLocalOnly);
    }

    public boolean isReceiveNoWaitLocalOnly() {
        return this.connectionInfo.isReceiveNoWaitLocalOnly();
    }

    public void setReceiveNoWaitLocalOnly(boolean receiveNoWaitLocalOnly) {
        this.connectionInfo.setReceiveNoWaitLocalOnly(receiveNoWaitLocalOnly);
    }

    public boolean isLocalMessagePriority() {
        return this.connectionInfo.isLocalMessagePriority();
    }

    public void setLocalMessagePriority(boolean localMessagePriority) {
        this.connectionInfo.setLocalMessagePriority(localMessagePriority);
    }

    public long getCloseTimeout() {
        return this.connectionInfo.getCloseTimeout();
    }

    public void setCloseTimeout(long closeTimeout) {
        this.connectionInfo.setCloseTimeout(closeTimeout);
    }

    public long getConnectTimeout() {
        return this.connectionInfo.getConnectTimeout();
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectionInfo.setConnectTimeout(connectTimeout);
    }

    public long getSendTimeout() {
        return this.connectionInfo.getSendTimeout();
    }

    public void setSendTimeout(long sendTimeout) {
        this.connectionInfo.setSendTimeout(sendTimeout);
    }

    public long getRequestTimeout() {
        return this.connectionInfo.getRequestTimeout();
    }

    public void setRequestTimeout(long requestTimeout) {
        this.connectionInfo.setRequestTimeout(requestTimeout);
    }

    public URI getConfiguredURI() {
        return this.connectionInfo.getConfiguredURI();
    }

    public URI getConnectedURI() {
        return this.connectionInfo.getConnectedURI();
    }

    public String getUsername() {
        return this.connectionInfo.getUsername();
    }

    byte[] getEncodedUsername() {
        return this.connectionInfo.getEncodedUsername();
    }

    public String getPassword() {
        return this.connectionInfo.getPassword();
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isFailed() {
        return this.failureCause.get() != null;
    }

    public JmsConnectionId getId() {
        return this.connectionInfo.getId();
    }

    public JmsMessageFactory getMessageFactory() {
        if (this.messageFactory == null) {
            throw new RuntimeException("Message factory should never be null");
        }
        return this.messageFactory;
    }

    void setMessageFactory(JmsMessageFactory factory) {
        this.messageFactory = factory;
    }

    public boolean isForceAsyncAcks() {
        return this.connectionInfo.isForceAsyncAcks();
    }

    public void setForceAsyncAcks(boolean forceAsyncAcks) {
        this.connectionInfo.setForceAsyncAcks(forceAsyncAcks);
    }

    public boolean isLocalMessageExpiry() {
        return this.connectionInfo.isLocalMessageExpiry();
    }

    public void setLocalMessageExpiry(boolean localMessageExpiry) {
        this.connectionInfo.setLocalMessageExpiry(localMessageExpiry);
    }

    public JmsMessageIDPolicy getMessageIDPolicy() {
        return this.connectionInfo.getMessageIDPolicy();
    }

    public void setMessageIDPolicy(JmsMessageIDPolicy messageIDPolicy) {
        this.connectionInfo.setMessageIDPolicy(messageIDPolicy);
    }

    public boolean isPopulateJMSXUserID() {
        return this.connectionInfo.isPopulateJMSXUserID();
    }

    public void setPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.connectionInfo.setPopulateJMSXUserID(populateJMSXUserID);
    }

    public boolean isUseDaemonThread() {
        return this.connectionInfo.isUseDaemonThread();
    }

    public boolean isCloseLinksThatFailOnReconnect() {
        return this.connectionInfo.isCloseLinksThatFailOnReconnect();
    }

    public void setCloseLinksThatFailOnReconnect(boolean closeLinksThatFailOnReconnect) {
        this.connectionInfo.setCloseLinksThatFailOnReconnect(closeLinksThatFailOnReconnect);
    }

    JmsTracer getTracer() {
        return this.connectionInfo.getTracer();
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        JmsMessage incoming = envelope.getMessage();
        if (incoming != null) {
            incoming.setReadOnlyBody(true);
            incoming.setReadOnlyProperties(true);
            incoming.setValidatePropertyNames(this.isValidatePropertyNames());
        }
        JmsMessageDispatcher dispatcher = null;
        if (envelope.getConsumerInfo() != null && envelope.getConsumerInfo().getDispatcher() != null) {
            dispatcher = envelope.getConsumerInfo().getDispatcher();
        } else {
            dispatcher = this.sessions.get(envelope.getConsumerId().getParentId());
            if (dispatcher == null) {
                dispatcher = this.connectionConsumers.get(envelope.getConsumerId());
            }
        }
        if (dispatcher != null) {
            dispatcher.onInboundMessage(envelope);
        } else {
            LOG.debug("Message inbound with no dispatcher registered for its consumer: {}", (Object)envelope.getConsumerId());
        }
        if (!this.connectionListeners.isEmpty()) {
            for (JmsConnectionListener listener : this.connectionListeners) {
                this.executor.submit(() -> listener.onInboundMessage(envelope));
            }
        }
    }

    @Override
    public void onCompletedMessageSend(JmsOutboundMessageDispatch envelope) {
        JmsSession session = this.sessions.get(envelope.getProducerId().getParentId());
        if (session != null) {
            session.onCompletedMessageSend(envelope);
        } else {
            LOG.debug("No matching Session found for async send result");
        }
    }

    @Override
    public void onFailedMessageSend(JmsOutboundMessageDispatch envelope, ProviderException cause) {
        JmsSession session = this.sessions.get(envelope.getProducerId().getParentId());
        if (session != null) {
            session.onFailedMessageSend(envelope, cause);
        } else {
            LOG.debug("No matching Session found for failed async send result");
        }
    }

    @Override
    public void onConnectionInterrupted(final URI remoteURI) {
        try {
            LOG.info("Connection {} interrupted to server: {}", (Object)this.connectionInfo.getId(), (Object)URISupport.removeQuery(remoteURI));
        }
        catch (URISyntaxException e) {
            LOG.info("Connection {} interrupted to server: {}:{}", new Object[]{this.connectionInfo.getId(), remoteURI.getHost(), remoteURI.getPort()});
        }
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionInterrupted();
        }
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionInterrupted(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        LOG.debug("Connection {} is starting recovery.", (Object)this.connectionInfo.getId());
        ProviderFuture request = provider.newProviderFuture();
        provider.create(this.connectionInfo, request);
        request.sync();
        for (JmsTemporaryDestination tempDestination : this.tempDestinations.values()) {
            request = provider.newProviderFuture();
            provider.create(tempDestination, request);
            request.sync();
        }
        for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
            JmsConsumerInfo consumerInfo = connectionConsumer.getConsumerInfo();
            if (consumerInfo.isClosed()) continue;
            request = provider.newProviderFuture();
            provider.create(consumerInfo, request);
            request.sync();
        }
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRecovery(provider);
        }
    }

    @Override
    public void onConnectionRecovered(Provider provider) throws Exception {
        LOG.debug("Connection {} is finalizing recovery.", (Object)this.connectionInfo.getId());
        this.setMessageFactory(provider.getMessageFactory());
        this.connectionInfo.setConnectedURI(provider.getRemoteURI());
        for (JmsConnectionConsumer connectionConsumer : this.connectionConsumers.values()) {
            JmsConsumerInfo consumerInfo = connectionConsumer.getConsumerInfo();
            if (consumerInfo.isClosed()) continue;
            ProviderFuture request = provider.newProviderFuture();
            provider.start(consumerInfo, request);
            request.sync();
        }
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRecovered(provider);
        }
    }

    @Override
    public void onConnectionRestored(final URI remoteURI) {
        for (JmsSession session : this.sessions.values()) {
            session.onConnectionRestored();
        }
        try {
            LOG.info("Connection {} restored to server: {}", (Object)this.connectionInfo.getId(), (Object)URISupport.removeQuery(remoteURI));
        }
        catch (URISyntaxException e) {
            LOG.info("Connection {} restored to server: {}:{}", new Object[]{this.connectionInfo.getId(), remoteURI.getHost(), remoteURI.getPort()});
        }
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionRestored(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionEstablished(final URI remoteURI) {
        try {
            LOG.info("Connection {} connected to server: {}", (Object)this.connectionInfo.getId(), (Object)URISupport.removeQuery(remoteURI));
        }
        catch (URISyntaxException e) {
            LOG.info("Connection {} connected to server: {}:{}", new Object[]{this.connectionInfo.getId(), remoteURI.getHost(), remoteURI.getPort()});
        }
        this.setMessageFactory(this.provider.getMessageFactory());
        this.connectionInfo.setConnectedURI(this.provider.getRemoteURI());
        for (final JmsConnectionListener listener : this.connectionListeners) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onConnectionEstablished(remoteURI);
                }
            });
        }
    }

    @Override
    public void onConnectionFailure(final ProviderException ex) {
        this.providerFailed(ex);
        LOG.warn("Connection {} has failed due to: {}", (Object)this.connectionInfo.getId(), (Object)(ex != null ? ex.getMessage() : "No error details provided."));
        for (JmsSession session : this.sessions.values()) {
            try {
                session.onConnectionInterrupted();
            }
            catch (Throwable t) {
                LOG.warn("Exception while marking session interrupted", t);
            }
        }
        this.onProviderException(ex);
        for (AsyncResult request : this.requests.keySet()) {
            try {
                request.onFailure(ex);
            }
            catch (Exception e) {
                LOG.debug("Exception during request cleanup", (Throwable)e);
            }
        }
        if (!this.closing.get() && !this.closed.get()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (JmsConnection.this.provider != null) {
                        try {
                            JmsConnection.this.provider.close();
                        }
                        catch (Throwable error) {
                            LOG.debug("Error while closing failed Provider: {}", (Object)error.getMessage());
                        }
                    }
                    for (AsyncResult request : JmsConnection.this.requests.keySet()) {
                        try {
                            request.onFailure(ex);
                        }
                        catch (Exception e) {
                            LOG.debug("Exception during request cleanup", (Throwable)e);
                        }
                    }
                    try {
                        JmsConnection.this.shutdown(ex);
                    }
                    catch (JMSException e) {
                        LOG.warn("Exception during connection cleanup, " + e, (Throwable)e);
                    }
                    for (JmsConnectionListener listener : JmsConnection.this.connectionListeners) {
                        listener.onConnectionFailure(ex);
                    }
                    JmsConnection.this.executor.shutdown();
                }
            });
        }
    }

    @Override
    public void onResourceClosed(final JmsResource resource, final ProviderException cause) {
        if (!this.closing.get() && !this.closed.get()) {
            if (resource instanceof JmsSessionInfo) {
                JmsSession session = this.sessions.get(resource.getId());
                if (session != null) {
                    session.setFailureCause(cause);
                }
            } else if (resource instanceof JmsProducerInfo) {
                JmsMessageProducer producer;
                JmsSessionId parentId = ((JmsProducerInfo)resource).getParentId();
                JmsSession session = this.sessions.get(parentId);
                if (session != null && (producer = session.lookup((JmsProducerId)resource.getId())) != null) {
                    producer.setFailureCause(cause);
                }
            } else if (resource instanceof JmsConsumerInfo) {
                JmsConsumerInfo consumerInfo = (JmsConsumerInfo)resource;
                if (consumerInfo.isConnectionConsumer()) {
                    JmsConnectionConsumer consumer = this.connectionConsumers.get(consumerInfo.getId());
                    if (consumer != null) {
                        consumer.setFailureCause(cause);
                    }
                } else {
                    JmsMessageConsumer consumer;
                    JmsSessionId parentId = consumerInfo.getParentId();
                    JmsSession session = this.sessions.get(parentId);
                    if (session != null && (consumer = session.lookup((JmsConsumerId)resource.getId())) != null) {
                        consumer.setFailureCause(cause);
                    }
                }
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (resource instanceof JmsSessionInfo) {
                        JmsSession session = JmsConnection.this.sessions.get(resource.getId());
                        if (session != null) {
                            session.sessionClosed(cause);
                            for (JmsConnectionListener listener : JmsConnection.this.connectionListeners) {
                                listener.onSessionClosed(session, cause);
                            }
                        }
                    } else if (resource instanceof JmsProducerInfo) {
                        JmsMessageProducer producer;
                        JmsSessionId parentId = ((JmsProducerInfo)resource).getParentId();
                        JmsSession session = JmsConnection.this.sessions.get(parentId);
                        if (session != null && (producer = session.producerClosed((JmsProducerInfo)resource, cause)) != null) {
                            for (JmsConnectionListener listener : JmsConnection.this.connectionListeners) {
                                listener.onProducerClosed(producer, cause);
                            }
                        }
                    } else if (resource instanceof JmsConsumerInfo) {
                        JmsConsumerInfo consumerInfo = (JmsConsumerInfo)resource;
                        if (consumerInfo.isConnectionConsumer()) {
                            JmsConnectionConsumer consumer = JmsConnection.this.connectionConsumers.get(consumerInfo.getId());
                            if (consumer != null) {
                                try {
                                    if (consumer != null) {
                                        consumer.shutdown(cause);
                                    }
                                }
                                catch (Throwable error) {
                                    LOG.trace("Ignoring exception thrown during cleanup of closed connection consumer", error);
                                }
                                JmsConnection.this.onAsyncException(new JMSException("Connection Consumer remotely closed").initCause((Throwable)cause));
                            }
                        } else {
                            JmsMessageConsumer consumer;
                            JmsSessionId parentId = consumerInfo.getParentId();
                            JmsSession session = JmsConnection.this.sessions.get(parentId);
                            if (session != null && (consumer = session.consumerClosed((JmsConsumerInfo)resource, cause)) != null) {
                                for (JmsConnectionListener listener : JmsConnection.this.connectionListeners) {
                                    listener.onConsumerClosed(consumer, cause);
                                }
                            }
                        }
                    } else {
                        LOG.info("A JMS resource has been remotely closed: {}", (Object)resource);
                    }
                }
            });
        }
    }

    @Override
    public void onProviderException(ProviderException cause) {
        this.onAsyncException(cause);
    }

    public void onAsyncException(Throwable error) {
        if (!this.closed.get() && !this.closing.get()) {
            if (this.exceptionListener != null) {
                final JMSException jmsError = JmsExceptionSupport.create(error);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        JmsConnection.this.exceptionListener.onException(jmsError);
                    }
                });
            } else {
                LOG.debug("Async exception with no exception listener: {}", (Object)error, (Object)error);
            }
        }
    }

    protected void providerFailed(ProviderException cause) {
        this.failureCause.compareAndSet(null, cause);
    }
}

