/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.annotation.Action;
import com.datical.liquibase.ext.rules.annotation.Condition;
import com.datical.liquibase.ext.rules.annotation.Fact;
import com.datical.liquibase.ext.rules.annotation.Priority;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

class RuleDefinitionValidator {
    RuleDefinitionValidator() {
    }

    void validateRuleDefinition(Object object) {
        this.checkRuleClass(object);
        this.checkConditionMethod(object);
        this.checkActionMethods(object);
        this.checkPriorityMethod(object);
    }

    private void checkRuleClass(Object object) {
        if (!this.isRuleClassWellDefined(object)) {
            throw new IllegalArgumentException(String.format("Rule '%s' is not annotated with '%s'", object.getClass().getName(), Rule.class.getName()));
        }
    }

    private void checkConditionMethod(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Condition.class, object);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have a public method annotated with '%s'", object.getClass().getName(), Condition.class.getName()));
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", object.getClass().getName(), Condition.class.getName()));
        }
        if (!this.isConditionMethodWellDefined((Method)((Object)(list = list.get(0))))) {
            throw new IllegalArgumentException(String.format("Condition method '%s' defined in rule '%s' must be public, must return boolean type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", list, object.getClass().getName()));
        }
    }

    private void checkActionMethods(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Action.class, object);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have at least one public method annotated with '%s'", object.getClass().getName(), Action.class.getName()));
        }
        for (Method method : list) {
            if (this.isActionMethodWellDefined(method)) continue;
            throw new IllegalArgumentException(String.format("Action method '%s' defined in rule '%s' must be public, must return void type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", method, object.getClass().getName()));
        }
    }

    private void checkPriorityMethod(Object object) {
        List<Method> list = this.getMethodsAnnotatedWith(Priority.class, object);
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", object.getClass().getName(), Priority.class.getName()));
        }
        if (!this.isPriorityMethodWellDefined((Method)((Object)(list = list.get(0))))) {
            throw new IllegalArgumentException(String.format("Priority method '%s' defined in rule '%s' must be public, have no parameters and return integer type.", list, object.getClass().getName()));
        }
    }

    private boolean isRuleClassWellDefined(Object object) {
        return Utils.isAnnotationPresent(Rule.class, object.getClass());
    }

    private boolean isConditionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Boolean.TYPE) && this.validParameters(method);
    }

    private boolean validParameters(Method method) {
        int n2 = 0;
        Object object = method.getParameterAnnotations();
        int n3 = ((Annotation[][])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Annotation[] annotationArray = object[i2];
            if (annotationArray.length == 0) {
                ++n2;
                continue;
            }
            int n4 = annotationArray.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                if (annotationArray[i3].annotationType().equals(Fact.class)) continue;
                return false;
            }
        }
        if (n2 > 1) {
            return false;
        }
        if (n2 == 1 && (object = this.getNotAnnotatedParameter(method)) != null) {
            return Facts.class.isAssignableFrom(((Parameter)object).getType());
        }
        return true;
    }

    private Parameter getNotAnnotatedParameter(Method parameterArray) {
        for (Parameter parameter : parameterArray.getParameters()) {
            if (parameter.getAnnotations().length != 0) continue;
            return parameter;
        }
        return null;
    }

    private boolean isActionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && this.validParameters(method);
    }

    private boolean isPriorityMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Integer.TYPE) && method.getParameterTypes().length == 0;
    }

    private List<Method> getMethodsAnnotatedWith(Class<? extends Annotation> clazz, Object methodArray) {
        methodArray = this.getMethods(methodArray);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            if (!method.isAnnotationPresent(clazz)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    private Method[] getMethods(Object object) {
        return object.getClass().getMethods();
    }
}

