/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config.annotation;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurer;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class MetricsConfigurerAdapter
implements MetricsConfigurer,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfigurerAdapter.class);
    private Set<Closeable> reporters;

    @Override
    public void configureReporters(MetricRegistry metricRegistry) {
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return null;
    }

    @Override
    public HealthCheckRegistry getHealthCheckRegistry() {
        return null;
    }

    public void destroy() throws Exception {
        if (this.reporters != null) {
            for (Closeable reporter : this.reporters) {
                try {
                    reporter.close();
                }
                catch (Exception ex) {
                    LOG.warn("Problem stopping reporter", (Throwable)ex);
                }
            }
        }
    }

    protected <R extends Closeable> R registerReporter(R reporter) {
        if (this.reporters == null) {
            this.reporters = new HashSet<Closeable>();
        }
        this.reporters.add(reporter);
        return reporter;
    }
}

