/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\u0015g\u0001B\u0016-\u0001UB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tM\u0002\u0011)\u0019!C\u0001O\"Aa\u000e\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011!Q\u0001\n]D\u0001b\u001f\u0001\u0003\u0006\u0004%\t\u0001 \u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\nuD!\"a\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0003\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011%\t)\u0005\u0001b\u0001\n\u0003\t9\u0005\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA%\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!!*\u0001\t\u0003\t9\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001fAqA!\u0004\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u0013\tM\u0002!%A\u0005\n\tU\u0002\"\u0003B%\u0001E\u0005I\u0011\u0002B&\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003b\u0001!\tAa\u0019\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!\u0011\u0012\u0001\u0005\u0002\t-\u0005b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005K\u0003A\u0011\u0002BT\u0011\u001d\u0011Y\u000b\u0001C\t\u0005[CqA!-\u0001\t#\u0011\u0019LA\tEKB,g\u000eZ3oGf\u001cVM\u001d<jG\u0016T!!\f\u0018\u0002\u000fM,'O^5dK*\u0011q\u0006M\u0001\nq2\u0014X\r\\3bg\u0016T!!\r\u001a\u0002\u0013a,'-[1mC\n\u001c(\"A\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u00011D\bQ\"\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\tid(D\u0001-\u0013\tyDF\u0001\nSK2,\u0017m]3Ue\u0016,')^5mI\u0016\u0014\bCA\u001fB\u0013\t\u0011EF\u0001\u000fEKB,g\u000eZ3oGf\u001c\u0015M\u001c3jI\u0006$XmQ8mY\u0016\u001cGo\u001c:\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015!B:mMRR'\"\u0001%\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AS#\u0003\u000f1{wmZ5oO\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u0018\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002S\u001f\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003Y\u0003\"!P,\n\u0005ac#\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\u0011\u0002%Ad\u0017M\\%uK6\u0014V\r]8tSR|'/_\u000b\u00029B\u0011a*X\u0005\u0003=>\u0013!\u0003\u00157b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019\u0002\u000f\\1o\u0013R,WNU3q_NLGo\u001c:zA\u0005!B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef,\u0012A\u0019\t\u0003\u001d\u000eL!\u0001Z(\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0003U!W\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NL\u0001\u0007KZ,g\u000e^:\n\u00055T'\u0001C#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0002cB\u0011aJ]\u0005\u0003g>\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\buCN\\'+\u001a9pg&$xN]=!\u0003=\u0001\b.Y:f%\u0016\u0004xn]5u_JLX#A<\u0011\u00059C\u0018BA=P\u0005=\u0001\u0006.Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00059iCN,'+\u001a9pg&$xN]=!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0003u\u0004\"!\u0010@\n\u0005}d#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fAbY5JIN+'O^5dK\u0002\n\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0016\u0005\u0005\u001d\u0001cA\u001f\u0002\n%\u0019\u00111\u0002\u0017\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!E1sG\"Lg/\u001b8h'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"B#a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0002CA\u001f\u0001\u0011\u0015Y5\u00031\u0001N\u0011\u0015!6\u00031\u0001W\u0011\u0015Q6\u00031\u0001]\u0011\u0015\u00017\u00031\u0001c\u0011\u001517\u00031\u0001i\u0011\u0015y7\u00031\u0001r\u0011\u0015)8\u00031\u0001x\u0011\u0015Y8\u00031\u0001~\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000fA3aEA\u0015!\u0011\tY#!\u0011\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t!\"\u00198o_R\fG/[8o\u0015\u0011\t\u0019$!\u000e\u0002\u000f\u0019\f7\r^8ss*!\u0011qGA\u001d\u0003\u0015\u0011W-\u00198t\u0015\u0011\tY$!\u0010\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002D\u00055\"!C!vi><\u0018N]3e\u0003a\t7\r^5wK\u0012+\u0007/\u001a8eK:\u001c\u0017p\u0015;biV\u001cXm]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002\\\u0005\u0005d\u0002BA'\u0003/rA!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\"\u0014A\u0002\u001fs_>$h(C\u0001:\u0013\r\tI\u0006O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\u0007M+\u0017OC\u0002\u0002Za\u0002B!a\u0019\u0002l9!\u0011QMA4!\r\ty\u0005O\u0005\u0004\u0003SB\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002ja\n\u0011$Y2uSZ,G)\u001a9f]\u0012,gnY=Ti\u0006$Xo]3tA\u000511M]3bi\u0016$b!a\u001e\u0002\u0004\u00065\u0005\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005ud&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0006EKB,g\u000eZ3oGfDq!!\"\u0017\u0001\u0004\t9)\u0001\u0003hCR,\u0007\u0003BA=\u0003\u0013KA!a#\u0002|\tAq)\u0019;f)\u0006\u001c8\u000eC\u0004\u0002\u0010Z\u0001\r!!\u0019\u0002%Q\f'oZ3u\u0013\u0012|%OV1sS\u0006\u0014G.\u001a\u0015\u0004-\u0005M\u0005\u0003BAK\u0003Ck!!a&\u000b\t\u0005=\u0012\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005}%'\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t\u0019+a&\u0003\u000bQKW.\u001a3\u0002\u0019U\u0004H-\u0019;f)\u0006\u0014x-\u001a;\u0015\r\u0005]\u0014\u0011VAW\u0011\u001d\tYk\u0006a\u0001\u0003C\nA\u0002Z3qK:$WM\\2z\u0013\u0012Dq!a$\u0018\u0001\u0004\t\t\u0007K\u0002\u0018\u0003'\u000ba\u0001Z3mKR,GCBA[\u0003w\u000b)\rE\u00028\u0003oK1!!/9\u0005\u0011)f.\u001b;\t\u000f\u0005u\u0006\u00041\u0001\u0002@\u00069!/\u001a7fCN,\u0007\u0003BA=\u0003\u0003LA!a1\u0002|\t9!+\u001a7fCN,\u0007bBAd1\u0001\u0007\u0011\u0011M\u0001\u0003S\u0012D3\u0001GAJ\u0003U9W\r^\"p[BdW\r^1cY\u0016<\u0015\r^3JIN$B!a4\u0002`B1\u0011\u0011[An\u0003Cj!!a5\u000b\t\u0005U\u0017q[\u0001\u0005kRLGN\u0003\u0002\u0002Z\u0006!!.\u0019<b\u0013\u0011\ti.a5\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u0002bf\u0001\r!a9\u0002\u000fQ\f'oZ3ugB1\u0011\u0011[An\u0003K\u0004B!!\u001f\u0002h&!\u0011\u0011^A>\u0005!\u0001F.\u00198Ji\u0016l\u0007fA\r\u0002\u0014\u0006Ib-\u001b8e\u0003\u000e$\u0018N^3J]\u000e|W.\u001b8h\u000f\u0006$X-\u00133t)\u0011\t\t0a>\u0011\r\u0005E\u00171_A1\u0013\u0011\t)0a5\u0003\t1K7\u000f\u001e\u0005\b\u0003sT\u0002\u0019AA1\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002\u001b\u0003'\u000b1FZ5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%eg^KG\u000f[8vi\u0016C\u0018n\u001d;t\u0007\",7m\u001b\u000b\u0005\u0003\u0013\u0012\t\u0001C\u0004\u0003\u0004m\u0001\r!!\u0019\u0002\u0011A\f'/\u001a8u\u0013\u0012D3aGAJ\u0003m!wNR5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%egR!\u0011\u0011\nB\u0006\u0011\u001d\u0011\u0019\u0001\ba\u0001\u0003C\n!cZ3u\r\u0006LG.\u00192mK\u001e\u000bG/Z%egR!\u0011q\u001aB\t\u0011\u001d\tI0\ba\u0001\u0003CB3!HAJ)\u0011\tyMa\u0006\t\u000f\tea\u00041\u0001\u0002d\u0006q\u0011MY8si\u0016$G+\u0019:hKR\u001c\bf\u0001\u0010\u0002\u0014\u0006ab-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0003CA%\u0005C\u0011)C!\u000b\t\u000f\t\rr\u00041\u0001\u0002J\u0005IA/\u0019:hKRLEm\u001d\u0005\n\u0005Oy\u0002\u0013!a\u0001\u0003\u0013\n\u0001b\u001d;biV\u001cXm\u001d\u0005\n\u0005Wy\u0002\u0013!a\u0001\u0005[\t1C]3gKJ,gnY5oO\u000eC\u0017\u000e\u001c3sK:\u00042a\u000eB\u0018\u0013\r\u0011\t\u0004\u000f\u0002\b\u0005>|G.Z1o\u0003\u00192\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY=JIN$C-\u001a4bk2$HEM\u000b\u0003\u0005oQC!!\u0013\u0003:-\u0012!1\b\t\u0005\u0005{\u0011)%\u0004\u0002\u0003@)!!\u0011\tB\"\u0003%)hn\u00195fG.,GMC\u0002\u00020aJAAa\u0012\u0003@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002M\u0019Lg\u000eZ!mY&s7m\\7j]\u001e$U\r]3oI\u0016t7-_%eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003N)\"!Q\u0006B\u001d\u0003m1\u0017N\u001c3BGRLg/Z(vi\u001e|\u0017N\\4UCJ<W\r^%egR!\u0011\u0011\u001fB*\u0011\u001d\tIP\ta\u0001\u0003CB3AIAJ\u0003e1\u0017N\u001c3BGRLg/Z(vi\u001e|\u0017N\\4UCJ<W\r^:\u0015\t\tm#Q\f\t\u0007\u0003\u0017\nY&!:\t\u000f\u0005e8\u00051\u0001\u0002b!\u001a1%a%\u0002\u001d\u001d,GOU3mK\u0006\u001cX\r\u0016:fKR!!Q\rB9!\u0011\u00119G!\u001c\u000e\u0005\t%$b\u0001B6]\u0005)a/[3xg&!!q\u000eB5\u0005-\u0011V\r\\3bg\u0016$&/Z3\t\u000f\u0005eH\u00051\u0001\u0002b!\u001aA%a%\u00027U\u0004H-\u0019;f\u000f\u0006$XMU3gKJ,gnY5oOBC\u0017m]3t)\u0019\t)L!\u001f\u0003~!9!1P\u0013A\u0002\u0005\u0005\u0014AB4bi\u0016LE\rC\u0004\u0003\u0000\u0015\u0002\rA!!\u0002!=\u0014\u0018nZ5o)>\u0014Vm\u001d;pe\u0016$\u0007\u0003CAi\u0005\u0007\u000b)/!:\n\t\t\u0015\u00151\u001b\u0002\u0004\u001b\u0006\u0004\bfA\u0013\u0002\u0014\u0006\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR1\u0011Q\u0017BG\u0005\u001fCq!!?'\u0001\u0004\t\t\u0007C\u0004\u0003\u0012\u001a\u0002\r!!\u0013\u0002\u001b\u0011,\u0007/\u001a8eK:\u001c\u00170\u00133tQ\r1\u00131S\u0001\u001fM&tG\rR3qK:$WM\\2z)\u0006\u0014x-\u001a;CsR\u000b'oZ3u\u0013\u0012$BA!'\u0003 B\u0019QHa'\n\u0007\tuEFA\u0006JI\u0006sGm\u0015;biV\u001c\bb\u0002BQO\u0001\u0007\u0011\u0011M\u0001\ti\u0006\u0014x-\u001a;JI\"\u001aq%a%\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003BA1\u0005SCqA!))\u0001\u0004\t\t'A\u000fgS:$\u0017J\u001c)s_\u001e\u0014Xm]:J]\u000e|W.\u001b8h\u000f\u0006$X-\u00133t)\u0011\tIEa,\t\u000f\t\r\u0012\u00061\u0001\u0002J\u0005Q\u0011n\u001d+f[Bd\u0017\r^3\u0015\t\t5\"Q\u0017\u0005\b\u0003WS\u0003\u0019AA1Q\r\u0001!\u0011\u0018\t\u0005\u0005w\u0013\t-\u0004\u0002\u0003>*!!qXA\u001d\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u0007\u0014iLA\u0004TKJ4\u0018nY3")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(targets).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = this.doFindActiveIncomingGateIds(releaseId);
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(87).append("Release ").append(releaseId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private scala.collection.immutable.Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (scala.collection.immutable.Seq)((SeqOps)((IterableOps)this.findAllIncomingDependencyIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    @Timed
    public Collection<String> getFailableGateIds(String releaseId) {
        scala.collection.immutable.Seq statuses = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)statuses, true).map((Function1 & Serializable)dependency -> Ids.getParentId((String)dependency.getId()))).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(abortedTargets).asScala().toSeq().map((Function1 & Serializable)x$8 -> x$8.getId())))).asJava();
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds(scala.collection.immutable.Seq<String> targetIds, scala.collection.immutable.Seq<String> statuses, boolean referencingChildren) {
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable)x$9 -> x$9.getId());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        void var2_2;
        List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        void var3_3;
        List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone() ? A1.getTarget() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                boolean bl = dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
                return bl;
            }
        })).toSeq();
        return var3_3;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        String string;
        Option option3;
        String string2 = targetId;
        if (string2 != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 != null ? this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(20).append("Release [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else if (string2 != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 != null ? this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString() : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(18).append("Phase [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else if (string2 != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string2)).isEmpty()) {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    Object object = A1 != null ? this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString() : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(17).append("Task [").append(targetId).append("] not found").toString(), new Object[0]);
            });
        } else {
            throw new NotFoundException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString(), new Object[0]);
        }
        return string;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.findAllIncomingDependencyIds(targetIds, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

