/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.runtime.RuntimeController;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.wrapper.AbstractWrappedProcess;
import org.rzo.yajsw.wrapper.AlphaNumericComparator;

public class WrappedRuntimeProcess
extends AbstractWrappedProcess {
    File _runtimePidFile;
    private final AbstractController.ControllerListener listenerStopped = new AbstractController.ControllerListener(){

        @Override
        public void fire() {
            if (WrappedRuntimeProcess.this._state == 6 || WrappedRuntimeProcess.this._state == 2 || WrappedRuntimeProcess.this._state == 7) {
                return;
            }
            WrappedRuntimeProcess.this.getWrapperLogger().info("listener stopped");
            if (WrappedRuntimeProcess.this._osProcess.isRunning()) {
                WrappedRuntimeProcess.this.stop();
            }
            if (WrappedRuntimeProcess.this.allowRestart() && WrappedRuntimeProcess.this.exitCodeRestart() && !WrappedRuntimeProcess.this.exitCodeShutdown()) {
                WrappedRuntimeProcess.this.restartInternal("controller listener stopped");
            } else {
                WrappedRuntimeProcess.this.setState(0);
                if (WrappedRuntimeProcess.this._debug > 1) {
                    WrappedRuntimeProcess.this.getWrapperLogger().info("giving up after " + WrappedRuntimeProcess.this._restartCount + " retries");
                }
            }
        }
    };

    @Override
    void configProcess() {
        super.configProcess();
        ArrayList<String> command = new ArrayList<String>();
        String c = this._config.getString("wrapper.image", null);
        if (c == null || c.length() == 0) {
            this.getInternalWrapperLogger().error("wrapper.image not set -> abort");
            return;
        }
        command.add(c);
        ArrayList keys = new ArrayList();
        ListIterator it = this._config.getKeys("wrapper.app.parameter");
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Collections.sort(keys, new AlphaNumericComparator());
        it = keys.listIterator();
        while (it.hasNext()) {
            String arg = this._config.getString((String)it.next());
            if (arg == null || (arg = arg.trim()).length() <= 0) continue;
            command.add(arg);
        }
        String[] arrCmd = new String[command.size()];
        for (int i = 0; i < arrCmd.length; ++i) {
            arrCmd[i] = (String)command.get(i);
        }
        if (arrCmd.length == 1) {
            this._osProcess.setCommand(arrCmd[0]);
        } else {
            this._osProcess.setCommand(arrCmd);
        }
        boolean pipeStreams = this._config.getBoolean("wrapper.console.pipestreams", true);
        this._osProcess.setPipeStreams(pipeStreams, pipeStreams);
    }

    @Override
    void postStart() {
        this.saveRuntimePidFile();
    }

    @Override
    void stopController(int timeout, String reason) {
        this._controller.stop(4, reason);
        this._osProcess.stop(timeout, 999);
        this.removeRuntimePidFile();
    }

    @Override
    public boolean reconnect(int pid) {
        try {
            this._osProcess = OperatingSystem.instance().processManagerInstance().getProcess(pid);
            if (!this._osProcess.stop(10, 0)) {
                this.getWrapperLogger().severe("native processes must be restarted to consume the out and err streams. stopping of process failed");
            }
        }
        catch (Throwable ex) {
            this.getWrapperLogger().severe("native processes must be restarted to consume the out and err streams. stopping of process failed: " + ex.getMessage());
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public void init() {
        super.init();
        if (this._controller == null) {
            this._controller = new RuntimeController(this);
            this.configController();
        }
    }

    @Override
    void configController() {
        this._controller.setLogger(this.getWrapperLogger());
        this._controller.addListener(2, this.listenerStopped);
    }

    @Override
    public String getType() {
        return "Native-" + super.getType();
    }

    void saveRuntimePidFile() {
        String file = this._config.getString("wrapper.runtime.pidfile");
        if (file != null) {
            try {
                this._runtimePidFile = new File(file);
                if (!this._runtimePidFile.getParentFile().exists()) {
                    this._runtimePidFile.getParentFile().mkdirs();
                }
                if (!this._runtimePidFile.exists()) {
                    this._runtimePidFile.createNewFile();
                }
                FileWriter out = new FileWriter(this._runtimePidFile, false);
                out.write("" + this.getAppPid());
                out.flush();
                out.close();
                if (this._debug > 2) {
                    this.getWrapperLogger().info("created jva.pid file " + this._runtimePidFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void removeRuntimePidFile() {
        if (this._runtimePidFile != null) {
            try {
                this._runtimePidFile.delete();
                if (this._debug > 2) {
                    this.getWrapperLogger().info("removed java.pid file " + this._runtimePidFile.getAbsolutePath());
                }
                this._runtimePidFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        WrappedRuntimeProcess p = new WrappedRuntimeProcess();
        Configuration c = p.getLocalConfiguration();
        c.setProperty("wrapper.image", (Object)"notepad");
        c.setProperty("wrapper.working.dir", (Object)"c:/");
        p.init();
        p.start();
        p.waitFor(10000L);
        System.out.println("stopping");
        p.stop();
        System.out.println("stopped " + p.getExitCode());
    }
}

