/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.typesafe.config.Config;
import com.xebialabs.xlrelease.cache.caffeine.CaffeineCacheBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseCacheService;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ReleaseCacheService$
implements ReleaseCacheService,
Logging,
CaffeineCacheBuilder {
    public static final ReleaseCacheService$ MODULE$ = new ReleaseCacheService$();
    private static final String cacheName;
    private static final Config cacheConf;
    private static final boolean isClustered;
    private static volatile boolean enabled;
    private static final Cache<String, ReleaseRow> releaseCache;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        ReleaseCacheService.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
        CaffeineCacheBuilder.$init$((CaffeineCacheBuilder)MODULE$);
        cacheName = "release-rows";
        cacheConf = XlrConfig$.MODULE$.getInstance().cache().config();
        isClustered = XlrConfig$.MODULE$.getInstance().isClusterEnabled();
        boolean releaseRowCacheEnabled = BoxesRunTime.unboxToBoolean((Object)XlrConfig$.MODULE$.ExtendedConfig(MODULE$.cacheConf().getConfig(MODULE$.cacheName())).getOptionalBoolean("enabled").getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (MODULE$.isClustered() && releaseRowCacheEnabled) {
            MODULE$.logger().warn((Function0 & Serializable)() -> new StringBuilder(40).append("Cannot enable ").append(MODULE$.cacheName()).append(" for clustered environment").toString());
        }
        enabled = !MODULE$.isClustered() && releaseRowCacheEnabled;
        XlrConfig.cache$ cacheSettings = XlrConfig$.MODULE$.getInstance().cache();
        releaseCache = MODULE$.buildCache("releaseCacheService", MODULE$.cacheName(), "default-cache-values", (XlrConfig.CacheSettings)cacheSettings);
    }

    @Override
    public <K, V> Cache<K, V> buildCache(String cacheManagerName, String name, String defaultCacheConfigName, XlrConfig.CacheSettings cacheSettings) {
        return CaffeineCacheBuilder.buildCache$((CaffeineCacheBuilder)this, (String)cacheManagerName, (String)name, (String)defaultCacheConfigName, (XlrConfig.CacheSettings)cacheSettings);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public String name() {
        return ReleaseCacheService.name$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseCacheService$ releaseCacheService$ = this;
        synchronized (releaseCacheService$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    private String cacheName() {
        return cacheName;
    }

    private Config cacheConf() {
        return cacheConf;
    }

    private boolean isClustered() {
        return isClustered;
    }

    private boolean enabled() {
        return enabled;
    }

    private void enabled_$eq(boolean x$1) {
        enabled = x$1;
    }

    private Cache<String, ReleaseRow> releaseCache() {
        return releaseCache;
    }

    @Override
    public Option<ReleaseRow> get(String releaseId) {
        return this.enabled() ? Option$.MODULE$.apply(this.releaseCache().getIfPresent((Object)CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(releaseId)))).map((Function1 & Serializable)r -> {
            MODULE$.logger().trace((Function0 & Serializable)() -> new StringBuilder(20).append("Fetching ").append(CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(releaseId))).append(" from cache").toString());
            return r;
        }) : None$.MODULE$;
    }

    @Override
    public void put(String releaseId, ReleaseRow releaseRow) {
        block0: {
            if (!this.enabled()) break block0;
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(8).append("Caching ").append(CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(releaseId))).toString());
            this.releaseCache().put((Object)CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(releaseId)), (Object)releaseRow);
        }
    }

    @Override
    public void invalidate(String releaseId) {
        this.releaseCache().invalidate((Object)CiId$RichCiId$.MODULE$.shortId$extension(CiId$.MODULE$.RichCiId(releaseId)));
    }

    @Override
    public void invalidateAll() {
        this.releaseCache().invalidateAll();
    }

    public void enable() {
        this.enabled_$eq(true);
    }

    public void disable() {
        this.enabled_$eq(false);
        this.releaseCache().invalidateAll();
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    @Override
    public String getStats() {
        CacheStats cacheStats = this.releaseCache().stats();
        return cacheStats.toString();
    }

    private ReleaseCacheService$() {
    }
}

