/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.validators;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.triggers.scheduled.validators.ScheduledTriggerValidator$;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.quartz.CronExpression;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005ms!\u0002\t\u0012\u0011\u0003qb!\u0002\u0011\u0012\u0011\u0003\t\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007}\u0005\u0001\u000b\u0011\u0002\u001d\t\u0011}\n\u0001R1A\u0005\n\u0001C\u0011bR\u0001A\u0002\u0003\u0007I\u0011\u0001%\t\u00131\u000b\u0001\u0019!a\u0001\n\u0003i\u0005\"C*\u0002\u0001\u0004\u0005\t\u0015)\u0003J\u0011\u0015Y\u0016\u0001\"\u0001]\u0011\u0015y\u0016\u0001\"\u0001a\r\u0011\u0001\u0013\u0003A2\t\u000bQZA\u0011\u0001<\t\u000ba\\A\u0011I=\t\u000f\u0005\u00051\u0002\"\u0003\u0002\u0004!9\u0011qF\u0006\u0005\u0002\u0005E\u0012!G*dQ\u0016$W\u000f\\3e)JLwmZ3s-\u0006d\u0017\u000eZ1u_JT!AE\n\u0002\u0015Y\fG.\u001b3bi>\u00148O\u0003\u0002\u0015+\u0005I1o\u00195fIVdW\r\u001a\u0006\u0003-]\t\u0001\u0002\u001e:jO\u001e,'o\u001d\u0006\u00031e\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005\t\"!G*dQ\u0016$W\u000f\\3e)JLwmZ3s-\u0006d\u0017\u000eZ1u_J\u001c2!\u0001\u0012+!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u00142kK\u000e$\bCA\u00163\u001b\u0005a#BA\u0017/\u0003\u001d\u0019wN\u001c;fqRT!a\f\u0019\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!M\u0001\u0004_J<\u0017BA\u001a-\u0005]\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;Bo\u0006\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0002=\u0005ab*V'C\u000bJ{vJR0J\u001dR+%KV!M'~#vjX\"I\u000b\u000e[U#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/A\u000fO+6\u0013UIU0P\r~Ke\nV#S-\u0006c5k\u0018+P?\u000eCUiQ&!\u0003Q\u0019wN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E/\u000591/\u001a:wS\u000e,\u0017B\u0001$D\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u+\u0005I\u0005CA\u0016K\u0013\tYEF\u0001\nBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018AF1qa2L7-\u0019;j_:\u001cuN\u001c;fqR|F%Z9\u0015\u00059\u000b\u0006CA\u001dP\u0013\t\u0001&H\u0001\u0003V]&$\bb\u0002*\b\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0014aE1qa2L7-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0003F\u0001\u0005V!\t1\u0016,D\u0001X\u0015\tA&(A\u0003cK\u0006t7/\u0003\u0002[/\na!)Z1o!J|\u0007/\u001a:us\u0006)r-\u001a;BaBd\u0017nY1uS>t7i\u001c8uKb$H#A%)\u0005%q6\u0002A\u0001\u0016g\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u)\tq\u0015\rC\u0004S\u0015\u0005\u0005\t\u0019A%)\u0005)q6cA\u0006#IB\u0019QM\u001c9\u000e\u0003\u0019T!a\u001a5\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002jU\u0006\u0019\u0011\r]5\u000b\u0005-d\u0017A\u00029mk\u001eLgN\u0003\u0002n3\u0005AA-\u001a9m_fLG/\u0003\u0002pM\nIa+\u00197jI\u0006$xN\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g^\ta\u0001Z8nC&t\u0017BA;s\u0005A\u00196\r[3ek2,G\r\u0016:jO\u001e,'\u000fF\u0001x!\ty2\"\u0001\u0005wC2LG-\u0019;f)\rq%\u0010 \u0005\u0006w6\u0001\r\u0001]\u0001\biJLwmZ3s\u0011\u0015iS\u00021\u0001~!\t)g0\u0003\u0002\u0000M\n\tb+\u00197jI\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0019Y\fG.\u001b3bi\u0016\u001c%o\u001c8\u0015\u00139\u000b)!a\b\u0002$\u0005\u0015\u0002bBA\u0004\u001d\u0001\u0007\u0011\u0011B\u0001\u000bKb\u0004(/Z:tS>t\u0007\u0003BA\u0006\u00033qA!!\u0004\u0002\u0016A\u0019\u0011q\u0002\u001e\u000e\u0005\u0005E!bAA\n;\u00051AH]8pizJ1!a\u0006;\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003\u001e\t\r\u0005\u0005b\u00021\u00019\u0003\u0015a\u0017.\\5u\u0011\u0015Yh\u00021\u0001q\u0011\u001d\t9C\u0004a\u0001\u0003S\tq\"\u001a=uK:$W\rZ\"p]R,\u0007\u0010\u001e\t\u0004K\u0006-\u0012bAA\u0017M\nIR\t\u001f;f]\u0012,GMV1mS\u0012\fG/[8o\u0007>tG/\u001a=u\u0003\u0001\n'/\u001a(fqRLe\u000e^3sm\u0006d7o\u00155peR,'\u000f\u00165b]2KW.\u001b;\u0015\u0011\u0005M\u0012\u0011HA%\u00033\u00022!OA\u001b\u0013\r\t9D\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\tYd\u0004a\u0001\u0003{\tab\u0019:p]\u0016C\bO]3tg&|g\u000e\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005M\u0001\u0007cV\f'\u000f\u001e>\n\t\u0005\u001d\u0013\u0011\t\u0002\u000f\u0007J|g.\u0012=qe\u0016\u001c8/[8o\u0011\u001d\tYe\u0004a\u0001\u0003\u001b\n\u0011b\u001d;beR$\u0016.\\3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015'\u0003\u0011)H/\u001b7\n\t\u0005]\u0013\u0011\u000b\u0002\u0005\t\u0006$X\r\u0003\u0004\u0002\"=\u0001\r\u0001\u000f")
public class ScheduledTriggerValidator
implements Validator<ScheduledTrigger> {
    public static void setApplicationContext(ApplicationContext x$1) {
        ScheduledTriggerValidator$.MODULE$.setApplicationContext(x$1);
    }

    public static ApplicationContext getApplicationContext() {
        return ScheduledTriggerValidator$.MODULE$.getApplicationContext();
    }

    public static void applicationContext_$eq(ApplicationContext x$1) {
        ScheduledTriggerValidator$.MODULE$.applicationContext_$eq(x$1);
    }

    public static ApplicationContext applicationContext() {
        return ScheduledTriggerValidator$.MODULE$.applicationContext();
    }

    public static int NUMBER_OF_INTERVALS_TO_CHECK() {
        return ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK();
    }

    public void validate(ScheduledTrigger trigger, ValidationContext context) {
        FeatureSettings limits = ScheduledTriggerValidator$.MODULE$.com$xebialabs$xlrelease$triggers$scheduled$validators$ScheduledTriggerValidator$$configurationService().getFeatureSettings(Limits$.MODULE$.TYPE_LIMITS());
        int minTriggerInterval = BoxesRunTime.unboxToInt((Object)limits.getProperty(Limits$.MODULE$.MIN_TRIGGER_INTERVAL()));
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limits.getProperty(Limits$.MODULE$.ENABLED()));
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        PollType pollType = trigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            BoxedUnit boxedUnit;
            int period = NumberUtils.toInt((String)trigger.getPeriodicity(), (int)0);
            if (period <= 0) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", new StringBuilder(32).append("Trigger has wrong periodicity '").append(trigger.getPeriodicity()).append("'").toString(), new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            } else if (limitsEnabled && period < minTriggerInterval) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", new StringBuilder(60).append("Trigger must not fire more frequently than once per ").append(minTriggerInterval).append(" seconds").toString(), new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (PollType.CRON.equals(pollType)) {
            BoxedUnit boxedUnit;
            String cron = trigger.getPeriodicity();
            String errorMsg = new StringBuilder(36).append("Trigger has wrong cron expression '").append(cron).append("'").toString();
            if (StringUtils.isBlank((CharSequence)cron)) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            } else if (!CronExpression.isValidExpression((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(cron)))) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            } else if (limitsEnabled) {
                this.validateCron(cron, minTriggerInterval, trigger, extendedContext);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)pollType);
        }
    }

    private void validateCron(String expression, int limit, ScheduledTrigger trigger, ExtendedValidationContext extendedContext) {
        block0: {
            DateTime today;
            CronExpression cronExpression = new CronExpression(QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(expression)));
            boolean intervalsLongerThanLimit = this.areNextIntervalsShorterThanLimit(cronExpression, (today = new DateTime().withTimeAtStartOfDay()).toDate(), limit);
            if (intervalsLongerThanLimit) break block0;
            extendedContext.error((ConfigurationItem)trigger, "periodicity", new StringBuilder(60).append("Trigger must not fire more frequently than once per ").append(limit).append(" seconds").toString(), new Object[0]);
        }
    }

    public boolean areNextIntervalsShorterThanLimit(CronExpression cronExpression, Date startTime, int limit) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef reference = ObjectRef.create((Object)cronExpression.getNextValidTimeAfter(startTime));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                int n = x$2;
                Date nextTime = cronExpression.getNextValidTimeAfter((Date)reference$1.elem);
                int interval = (int)((nextTime.getTime() - ((Date)reference$1.elem).getTime()) / 1000L);
                if (interval < limit) {
                    throw new RuntimeException();
                }
                reference$1.elem = nextTime;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).isSuccess();
    }
}

