/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

public class GHContentSearchBuilder
extends GHSearchBuilder<GHContent> {
    GHContentSearchBuilder(GitHub root) {
        super(root, ContentSearchResult.class);
    }

    public GHContentSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHContentSearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHContentSearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHContentSearchBuilder fork(String v) {
        return this.q("fork:" + v);
    }

    public GHContentSearchBuilder size(String v) {
        return this.q("size:" + v);
    }

    public GHContentSearchBuilder path(String v) {
        return this.q("path:" + v);
    }

    public GHContentSearchBuilder filename(String v) {
        return this.q("filename:" + v);
    }

    public GHContentSearchBuilder extension(String v) {
        return this.q("extension:" + v);
    }

    public GHContentSearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    public GHContentSearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHContentSearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHContentSearchBuilder sort(Sort sort) {
        if (Sort.BEST_MATCH.equals((Object)sort)) {
            this.req.remove("sort");
        } else {
            this.req.with("sort", sort);
        }
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/code";
    }

    private static class ContentSearchResult
    extends SearchResult<GHContent> {
        private GHContent[] items;

        private ContentSearchResult() {
        }

        GHContent[] getItems(GitHub root) {
            for (GHContent item : this.items) {
                item.wrap(root);
            }
            return this.items;
        }
    }

    public static enum Sort {
        BEST_MATCH,
        INDEXED;

    }
}

