/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Sequential Group", versioned=false)
public class SequentialGroup
extends TaskGroup {
    @Override
    @PublicApiMember
    public void setTasks(List<Task> tasks) {
        for (int i = 0; i < tasks.size() - 1; ++i) {
            Task t1 = tasks.get(i);
            Task t2 = tasks.get(i + 1);
            Preconditions.checkArgument((boolean)this.areTaskStatusesInAllowableOrder(t1, t2), (Object)String.format("Sequential group %s cannot have subtask statuses in this order: %s (on task %s), %s (on task %s)", new Object[]{this.getTitle(), t1.getStatus(), t1.getTitle(), t2.getStatus(), t2.getTitle()}));
        }
        this.tasks = tasks;
    }

    private boolean areTaskStatusesInAllowableOrder(Task t1, Task t2) {
        return t1.isDefunct() || t2.isNotYetReached();
    }

    @Override
    protected Changes tryToStartPlanningTargets(Task task) {
        Changes changes = new Changes();
        Task target = this.getPlanningTargetsOf(task);
        if (target == null) {
            return changes;
        }
        if (!task.isActive() && !target.isDefunct()) {
            changes.addAll(target.start());
            if (target.isDone()) {
                changes.addAll(this.tryToStartPlanningTargets(target));
            }
        }
        return changes;
    }

    private Task getPlanningTargetsOf(Task task) {
        int i = this.tasks.indexOf(task);
        if (i == -1 || i >= this.tasks.size() - 1) {
            return null;
        }
        return (Task)this.tasks.get(i + 1);
    }

    @Override
    protected Changes startSubTasksIfPreconditionNotInProgress() {
        Changes changes = new Changes();
        if (this.isPreconditionInProgress()) {
            return changes;
        }
        if (this.tasks.isEmpty()) {
            return changes;
        }
        Task subTask = (Task)this.tasks.get(0);
        changes.addAll(subTask.start());
        if (subTask.isDone()) {
            changes.addAll(this.tryToStartPlanningTargets(subTask));
        }
        return changes;
    }
}

