/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.materializer;

import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.materializer.FilePlugin;
import com.xebialabs.plugin.manager.materializer.FilePlugin$;
import com.xebialabs.plugin.manager.materializer.FilePlugin$FilePluginOps$;
import com.xebialabs.plugin.manager.metadata.XLProduct;
import com.xebialabs.plugin.manager.metadata.XLProduct$;
import com.xebialabs.plugin.manager.metadata.XLProduct$XLDeploy$;
import com.xebialabs.plugin.manager.metadata.XLProduct$XLRelease$;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.sql.DbPlugin;
import com.xebialabs.plugin.manager.sql.DbPlugin$;
import com.xebialabs.plugin.manager.sql.DbPlugin$DbPluginOps$;
import com.xebialabs.plugin.manager.sql.SqlPluginRepository;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Marker;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\u00021Caa\u0016\u0001!\u0002\u0013i\u0005b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007A\u0002\u0001\u000b\u0011\u0002.\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0019\u0004A\u0011A4\t\u000by\u0004A\u0011A@\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!a\n\u0001\t\u0003\tICA\nQYV<\u0017N\\:NCR,'/[1mSj,'O\u0003\u0002\u0016-\u0005aQ.\u0019;fe&\fG.\u001b>fe*\u0011q\u0003G\u0001\b[\u0006t\u0017mZ3s\u0015\tI\"$\u0001\u0004qYV<\u0017N\u001c\u0006\u00037q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003u\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0006g24GG\u001b\u0006\u0002W\u0005AqM]5{u2,G-\u0003\u0002.Q\t9Aj\\4hS:<\u0017\u0001\u00059mk\u001eLgNU3q_NLGo\u001c:z+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0017\u0003\r\u0019\u0018\u000f\\\u0005\u0003kI\u00121cU9m!2,x-\u001b8SKB|7/\u001b;pef\f\u0011\u0003\u001d7vO&t'+\u001a9pg&$xN]=!\u0003\u001d\u0001(o\u001c3vGR,\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005q\u0012S\"A\u001f\u000b\u0005yr\u0012A\u0002\u001fs_>$h(\u0003\u0002AE\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001%%\u0001\u0005qe>$Wo\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0019q)\u0013&\u0011\u0005!\u0003Q\"\u0001\u000b\t\u000b9*\u0001\u0019\u0001\u0019\t\u000b]*\u0001\u0019A\u001d\u0002\u0015AdWoZ5og\u0012K'/F\u0001N!\tqU+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003gS2,'B\u0001*T\u0003\rq\u0017n\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1vJ\u0001\u0003QCRD\u0017a\u00039mk\u001eLgn\u001d#je\u0002\n\u0011\u0002\u001f7Qe>$Wo\u0019;\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\f\u0002\u00115,G/\u00193bi\u0006L!a\u0018/\u0003\u0013ac\u0005K]8ek\u000e$\u0018A\u0003=m!J|G-^2uA\u0005\u0011R.\u0019;fe&\fG.\u001b>f!2,x-\u001b8t)\u0005\u0019\u0007CA\u0011e\u0013\t)'E\u0001\u0003V]&$\u0018a\u00049s_\u000e,7o](gM&\u001c\u0017.\u00197\u0015\u0007\rDg\u000fC\u0003j\u0017\u0001\u0007!.A\u0005ggBcWoZ5ogB\u00191\u000e]:\u000f\u00051tgB\u0001\u001fn\u0013\u0005\u0019\u0013BA8#\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\t1K7\u000f\u001e\u0006\u0003_\n\u0002\"\u0001\u0013;\n\u0005U$\"A\u0003$jY\u0016\u0004F.^4j]\")qo\u0003a\u0001q\u0006IAM\u0019)mk\u001eLgn\u001d\t\u0004Wf\\\u0018B\u0001>s\u0005\r\u0019V-\u001d\t\u0003cqL!! \u001a\u0003\u0011\u0011\u0013\u0007\u000b\\;hS:\fA\u0002\u001d:pG\u0016\u001c8\u000fT8dC2$RaYA\u0001\u0003\u0007AQ!\u001b\u0007A\u0002)DQa\u001e\u0007A\u0002a\fq#\\1uKJL\u0017\r\\5{KR{g)\u001b7fgf\u001cH/Z7\u0015\u0007\r\fI\u0001\u0003\u0004\u0002\f5\u0001\ra_\u0001\tI\n\u0004F.^4j]\u00069rO]5uK>3g-[2jC2$v\u000eR1uC\n\f7/\u001a\u000b\u0004G\u0006E\u0001BBA\n\u001d\u0001\u00071/\u0001\u0005ggBcWoZ5o\u0003Q9(/\u001b;f\u0019>\u001c\u0017\r\u001c+p\t\u0006$\u0018MY1tKR\u00191-!\u0007\t\r\u0005Mq\u00021\u0001t\u0003U\u0019G.Z1okB4%o\\7GS2,7/_:uK6$2aYA\u0010\u0011\u0019\t\u0019\u0002\u0005a\u0001g\u0006\u00192\r\\3b]V\u0004hI]8n\t\u0006$\u0018MY1tKR\u00191-!\n\t\r\u0005-\u0011\u00031\u0001|\u0003QIg.\u001b;Qe>$Wo\u0019;Ta\u0016\u001c\u0017NZ5dgR\u00191-a\u000b\t\r\u00055\"\u00031\u0001[\u0003%AH\u000e\u001d:pIV\u001cG\u000f")
public class PluginsMaterializer
implements Logging {
    private final SqlPluginRepository pluginRepository;
    private final String product;
    private final Path pluginsDir;
    private final XLProduct xlProduct;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginsMaterializer pluginsMaterializer = this;
        synchronized (pluginsMaterializer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlPluginRepository pluginRepository() {
        return this.pluginRepository;
    }

    public String product() {
        return this.product;
    }

    public Path pluginsDir() {
        return this.pluginsDir;
    }

    public XLProduct xlProduct() {
        return this.xlProduct;
    }

    public void materializePlugins() {
        block6: {
            if (!PathSugar$.MODULE$.path2File(this.pluginsDir()).exists() || !this.pluginRepository().pluginTablesExist()) break block6;
            try {
                Map dbPluginsBySource = this.pluginRepository().getAllWithBytes().groupBy((Function1 & Serializable)x$1 -> x$1.source().toString());
                Try try_ = Using$.MODULE$.apply((Function0 & Serializable)() -> Files.list(this.pluginsDir()), (Function1 & Serializable)stream -> {
                    PluginsMaterializer.$anonfun$materializePlugins$3(this, dbPluginsBySource, stream);
                    return BoxedUnit.UNIT;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                if (try_ instanceof Success) {
                    this.info((Function0<Object>)(Function0 & Serializable)() -> "Successfully synchronized plugins between filesystem and database");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    this.error((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(58).append("Error during plugin synchronization process with message: ").append(err.getMessage()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
                this.pluginRepository().updateAllPluginsStatusTo(PluginStatus$.MODULE$.INSTALLED());
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(58).append("Error during plugin materialization process with message: ").append(e.getMessage()).toString());
            }
        }
    }

    public void processOfficial(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(81).append("Processing list of official plugins found on the filesystem ").append(fsPlugins).append(" and in the database ").append(dbPlugins).toString());
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.higherVersionExistsIn$extension(DbPlugin$.MODULE$.DbPluginOps(x$4), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$processOfficial$4(dbPlugins, fsPlugin))).foreach((Function1 & Serializable)fsPlugin -> {
            this.writeOfficialToDatabase(fsPlugin);
            return BoxedUnit.UNIT;
        });
        List fsPluginsToCleanup = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$processOfficial$6(dbPlugins, fsPlugin)));
        fsPluginsToCleanup.foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        List fsPluginsAfterCleanup = fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$processOfficial$8(fsPluginsToCleanup, fsPlugin)));
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$processOfficial$9(fsPluginsAfterCleanup, dbPlugin)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.materializeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
    }

    public void processLocal(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(78).append("Processing list of local plugins found on the filesystem ").append(fsPlugins).append(" and in the database ").append(dbPlugins).toString());
        fsPlugins.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(x$5), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.writeLocalToDatabase(fsPlugin);
            return BoxedUnit.UNIT;
        });
        fsPlugins.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentAndVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(x$6), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.cleanupFromFilesystem(fsPlugin);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$processLocal$6(fsPlugins, dbPlugin)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.materializeToFilesystem(dbPlugin);
            return BoxedUnit.UNIT;
        });
    }

    public void materializeToFilesystem(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(49).append("Synchronizing plugin ").append(dbPlugin.name()).append(" from database to filesystem").toString());
        String fileName = new StringBuilder(1).append(dbPlugin.name()).append((Object)(dbPlugin.version().isEmpty() ? "" : new StringBuilder(1).append("-").append(dbPlugin.version().get()).toString())).append(".").append(dbPlugin.extension()).toString();
        File targetFile = new File(new StringBuilder(0).append(this.pluginsDir()).append(File.separator).append(dbPlugin.source()).append(File.separator).append(fileName).toString());
        FileUtils.writeByteArrayToFile((File)targetFile, (byte[])((byte[])dbPlugin.bytes().get()));
    }

    public void writeOfficialToDatabase(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(49).append("Synchronizing plugin ").append(fsPlugin.name()).append(" from filesystem to database").toString());
        XLProduct xLProduct = this.xlProduct();
        XLProduct$XLDeploy$ xLProduct$XLDeploy$ = XLProduct$XLDeploy$.MODULE$;
        String groupId = !(xLProduct != null ? !xLProduct.equals(xLProduct$XLDeploy$) : xLProduct$XLDeploy$ != null) ? ConfigWrapper$.MODULE$.GROUP_ID_XLD() : ConfigWrapper$.MODULE$.GROUP_ID_XLR();
        XLProduct xLProduct2 = this.xlProduct();
        XLProduct$XLDeploy$ xLProduct$XLDeploy$2 = XLProduct$XLDeploy$.MODULE$;
        Enumeration.Value source = !(xLProduct2 != null ? !xLProduct2.equals(xLProduct$XLDeploy$2) : xLProduct$XLDeploy$2 != null) ? PluginSource$.MODULE$.XLD_OFFICIAL() : PluginSource$.MODULE$.XLR_OFFICIAL();
        byte[] bytes = Files.readAllBytes(fsPlugin.filePath());
        DbPlugin dbPlugin = new DbPlugin(0L, fsPlugin.name(), fsPlugin.version(), fsPlugin.extension(), groupId, PluginStatus$.MODULE$.READY_FOR_INSTALL(), source, DbPlugin$.MODULE$.calculateChecksum(bytes), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)), (Option<byte[]>)new Some((Object)bytes));
        this.pluginRepository().insert(dbPlugin);
    }

    public void writeLocalToDatabase(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(49).append("Synchronizing plugin ").append(fsPlugin.name()).append(" from filesystem to database").toString());
        byte[] bytes = Files.readAllBytes(fsPlugin.filePath());
        DbPlugin dbPlugin = new DbPlugin(0L, fsPlugin.name(), fsPlugin.version(), fsPlugin.extension(), PluginSource$.MODULE$.LOCAL().toString(), PluginStatus$.MODULE$.READY_FOR_INSTALL(), PluginSource$.MODULE$.LOCAL(), DbPlugin$.MODULE$.calculateChecksum(bytes), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)), (Option<byte[]>)new Some((Object)bytes));
        this.pluginRepository().insert(dbPlugin);
    }

    public void cleanupFromFilesystem(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(32).append("Removing plugin ").append(fsPlugin.name()).append(" from filesystem").toString());
        FileUtils.forceDelete((File)PathSugar$.MODULE$.path2File(fsPlugin.filePath()));
    }

    public void cleanupFromDatabase(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(30).append("Removing plugin ").append(dbPlugin.name()).append(" from database").toString());
        this.pluginRepository().delete(dbPlugin);
    }

    public void initProductSpecifics(XLProduct xlproduct) {
        XLProduct xLProduct = xlproduct;
        if (XLProduct$XLDeploy$.MODULE$.equals(xLProduct)) {
            ConfigWrapper$.MODULE$.extension_$eq(ConfigWrapper$.MODULE$.EXTENSION_XLDP());
            ConfigWrapper$.MODULE$.groupId_$eq(ConfigWrapper$.MODULE$.GROUP_ID_XLD());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (XLProduct$XLRelease$.MODULE$.equals(xLProduct)) {
            ConfigWrapper$.MODULE$.extension_$eq(ConfigWrapper$.MODULE$.EXTENSION_JAR());
            ConfigWrapper$.MODULE$.groupId_$eq(ConfigWrapper$.MODULE$.GROUP_ID_XLR());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unknown product name: '").append(xLProduct).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$materializePlugins$6(File x$3) {
        return x$3.getName().endsWith(ConfigWrapper$.MODULE$.extension());
    }

    public static final /* synthetic */ void $anonfun$materializePlugins$3(PluginsMaterializer $this, Map dbPluginsBySource$1, Stream stream) {
        stream.filter(x$2 -> PathSugar$.MODULE$.path2File(x$2).isDirectory()).map(dir -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PluginSource$.MODULE$.withName(((Object)dir.getFileName()).toString())), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])PathSugar$.MODULE$.path2File(dir).listFiles()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PluginsMaterializer.$anonfun$materializePlugins$6(x$3)))), (Function1 & Serializable)filePath -> FilePlugin$.MODULE$.apply(filePath.toPath()), ClassTag$.MODULE$.apply(FilePlugin.class))).toList())).forEach(fsPluginsBySourceEntry -> {
            boolean bl;
            Enumeration.Value value = (Enumeration.Value)fsPluginsBySourceEntry._1();
            Enumeration.Value value2 = PluginSource$.MODULE$.XLD_OFFICIAL();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                bl = true;
            } else {
                Enumeration.Value value4 = PluginSource$.MODULE$.XLR_OFFICIAL();
                Enumeration.Value value5 = value;
                bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
            }
            if (bl) {
                $this.processOfficial((List<FilePlugin>)((List)fsPluginsBySourceEntry._2()), (Seq<DbPlugin>)((Seq)dbPluginsBySource$1.getOrElse((Object)fsPluginsBySourceEntry._1().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = PluginSource$.MODULE$.LOCAL();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    $this.processLocal((List<FilePlugin>)((List)fsPluginsBySourceEntry._2()), (Seq<DbPlugin>)((Seq)dbPluginsBySource$1.getOrElse((Object)fsPluginsBySourceEntry._1().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.error((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(60).append("Could not match plugins directory(source) value ").append(fsPluginsBySourceEntry._1().toString()).append(", skipping..").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$processOfficial$4(Seq dbPlugins$1, FilePlugin fsPlugin) {
        return FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1) || FilePlugin$FilePluginOps$.MODULE$.isHigherVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1);
    }

    public static final /* synthetic */ boolean $anonfun$processOfficial$6(Seq dbPlugins$1, FilePlugin fsPlugin) {
        return FilePlugin$FilePluginOps$.MODULE$.higherVersionExistsIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1) || FilePlugin$FilePluginOps$.MODULE$.hasDifferentContentThanAVersionMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1);
    }

    public static final /* synthetic */ boolean $anonfun$processOfficial$8(List fsPluginsToCleanup$1, FilePlugin fsPlugin) {
        return !fsPluginsToCleanup$1.contains((Object)fsPlugin);
    }

    public static final /* synthetic */ boolean $anonfun$processOfficial$9(List fsPluginsAfterCleanup$1, DbPlugin dbPlugin) {
        return DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPluginsAfterCleanup$1) || DbPlugin$DbPluginOps$.MODULE$.isHigherVersionThanAMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPluginsAfterCleanup$1) || DbPlugin$DbPluginOps$.MODULE$.hasDifferentContentThanAVersionMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPluginsAfterCleanup$1);
    }

    public static final /* synthetic */ boolean $anonfun$processLocal$6(List fsPlugins$2, DbPlugin dbPlugin) {
        return DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins$2) || DbPlugin$DbPluginOps$.MODULE$.shouldReplaceAMatchIn$extension(DbPlugin$.MODULE$.DbPluginOps(dbPlugin), (Seq<FilePlugin>)fsPlugins$2);
    }

    public PluginsMaterializer(SqlPluginRepository pluginRepository, String product) {
        this.pluginRepository = pluginRepository;
        this.product = product;
        Logging.$init$((Logging)this);
        this.pluginsDir = Paths.get("plugins", new String[0]);
        this.xlProduct = XLProduct$.MODULE$.fromString(product);
        this.initProductSpecifics(this.xlProduct());
    }
}

