/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoderProviderConfigurationUtils;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.util.Assert;

public final class ReactiveJwtDecoders {
    private ReactiveJwtDecoders() {
    }

    public static ReactiveJwtDecoder fromOidcIssuerLocation(String oidcIssuerLocation) {
        Assert.hasText((String)oidcIssuerLocation, (String)"oidcIssuerLocation cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForOidcIssuerLocation(oidcIssuerLocation);
        return ReactiveJwtDecoders.withProviderConfiguration(configuration, oidcIssuerLocation);
    }

    public static ReactiveJwtDecoder fromIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForIssuerLocation(issuer);
        return ReactiveJwtDecoders.withProviderConfiguration(configuration, issuer);
    }

    private static ReactiveJwtDecoder withProviderConfiguration(Map<String, Object> configuration, String issuer) {
        JwtDecoderProviderConfigurationUtils.validateIssuer(configuration, issuer);
        OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefaultWithIssuer(issuer);
        String jwkSetUri = configuration.get("jwks_uri").toString();
        RemoteJWKSet jwkSource = new RemoteJWKSet(ReactiveJwtDecoders.url(jwkSetUri));
        Set<SignatureAlgorithm> signatureAlgorithms = JwtDecoderProviderConfigurationUtils.getSignatureAlgorithms((JWKSource<SecurityContext>)jwkSource);
        NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withJwkSetUri(jwkSetUri).jwsAlgorithms(algs -> algs.addAll(signatureAlgorithms)).build();
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }

    private static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

