/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNCharsetConvertor;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;

public class SVNCharsetOutputStream
extends FilterOutputStream {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private SVNCharsetConvertor myCharsetConvertor;
    private ByteBuffer myOutputBuffer;
    private boolean myFlushed;

    public SVNCharsetOutputStream(OutputStream out, Charset inputCharset, Charset outputCharset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharAction) {
        super(out);
        CharsetDecoder decoder = inputCharset.newDecoder();
        decoder.onMalformedInput(malformedInputAction);
        decoder.onUnmappableCharacter(unmappableCharAction);
        CharsetEncoder encoder = outputCharset.newEncoder();
        encoder.onMalformedInput(malformedInputAction);
        encoder.onUnmappableCharacter(unmappableCharAction);
        this.myCharsetConvertor = new SVNCharsetConvertor(decoder, encoder);
        this.myFlushed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myOutputBuffer = this.myCharsetConvertor.convertChunk(b, off, len, this.myOutputBuffer, false);
            this.myOutputBuffer.flip();
            this.out.write(this.myOutputBuffer.array(), this.myOutputBuffer.arrayOffset(), this.myOutputBuffer.limit());
        }
        catch (SVNException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.myFlushed) {
            try {
                this.myOutputBuffer = this.myCharsetConvertor.convertChunk(EMPTY_ARRAY, 0, 0, this.myOutputBuffer, true);
                this.myOutputBuffer = this.myCharsetConvertor.flush(this.myOutputBuffer);
                this.myOutputBuffer.flip();
                this.out.write(this.myOutputBuffer.array(), this.myOutputBuffer.arrayOffset(), this.myOutputBuffer.limit());
            }
            catch (SVNException e) {
                throw new IOExceptionWrapper(e);
            }
            finally {
                this.myFlushed = true;
            }
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SVNCharsetOutputStream");
        buffer.append("[").append(this.myCharsetConvertor);
        buffer.append(']');
        return buffer.toString();
    }
}

