/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.bean;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.csv.opencsv.CSVReader;
import liquibase.util.csv.opencsv.bean.AbstractCSVToBean;
import liquibase.util.csv.opencsv.bean.BeanField;
import liquibase.util.csv.opencsv.bean.CsvToBeanFilter;
import liquibase.util.csv.opencsv.bean.MappingStrategy;

public class CsvToBean<T>
extends AbstractCSVToBean {
    private Map<Class<?>, PropertyEditor> editorMap;

    public List<T> parse(MappingStrategy<T> mapper, Reader reader) {
        return this.parse(mapper, new CSVReader(reader));
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter) {
        return this.parse(mapper, new CSVReader(reader), filter);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv) {
        return this.parse(mapper, csv, null);
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter) {
        long lineProcessed = 0L;
        Object[] line = null;
        try {
            mapper.captureHeader(csv);
        }
        catch (Exception e2) {
            throw new RuntimeException("Error capturing CSV header!", e2);
        }
        try {
            ArrayList list = new ArrayList();
            while (null != (line = csv.readNext())) {
                ++lineProcessed;
                this.processLine(mapper, filter, (String[])line, list);
            }
            return list;
        }
        catch (Exception e3) {
            throw new RuntimeException("Error parsing CSV line: " + lineProcessed + " values: " + Arrays.toString(line), e3);
        }
    }

    private void processLine(MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, List<T> list) throws ReflectiveOperationException, IntrospectionException {
        if (filter == null || filter.allowLine(line)) {
            T obj = this.processLine(mapper, line);
            list.add(obj);
        }
    }

    protected T processLine(MappingStrategy<T> mapper, String[] line) throws ReflectiveOperationException, IntrospectionException {
        T bean = mapper.createBean();
        for (int col = 0; col < line.length; ++col) {
            if (mapper.isAnnotationDriven()) {
                this.processField(mapper, line, bean, col);
                continue;
            }
            this.processProperty(mapper, line, bean, col);
        }
        return bean;
    }

    private void processProperty(MappingStrategy<T> mapper, String[] line, T bean, int col) throws IntrospectionException, ReflectiveOperationException {
        PropertyDescriptor prop = mapper.findDescriptor(col);
        if (null != prop) {
            String value = this.checkForTrim(line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(bean, obj);
        }
    }

    private void processField(MappingStrategy<T> mapper, String[] line, T bean, int col) throws IllegalAccessException {
        BeanField beanField = mapper.findField(col);
        if (beanField != null) {
            String value = line[col];
            beanField.setFieldValue(bean, value);
        }
    }

    private PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((editor = this.editorMap.get(cls)) == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, editor);
        }
        return editor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws ReflectiveOperationException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }
}

