/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery.condition;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import java.util.Date;
import org.joda.time.format.DateTimeFormat;

@Metadata(versioned=false, description="Condition which completes when the specified time is reached.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class TimeCondition
extends Condition {
    @Property(category="input", description="Offset in hours from the delivery start date.")
    private Integer startDateOffset = 24;
    @Property(category="input", description="Fixed time to transition.")
    private Date fixedDate;

    public TimeCondition() {
    }

    public TimeCondition(Date fixedDate) {
        this.fixedDate = fixedDate;
    }

    public TimeCondition(Integer startDateOffset) {
        this.startDateOffset = startDateOffset;
    }

    public TimeCondition(Date fixedDate, Integer startDateOffset) {
        this.fixedDate = fixedDate;
        this.startDateOffset = startDateOffset;
    }

    @Override
    public String getDescription() {
        if (this.hasFixedDate()) {
            return "Wait for fixed date: " + DateTimeFormat.mediumDateTime().print(this.fixedDate.getTime());
        }
        if (this.startDateOffset != null) {
            return String.format("Wait %s hours from delivery start date", this.startDateOffset);
        }
        return "Wait for an undefined date";
    }

    @Override
    public void validate(Delivery delivery) {
        if (delivery.isTemplate()) {
            Checks.checkArgument((this.startDateOffset != null ? 1 : 0) != 0, (String)"Offset value must be provided", (Object[])new Object[0]);
            Checks.checkArgument((this.startDateOffset > 0 ? 1 : 0) != 0, (String)"Offset value must be larger then 0", (Object[])new Object[0]);
        } else {
            Checks.checkArgument((boolean)this.hasFixedDate(), (String)"Fixed date value must be provided", (Object[])new Object[0]);
        }
    }

    private boolean hasFixedDate() {
        return this.fixedDate != null;
    }

    public Date getFixedDate() {
        return this.fixedDate;
    }

    public void setFixedDate(Date fixedDate) {
        this.fixedDate = fixedDate;
    }

    public Integer getStartDateOffset() {
        return this.startDateOffset;
    }

    public void setStartDateOffset(Integer startDateOffset) {
        this.startDateOffset = startDateOffset;
    }
}

