/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.time.Instant;
import java.util.Map;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.oidc.AddressStandardClaim;
import org.springframework.security.oauth2.core.oidc.DefaultAddressStandardClaim;
import org.springframework.util.CollectionUtils;

public interface StandardClaimAccessor
extends ClaimAccessor {
    default public String getSubject() {
        return this.getClaimAsString("sub");
    }

    default public String getFullName() {
        return this.getClaimAsString("name");
    }

    default public String getGivenName() {
        return this.getClaimAsString("given_name");
    }

    default public String getFamilyName() {
        return this.getClaimAsString("family_name");
    }

    default public String getMiddleName() {
        return this.getClaimAsString("middle_name");
    }

    default public String getNickName() {
        return this.getClaimAsString("nickname");
    }

    default public String getPreferredUsername() {
        return this.getClaimAsString("preferred_username");
    }

    default public String getProfile() {
        return this.getClaimAsString("profile");
    }

    default public String getPicture() {
        return this.getClaimAsString("picture");
    }

    default public String getWebsite() {
        return this.getClaimAsString("website");
    }

    default public String getEmail() {
        return this.getClaimAsString("email");
    }

    default public Boolean getEmailVerified() {
        return this.getClaimAsBoolean("email_verified");
    }

    default public String getGender() {
        return this.getClaimAsString("gender");
    }

    default public String getBirthdate() {
        return this.getClaimAsString("birthdate");
    }

    default public String getZoneInfo() {
        return this.getClaimAsString("zoneinfo");
    }

    default public String getLocale() {
        return this.getClaimAsString("locale");
    }

    default public String getPhoneNumber() {
        return this.getClaimAsString("phone_number");
    }

    default public Boolean getPhoneNumberVerified() {
        return this.getClaimAsBoolean("phone_number_verified");
    }

    default public AddressStandardClaim getAddress() {
        Map<String, Object> addressFields = this.getClaimAsMap("address");
        return !CollectionUtils.isEmpty(addressFields) ? new DefaultAddressStandardClaim.Builder(addressFields).build() : new DefaultAddressStandardClaim.Builder().build();
    }

    default public Instant getUpdatedAt() {
        return this.getClaimAsInstant("updated_at");
    }
}

