/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.ordering.OrderPatch;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderPatchMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger((Class)OrderPatchMethod.class);

    public OrderPatchMethod(String uri, OrderPatch orderPatch) throws IOException {
        super(uri);
        this.setRequestBody(orderPatch);
    }

    public OrderPatchMethod(String uri, String orderingType, String memberSegment, boolean first) throws IOException {
        super(uri);
        String orderPosition = first ? "first" : "last";
        Position p = new Position(orderPosition);
        OrderPatch op = new OrderPatch(orderingType, new OrderPatch.Member(memberSegment, p));
        this.setRequestBody(op);
    }

    public OrderPatchMethod(String uri, String orderingType, String memberSegment, String targetMemberSegmet, boolean before) throws IOException {
        super(uri);
        String orderPosition = before ? "before" : "after";
        Position p = new Position(orderPosition, targetMemberSegmet);
        OrderPatch op = new OrderPatch(orderingType, new OrderPatch.Member(memberSegment, p));
        this.setRequestBody(op);
    }

    public String getName() {
        return "ORDERPATCH";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

