/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.core.query.lucene.TextExtractorJob;

class TextExtractorReader
extends Reader {
    private static final Executor DIRECT_EXECUTOR = new DirectExecutor();
    private Reader extractedText;
    private TextExtractorJob job;
    private final Executor executor;
    private final long timeout;
    private boolean jobStarted = false;

    TextExtractorReader(TextExtractorJob job, Executor executor, long timeout) {
        this.job = job;
        this.executor = executor;
        this.timeout = timeout;
    }

    public void close() throws IOException {
        if (this.extractedText != null) {
            this.extractedText.close();
        }
        if (this.jobStarted) {
            this.job.discard();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.extractedText == null) {
            if (this.jobStarted) {
                this.extractedText = this.job.getReader(Long.MAX_VALUE);
            } else {
                try {
                    DIRECT_EXECUTOR.execute((Runnable)this.job);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.extractedText = this.job.getReader(0L);
            }
            if (this.extractedText == null) {
                this.extractedText = new StringReader("");
            }
        }
        return this.extractedText.read(cbuf, off, len);
    }

    public boolean isExtractorFinished() {
        if (!this.jobStarted) {
            try {
                this.executor.execute((Runnable)this.job);
                this.jobStarted = true;
            }
            catch (InterruptedException e) {
                return false;
            }
            this.extractedText = this.job.getReader(this.timeout);
        } else {
            this.extractedText = this.job.getReader(0L);
        }
        if (this.extractedText == null && this.job.getException() != null) {
            this.extractedText = new StringReader("");
        }
        return this.extractedText != null;
    }
}

