/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.ArrayList;

@PublicApiRef
@Metadata(label="ReleaseStatusFailedRiskAssessor", versioned=false)
public class ReleaseStatusFailedRiskAssessor
extends RiskAssessor {
    private static final String RELEASE_FAILED_HEADLINE = "Release has failed";

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.isFailed()) {
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            assessment.setHeadline(RELEASE_FAILED_HEADLINE);
            messages.add(String.format("%s has failed", release.getTitle()));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }
}

