/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.FacetApi;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.facet.ConfigurationFacet;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class FacetApiImpl
implements FacetApi {
    private final FacetService facetService;
    private final PermissionChecker permissions;
    private final FacetPermissionChecker facetPermissions;

    @Autowired
    public FacetApiImpl(FacetService facetService, PermissionChecker permissions, FacetPermissionChecker facetPermissions) {
        this.facetService = facetService;
        this.permissions = permissions;
        this.facetPermissions = facetPermissions;
    }

    @Timed
    public Facet getFacet(String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)facet.getTargetId()), () -> this.permissions.checkView(Ids.releaseIdFrom((String)facet.getTargetId())));
        this.checkIsConfigurationFacet(facet, "Cannot fetch facet of this type (" + facet.getType() + ")");
        return facet;
    }

    @Timed
    public Facet createFacet(ConfigurationFacet configurationFacet) {
        this.performConfigurationFacetPermissionChecks((Facet)configurationFacet);
        return this.facetService.create((Facet)configurationFacet);
    }

    @Timed
    public Facet newFacet(String type) {
        Facet facet = (Facet)Type.valueOf((String)type).getDescriptor().newInstance("");
        this.checkIsConfigurationFacet(facet, "You can only create Configuration type facets.");
        return facet;
    }

    @Timed
    public Facet updateFacet(String facetId, ConfigurationFacet configurationFacet) {
        this.performConfigurationFacetPermissionChecks((Facet)configurationFacet);
        configurationFacet.setId(facetId);
        return this.facetService.update((Facet)configurationFacet);
    }

    @Timed
    public void deleteFacet(String facetId) {
        Facet facet = this.facetService.get(facetId);
        this.performConfigurationFacetPermissionChecks(facet);
        this.checkIsConfigurationFacet(facet, "You can only remove Configuration facets");
        this.facetService.delete(facetId);
    }

    @Timed
    public List<Facet> searchFacets(FacetFilters facetFilters) {
        facetFilters.validate();
        String containerId = facetFilters.getParentId() != null ? facetFilters.getParentId() : facetFilters.getTargetId();
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(Ids.releaseIdFrom((String)containerId), () -> this.permissions.checkView(Ids.releaseIdFrom((String)containerId)));
        this.checkFiltersOnlyContainSearchableTypes(facetFilters);
        return this.facetService.search(facetFilters);
    }

    @Timed
    public List<Descriptor> getFacetTypes(String baseType) {
        return this.facetService.getFacetTypes(baseType);
    }

    private void performConfigurationFacetPermissionChecks(Facet facet) {
        String releaseId = Ids.releaseIdFrom((String)facet.getTargetId());
        this.facetPermissions.checkThatScriptTaskBelongsToReleaseOrOtherwise(releaseId, () -> this.permissions.checkEditTaskConfigurationFacet(releaseId));
    }

    private void checkIsConfigurationFacet(Facet facet, String exceptionMsg) {
        if (!facet.getType().instanceOf(Type.valueOf(ConfigurationFacet.class))) {
            throw new IllegalArgumentException(exceptionMsg);
        }
    }

    private void checkFiltersOnlyContainSearchableTypes(FacetFilters facetFilters) {
        if (facetFilters.getTypes() == null || facetFilters.getTypes().isEmpty()) {
            facetFilters.setTypes((List)Lists.newArrayList((Object[])new Type[]{Type.valueOf(ConfigurationFacet.class)}));
        } else if (facetFilters.getTypes().stream().anyMatch(facetType -> facetType.instanceOf(Type.valueOf(TaskReportingRecord.class)))) {
            throw new IllegalArgumentException("Facet filters contain type not searchable by this API");
        }
    }
}

