/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;

public class LockRecord
extends ClusterRecord {
    static final char IDENTIFIER = 'L';
    private NodeId nodeId;
    private boolean isLock;
    private boolean isDeep;
    private String userId;

    public LockRecord(NodeId nodeId, boolean isDeep, String userId, Record record, String workspace) {
        super(record, workspace);
        this.nodeId = nodeId;
        this.isLock = true;
        this.isDeep = isDeep;
        this.userId = userId;
    }

    public LockRecord(NodeId nodeId, Record record, String workspace) {
        super(record, workspace);
        this.nodeId = nodeId;
        this.isLock = false;
    }

    LockRecord(Record record, String workspace) {
        super(record, workspace);
    }

    protected void doRead() throws JournalException {
        this.nodeId = this.record.readNodeId();
        this.isLock = this.record.readBoolean();
        if (this.isLock) {
            this.isDeep = this.record.readBoolean();
            this.userId = this.record.readString();
        }
    }

    protected void doWrite() throws JournalException {
        this.record.writeChar('L');
        this.record.writeNodeId(this.nodeId);
        this.record.writeBoolean(this.isLock);
        if (this.isLock) {
            this.record.writeBoolean(this.isDeep);
            this.record.writeString(this.userId);
        }
    }

    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public String getUserId() {
        return this.userId;
    }
}

