/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.infrastructure;

import com.google.common.io.CharStreams;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertyPlaceholderHelper;

public class FilePlaceholderParser {
    private Properties properties;

    public FilePlaceholderParser(File properties) throws IOException {
        this.loadDecrypted(properties);
    }

    private void loadDecrypted(File properties) throws IOException {
        Properties rawProperties = new Properties();
        try (FileReader fileReader = new FileReader(properties);){
            rawProperties.load(fileReader);
        }
        this.properties = new Properties();
        for (Object key : rawProperties.keySet()) {
            this.properties.put(key, this.convertValue(rawProperties.getProperty((String)key)));
        }
    }

    public Resource parse(String classpathLocation) throws IOException {
        String fileContent = CharStreams.toString((Readable)new InputStreamReader(new ClassPathResource(classpathLocation).getInputStream()));
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
        String result = propertyPlaceholderHelper.replacePlaceholders(fileContent, this.properties);
        return new ByteArrayResource(result.getBytes());
    }

    private String convertValue(String originalValue) {
        String decryptedValue = originalValue;
        if (PasswordEncrypter.getInstance().isEncodedAndDecryptable(originalValue)) {
            decryptedValue = PasswordEncrypter.getInstance().decrypt(originalValue);
        }
        return decryptedValue;
    }
}

