/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.ServerResource;
import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsAuthenticationFinder;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.plugin.manager.service.PluginService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.support.report.repository.DataStatisticsRepository;
import com.xebialabs.xlrelease.views.ClusterInfoView;
import com.xebialabs.xlrelease.views.LicenseView;
import com.xebialabs.xlrelease.views.PluginView;
import com.xebialabs.xlrelease.views.ServerInfoView;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

@Path(value="/server")
@Controller
public class ReleaseServerResource
extends ServerResource {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseServerResource.class);
    private final ServerConfiguration serverConfiguration;
    private final LicenseService licenseService;
    private final PluginService pluginService;
    private final DataStatisticsRepository dataStatisticsRepository;

    @Autowired
    public ReleaseServerResource(LicenseService licenseService, List<ViewAsAuthenticationFinder> viewAsAuthenticationFinders, RoleService roleService, ServerConfiguration serverConfiguration, ViewAsData viewAsData, PluginService pluginService, DataStatisticsRepository dataStatisticsRepository) {
        super(licenseService, viewAsAuthenticationFinders, roleService, serverConfiguration, viewAsData);
        this.serverConfiguration = serverConfiguration;
        this.licenseService = licenseService;
        this.pluginService = pluginService;
        this.dataStatisticsRepository = dataStatisticsRepository;
    }

    @GET
    @Timed
    @Path(value="host")
    @Produces(value={"application/json"})
    public ServerInfoView getHostUrl() {
        return new ServerInfoView(this.serverConfiguration.getServerUrl());
    }

    @GET
    @Timed
    @Path(value="license")
    @Produces(value={"application/json"})
    public LicenseView getLicence() {
        return new LicenseView(this.licenseService.getLicense());
    }

    @GET
    @Timed
    @Path(value="cluster")
    @Produces(value={"application/json"})
    public ClusterInfoView getClusterInfo() {
        ClusterInfoView clusterInfoView = new ClusterInfoView();
        clusterInfoView.setClusterMode(XlrConfig.getInstance().clusterMode().configOption());
        clusterInfoView.setClusterName(XlrConfig.getInstance().cluster().name());
        if (XlrConfig.getInstance().cluster().config().hasPath("clusterPort")) {
            clusterInfoView.setClusterPort(XlrConfig.getInstance().cluster().config().getInt("clusterPort"));
        }
        if (XlrConfig.getInstance().cluster().config().hasPath("hostname")) {
            clusterInfoView.setNodeHostname(XlrConfig.getInstance().cluster().config().getString("hostname"));
        }
        return clusterInfoView;
    }

    @GET
    @Timed
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("client.session.remember.enabled", this.serverConfiguration.isClientSessionRememberEnabled());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    @Path(value="account-information")
    @Produces(value={"application/json"})
    public Map<String, Object> getAccountInformation() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            LicenseView licenseView = new LicenseView(this.licenseService.getLicense());
            Collection installedPlugins = CollectionConverters.asJavaCollection((Iterable)((Iterable)this.pluginService.extend(this.pluginService.listInstalled()).map(dto -> new PluginView(dto.artifactId()))));
            properties.put("serverUrl", this.serverConfiguration.getServerUrl());
            properties.put("name", licenseView.getLicensedTo());
            properties.put("product", licenseView.getProduct());
            properties.put("edition", licenseView.getEdition());
            properties.put("version", CurrentVersion.get());
            properties.put("plugins", installedPlugins.stream().map(Object::toString).collect(Collectors.toList()));
            String dbName = "unknown";
            try {
                dbName = this.dataStatisticsRepository.findMainDbImplementation();
            }
            finally {
                properties.put("database", dbName);
            }
        }
        catch (Exception exception) {
            logger.warn("Unable to fetch account information", (Throwable)exception);
        }
        return properties;
    }
}

