/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import org.commonmark.internal.util.Parsing;

public class LinkScanner {
    public static int scanLinkLabelContent(CharSequence input, int start) {
        block5: for (int i = start; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    if (!Parsing.isEscapable(input, i + 1)) continue block5;
                    ++i;
                    continue block5;
                }
                case ']': {
                    return i;
                }
                case '[': {
                    return -1;
                }
            }
        }
        return input.length();
    }

    public static int scanLinkDestination(CharSequence input, int start) {
        if (start >= input.length()) {
            return -1;
        }
        if (input.charAt(start) == '<') {
            block5: for (int i = start + 1; i < input.length(); ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '\\': {
                        if (!Parsing.isEscapable(input, i + 1)) continue block5;
                        ++i;
                        continue block5;
                    }
                    case '\n': 
                    case '<': {
                        return -1;
                    }
                    case '>': {
                        return i + 1;
                    }
                }
            }
            return -1;
        }
        return LinkScanner.scanLinkDestinationWithBalancedParens(input, start);
    }

    public static int scanLinkTitle(CharSequence input, int start) {
        char endDelimiter;
        if (start >= input.length()) {
            return -1;
        }
        switch (input.charAt(start)) {
            case '\"': {
                endDelimiter = '\"';
                break;
            }
            case '\'': {
                endDelimiter = '\'';
                break;
            }
            case '(': {
                endDelimiter = ')';
                break;
            }
            default: {
                return -1;
            }
        }
        int afterContent = LinkScanner.scanLinkTitleContent(input, start + 1, endDelimiter);
        if (afterContent == -1) {
            return -1;
        }
        if (afterContent >= input.length() || input.charAt(afterContent) != endDelimiter) {
            return -1;
        }
        return afterContent + 1;
    }

    public static int scanLinkTitleContent(CharSequence input, int start, char endDelimiter) {
        for (int i = start; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\' && Parsing.isEscapable(input, i + 1)) {
                ++i;
                continue;
            }
            if (c == endDelimiter) {
                return i;
            }
            if (endDelimiter != ')' || c != '(') continue;
            return -1;
        }
        return input.length();
    }

    private static int scanLinkDestinationWithBalancedParens(CharSequence input, int start) {
        int parens = 0;
        block6: for (int i = start; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\u0000': 
                case ' ': {
                    return i != start ? i : -1;
                }
                case '\\': {
                    if (!Parsing.isEscapable(input, i + 1)) continue block6;
                    ++i;
                    continue block6;
                }
                case '(': {
                    if (++parens <= 32) continue block6;
                    return -1;
                }
                case ')': {
                    if (parens == 0) {
                        return i;
                    }
                    --parens;
                    continue block6;
                }
                default: {
                    if (!Character.isISOControl(c)) continue block6;
                    return i != start ? i : -1;
                }
            }
        }
        return input.length();
    }
}

