/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.service.replacement.PlaceHolderStateException;
import com.xebialabs.deployit.util.Tuple;
import java.util.Map;

public class PlaceholderExpander {
    public static MapStringStringView expand(MapStringStringView entries) {
        MapStringStringView expanded = new MapStringStringView();
        expanded.putAll((Map)entries);
        PlaceholderExpander.doExpand(expanded);
        return expanded;
    }

    private static void doExpand(MapStringStringView expanded) {
        for (Map.Entry<String, StringValue> entry : expanded.getWrapped().entrySet()) {
            StringValue value = (StringValue)entry.getValue();
            value = PlaceholderExpander.doExpand(expanded, entry, value);
            expanded.put(entry.getKey(), value);
        }
    }

    private static StringValue doExpand(MapStringStringView expanded, Map.Entry<String, StringValue> entry, StringValue value) {
        Tuple<Integer, Integer> marker = PlaceholderExpander.findMarker(value);
        if (marker.getA() != -1) {
            StringValue expandedValue = PlaceholderExpander.expand(value, entry, marker, expanded);
            String s = value.toString().substring(0, marker.getA()) + expandedValue + value.toString().substring(marker.getB() + 2);
            value = value instanceof EncryptedStringValue || expandedValue instanceof EncryptedStringValue ? PlaceholderExpander.doExpand(expanded, entry, (StringValue)new EncryptedStringValue(s)) : PlaceholderExpander.doExpand(expanded, entry, new StringValue(s));
        }
        return value;
    }

    private static StringValue expand(StringValue value, Map.Entry<String, StringValue> entry, Tuple<Integer, Integer> marker, MapStringStringView expanded) {
        String key = value.toString().substring(marker.getA() + 2, marker.getB());
        if (key.equals(entry.getKey())) {
            throw new PlaceHolderStateException(String.format("Cannot expand placeholder %s because it contains a cyclic reference. Key %s refers to %s.", value, entry.getKey(), entry.getValue()), new Object[0]);
        }
        if (!expanded.containsKey((Object)key)) {
            throw new PlaceHolderStateException(String.format("Cannot expand placeholder %s because it references an unknown key %s", value, key), new Object[0]);
        }
        return (StringValue)expanded.getWrapped().get(key);
    }

    private static Tuple<Integer, Integer> findMarker(StringValue value) {
        int beginMarker = value.toString().indexOf("{{");
        if (beginMarker > -1) {
            int endMarker = value.toString().indexOf("}}", beginMarker);
            if (endMarker == -1) {
                throw new PlaceHolderStateException("Couldn't find placeholder end marker in [" + value + "]", new Object[0]);
            }
            return Tuple.of(beginMarker, endMarker);
        }
        return Tuple.of(-1, -1);
    }
}

