/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.lock.AbstractActiveLock;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrActiveLock
extends AbstractActiveLock
implements ActiveLock,
DavConstants {
    private static Logger log = LoggerFactory.getLogger((Class)JcrActiveLock.class);
    private final Lock lock;
    private final boolean sessionScoped;

    public JcrActiveLock(Lock lock) {
        this(lock, lock.isSessionScoped());
    }

    public JcrActiveLock(Lock lock, boolean sessionScoped) {
        if (lock == null) {
            throw new IllegalArgumentException("Can not create a ActiveLock with a 'null' argument.");
        }
        this.lock = lock;
        this.sessionScoped = sessionScoped;
    }

    public boolean isLockedByToken(String lockToken) {
        return lockToken != null && lockToken.equals(this.getToken());
    }

    public boolean isExpired() {
        try {
            return !this.lock.isLive();
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: " + e.getMessage());
            return false;
        }
    }

    public String getToken() {
        return this.lock.getLockToken();
    }

    public String getOwner() {
        return this.lock.getLockOwner();
    }

    public void setOwner(String owner) {
        throw new UnsupportedOperationException("setOwner is not implemented");
    }

    public long getTimeout() {
        return Integer.MAX_VALUE;
    }

    public void setTimeout(long timeout) {
        throw new UnsupportedOperationException("setTimeout is not implemented");
    }

    public boolean isDeep() {
        boolean isDeep = true;
        Node n = this.lock.getNode();
        try {
            if (n.holdsLock() && n.hasProperty("jcr:lockIsDeep")) {
                isDeep = n.getProperty("jcr:lockIsDeep").getBoolean();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return isDeep;
    }

    public void setIsDeep(boolean isDeep) {
        throw new UnsupportedOperationException("setIsDeep is not implemented");
    }

    public Type getType() {
        return Type.WRITE;
    }

    public Scope getScope() {
        return this.sessionScoped ? ItemResourceConstants.EXCLUSIVE_SESSION : Scope.EXCLUSIVE;
    }
}

