/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.builder;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.HashMap;
import java.util.Map;

public class RiskProfileBuilder {
    private String id;
    private String title;
    private Map<String, String> riskAssessors = new HashMap<String, String>();

    public static RiskProfileBuilder newRiskProfile() {
        return new RiskProfileBuilder();
    }

    public RiskProfileBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RiskProfileBuilder withRiskAssessor(String riskAssessorKey, String score) {
        this.riskAssessors.put(riskAssessorKey, score);
        return this;
    }

    public RiskProfile build() {
        RiskProfile riskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.id);
        DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class)).stream().filter(t -> !t.getDescriptor().isVirtual()).forEach(t -> riskProfile.setValueFor(t, ((Integer)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()).intValue()));
        riskProfile.setTitle(this.title);
        riskProfile.setRiskProfileAssessors(this.riskAssessors);
        return riskProfile;
    }

    public RiskProfileBuilder withTitle(String title) {
        this.title = title;
        return this;
    }
}

