/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.iapi.services.i18n.BundleFinder;
import org.apache.derby.shared.common.error.ShutdownException;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String string) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(string), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void setFinder(BundleFinder bundleFinder) {
        finder = bundleFinder;
    }

    public static String getTextMessage(String string, Object ... objectArray) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(string), string, objectArray, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
    }

    public static String getProperty(String string, String string2) {
        ResourceBundle resourceBundle = MessageService.getBundle(string);
        try {
            if (resourceBundle != null) {
                return resourceBundle.getString(string.concat(".").concat(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block12: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block12;
                    throw missingResourceException;
                }
            }
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = objectArray.length;
        if (n > 0) {
            stringBuffer.append(" : ");
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("] ");
            if (objectArray[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    private static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (finder != null) {
            resourceBundle = finder.getBundle(string);
        }
        if (resourceBundle == null) {
            resourceBundle = MessageService.getBundleForLocale(Locale.getDefault(), string);
        }
        return resourceBundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundle.getBundle(string, EN);
        }
    }

    public static int hashString50(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 5) {
            n2 = 5;
        }
        for (int i = 0; i < n2; ++i) {
            n += string.charAt(i);
        }
        return n %= 50;
    }
}

