/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.list.TypedList;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeDefinitionTemplate;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeDefinition;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.api.jsr283.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionTemplateImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionTemplateImpl;

public class NodeTypeTemplateImpl
implements NodeTypeTemplate {
    private String name;
    private String[] superTypeNames;
    private String primaryItemName;
    private boolean abstractStatus;
    private boolean mixin;
    private boolean orderableChildNodes;
    private List nodeDefinitionTemplates;
    private List propertyDefinitionTemplates;

    NodeTypeTemplateImpl() {
    }

    NodeTypeTemplateImpl(NodeTypeDefinition def) {
        PropertyDefinition[] propDefs;
        this.name = def.getName();
        this.superTypeNames = def.getDeclaredSupertypeNames();
        this.primaryItemName = def.getPrimaryItemName();
        this.abstractStatus = def.isAbstract();
        this.mixin = def.isMixin();
        this.orderableChildNodes = def.hasOrderableChildNodes();
        NodeDefinition[] nodeDefs = def.getDeclaredChildNodeDefinitions();
        if (nodeDefs != null) {
            List list = this.getNodeDefinitionTemplates();
            for (int i = 0; i < nodeDefs.length; ++i) {
                list.add(new NodeDefinitionTemplateImpl(nodeDefs[i]));
            }
        }
        if ((propDefs = def.getDeclaredPropertyDefinitions()) != null) {
            List list = this.getPropertyDefinitionTemplates();
            for (int i = 0; i < propDefs.length; ++i) {
                list.add(new PropertyDefinitionTemplateImpl(propDefs[i]));
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeclaredSuperTypeNames(String[] names) {
        this.superTypeNames = names;
    }

    public void setAbstract(boolean abstractStatus) {
        this.abstractStatus = abstractStatus;
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setOrderableChildNodes(boolean orderable) {
        this.orderableChildNodes = orderable;
    }

    public void setPrimaryItemName(String name) {
        this.primaryItemName = name;
    }

    public List getPropertyDefinitionTemplates() {
        if (this.propertyDefinitionTemplates == null) {
            this.propertyDefinitionTemplates = TypedList.decorate(new ArrayList(), (Class)PropertyDefinitionTemplate.class);
        }
        return this.propertyDefinitionTemplates;
    }

    public List getNodeDefinitionTemplates() {
        if (this.nodeDefinitionTemplates == null) {
            this.nodeDefinitionTemplates = TypedList.decorate(new ArrayList(), (Class)NodeDefinitionTemplate.class);
        }
        return this.nodeDefinitionTemplates;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDeclaredSupertypeNames() {
        return this.superTypeNames;
    }

    public boolean isAbstract() {
        return this.abstractStatus;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.propertyDefinitionTemplates == null) {
            return null;
        }
        return this.propertyDefinitionTemplates.toArray(new PropertyDefinition[this.propertyDefinitionTemplates.size()]);
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.nodeDefinitionTemplates == null) {
            return null;
        }
        return this.nodeDefinitionTemplates.toArray(new NodeDefinition[this.nodeDefinitionTemplates.size()]);
    }
}

