/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r]h\u0001B\u001c9\u0001\rC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\ta\u0002\u0011)\u0019!C\tc\"AQ\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0005x\u0011!Y\bA!A!\u0002\u0013A\b\u0002\u0003?\u0001\u0005\u000b\u0007I\u0011C?\t\u0013\u0005\r\u0001A!A!\u0002\u0013q\bBCA\u0003\u0001\t\u0015\r\u0011\"\u0005\u0002\b!Q\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005E\u0001A!b\u0001\n#\t\u0019\u0002\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003+A!\"!\b\u0001\u0005\u000b\u0007I\u0011AA\u0010\u0011)\ti\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\u000b\u0003_\u0001!Q1A\u0005\u0002\u0005E\u0002BCA\u001d\u0001\t\u0005\t\u0015!\u0003\u00024!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005\r\u0003A!b\u0001\n\u0007\t)\u0005\u0003\u0006\u0002v\u0001\u0011\t\u0011)A\u0005\u0003\u000fBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011q\u001e\u0001\u0005B\u0005E\bbBAx\u0001\u0011\u0005\u0013q\u001f\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u0011y\u0005\u0001C!\u0005#BqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003\u0000\u0001!\tE!!\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011\u001d\u0011\t\u000e\u0001C!\u0005'DqAa7\u0001\t\u0003\u0012i\u000eC\u0004\u0003j\u0002!\tEa;\t\u000f\r5\u0001\u0001\"\u0011\u0004\u0010!91Q\u0003\u0001\u0005B\r]\u0001bBB\u0011\u0001\u0011\u000531\u0005\u0005\b\u0007[\u0001A\u0011IB\u0018\u0011\u001d\u0019i\u0004\u0001C!\u0007\u007fAqaa\u0012\u0001\t\u0003\u001aI\u0005C\u0004\u0004R\u0001!\tea\u0015\t\u000f\rE\u0003\u0001\"\u0011\u0004Z!91Q\r\u0001\u0005B\r\u001d\u0004bBB8\u0001\u0011\u00053\u0011\u000f\u0005\b\u0007\u0003\u0003A\u0011BBB\u0011\u001d\u00199\n\u0001C\u0005\u00073Cqaa(\u0001\t\u0003\u001a\t\u000bC\u0004\u00048\u0002!\te!/\t\u000f\r}\u0006\u0001\"\u0011\u0004B\"I1\u0011\u001a\u0001A\u0002\u0013\u000511\u001a\u0005\n\u0007+\u0004\u0001\u0019!C\u0001\u0007/D\u0001b!8\u0001A\u0003&1Q\u001a\u0005\b\u0007?\u0004A\u0011ABq\u0011\u001d\u00199\u000f\u0001C\u0005\u0007S\u0014AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u001d;\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003wq\n!B]3q_NLGo\u001c:z\u0015\tid(A\u0005yYJ,G.Z1tK*\u0011q\bQ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!Q\u0001\u0004G>l7\u0001A\n\t\u0001\u0011Se\n\u00171dMB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1\u0011I\\=SK\u001a\u0004\"a\u0013'\u000e\u0003iJ!!\u0014\u001e\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002P!Jk\u0011\u0001O\u0005\u0003#b\u0012Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002T-6\tAK\u0003\u0002Vy\u00051Am\\7bS:L!a\u0016+\u0003\u000fI+G.Z1tKB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0006g24GG\u001b\u0006\u0002;\u0006AqM]5{u2,G-\u0003\u0002`5\n9Aj\\4hS:<\u0007CA(b\u0013\t\u0011\u0007H\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\tyE-\u0003\u0002fq\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u0003\u001f\u001eL!\u0001\u001b\u001d\u00035M\u000bHNU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:\u0002%I,G.Z1tKB+'o]5ti\u0016t7-\u001a\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[b\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\u000e\u001c\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005\u0011\bCA6t\u0013\t!HNA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003a\u0004\"a[=\n\u0005id'!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005\u00112m\\7nK:$\b+\u001a:tSN$XM\\2f+\u0005q\bCA6\u0000\u0013\r\t\t\u0001\u001c\u0002\u0013\u0007>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-A\nd_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0016\u0005\u0005%\u0001cA&\u0002\f%\u0019\u0011Q\u0002\u001e\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006yA/Z1n%\u0016\u0004xn]5u_JL\b%A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u000b\u0003\u0003+\u00012aSA\f\u0013\r\tIB\u000f\u0002\u001c%\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u00029I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:zA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dB.A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003W\t)CA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\u0011\u00111\u0007\t\u0004\u001f\u0006U\u0012bAA\u001cq\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s!\rY\u0015qH\u0005\u0004\u0003\u0003R$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!b]9m\t&\fG.Z2u+\t\t9\u0005\u0005\u0003\u0002J\u0005=d\u0002BA&\u0003SrA!!\u0014\u0002f9!\u0011qJA1\u001d\u0011\t\t&a\u0018\u000f\t\u0005M\u0013Q\f\b\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\"\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015BA A\u0013\tid(C\u0002\u0002dq\n!\u0001\u001a2\n\u0007e\n9GC\u0002\u0002dqJA!a\u001b\u0002n\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007e\n9'\u0003\u0003\u0002r\u0005M$a\u0002#jC2,7\r\u001e\u0006\u0005\u0003W\ni'A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002|\u0005\u0005\u00151QAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0015\u0011\u0013\u000b\u0005\u0003{\ny\b\u0005\u0002P\u0001!9\u00111I\nA\u0004\u0005\u001d\u0003\"B5\u0014\u0001\u0004Q\u0007\"\u00029\u0014\u0001\u0004\u0011\b\"\u0002<\u0014\u0001\u0004A\b\"\u0002?\u0014\u0001\u0004q\bbBA\u0003'\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003#\u0019\u0002\u0019AA\u000b\u0011\u001d\tib\u0005a\u0001\u0003CAq!a\f\u0014\u0001\u0004\t\u0019\u0004C\u0004\u0002<M\u0001\r!!\u0010\u0002\r\u0015D\u0018n\u001d;t)\u0011\t9*!(\u0011\u0007\u0015\u000bI*C\u0002\u0002\u001c\u001a\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002 R\u0001\r!!)\u0002\u0005%$\u0007\u0003BAR\u0003WsA!!*\u0002(B\u0019\u0011Q\u000b$\n\u0007\u0005%f)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\u000byK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S3\u0005f\u0001\u000b\u00024B!\u0011QWA^\u001b\t\t9L\u0003\u0003\u0002:\u00065\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!0\u00028\nQ\u0011j\u001d*fC\u0012|e\u000e\\=)\u0007Q\t\t\r\u0005\u0003\u0002D\u0006EWBAAc\u0015\u0011\t9-!3\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002L\u00065\u0017aB7fiJL7m\u001d\u0006\u0004\u0003\u001f\u0004\u0015\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005M\u0017Q\u0019\u0002\u0006)&lW\rZ\u0001\u0007GJ,\u0017\r^3\u0015\u000bI\u000bI.!8\t\r\u0005mW\u00031\u0001S\u0003\u001d\u0011X\r\\3bg\u0016Dq!a8\u0016\u0001\u0004\t\t/A\u000bsK2,\u0017m]3De\u0016\fG/[8o'>,(oY3\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:U\u0003\u0019)g/\u001a8ug&!\u00111^As\u0005U\u0011V\r\\3bg\u0016\u001c%/Z1uS>t7k\\;sG\u0016D3!FAa\u0003!1\u0017N\u001c3Cs&#Gc\u0001*\u0002t\"9\u0011q\u0014\fA\u0002\u0005\u0005\u0006f\u0001\f\u0002BR)!+!?\u0002|\"9\u0011qT\fA\u0002\u0005\u0005\u0006bBA\u007f/\u0001\u0007\u0011q`\u0001\u000fe\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8t!\u0011\u0011\tA!\u0004\u000e\u0005\t\r!bA\u001e\u0003\u0006)!!q\u0001B\u0005\u0003\u0011Q7o\u001c8\u000b\u0007\t-A(A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0005\u001f\u0011\u0019A\u0001\bSKN|GN^3PaRLwN\\:)\u0007]\t\t-A\bgS:$\u0017\nZ:CsN#\u0018\r^;t)\u0011\u00119B!\u000b\u0011\r\te!1EAQ\u001d\u0011\u0011YBa\b\u000f\t\u0005U#QD\u0005\u0002\u000f&\u0019!\u0011\u0005$\u0002\u000fA\f7m[1hK&!!Q\u0005B\u0014\u0005\r\u0019V-\u001d\u0006\u0004\u0005C1\u0005b\u0002B\u00161\u0001\u0007!QF\u0001\tgR\fG/^:fgB)QIa\f\u00034%\u0019!\u0011\u0007$\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u00036\tmRB\u0001B\u001c\u0015\r\u0011I\u0004V\u0001\u0007gR\fG/^:\n\t\tu\"q\u0007\u0002\u000e%\u0016dW-Y:f'R\fG/^:)\u0007a\t\u0019\fK\u0002\u0019\u0003\u0003D3\u0001\u0007B#!\u0011\u00119Ea\u0013\u000e\u0005\t%#bAAd\r&!!Q\nB%\u0005\u001d1\u0018M]1sON\f1CZ5oI\nK8)\u00197f]\u0012\f'\u000fV8lK:$2A\u0015B*\u0011\u001d\u0011)&\u0007a\u0001\u0003C\u000bQbY1mK:$\u0017M\u001d+pW\u0016t\u0007fA\r\u0002B\u0006Ab-\u001b8e\u0003J\u001c\u0007.\u001b<bE2,'+\u001a7fCN,\u0017\nZ:\u0015\r\t]!Q\fB9\u0011\u001d\u0011yF\u0007a\u0001\u0005C\nA\u0001Z1uKB!!1\rB7\u001b\t\u0011)G\u0003\u0003\u0003h\t%\u0014\u0001B;uS2T!Aa\u001b\u0002\t)\fg/Y\u0005\u0005\u0005_\u0012)G\u0001\u0003ECR,\u0007b\u0002B:5\u0001\u0007!QO\u0001\ta\u0006<WmU5{KB\u0019QIa\u001e\n\u0007\tedIA\u0002J]RD3AGAZQ\rQ\u0012\u0011Y\u0001\u000fg\u0016$\bK]3Be\u000eD\u0017N^3e)\u0019\u0011\u0019I!#\u0003\u000eB\u0019QI!\"\n\u0007\t\u001deI\u0001\u0003V]&$\bb\u0002BF7\u0001\u0007\u0011\u0011U\u0001\ne\u0016dW-Y:f\u0013\u0012DqAa$\u001c\u0001\u0004\t9*A\u0006qe\u0016\f%o\u00195jm\u0016$\u0007fA\u000e\u0002B\u0006Ib-\u001b8e!J,\u0017I]2iSZ\f'\r\\3SK2,\u0017m]3t)\u0019\u00119J!'\u0003\u001eB)!\u0011\u0004B\u0012%\"9!1\u0014\u000fA\u0002\tU\u0014\u0001\u00029bO\u0016DqAa\u001d\u001d\u0001\u0004\u0011)\bK\u0002\u001d\u0003gC3\u0001HAa\u0003\u0019\u0019X-\u0019:dQR!!q\u0015BW!\u0015\u0011\u0019G!+S\u0013\u0011\u0011YK!\u001a\u0003\t1K7\u000f\u001e\u0005\b\u0005_k\u0002\u0019\u0001BY\u00031\u0019X-\u0019:dQB\u000b'/Y7t!\rY%1W\u0005\u0004\u0005kS$!\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007NQ=QCJ\fWn\u001d\u0015\u0004;\u0005\u0005\u0017A\u00023fY\u0016$X\r\u0006\u0004\u0003\u0004\nu&q\u0018\u0005\b\u0003?s\u0002\u0019AAQ\u0011%\u0011\tM\bI\u0001\u0002\u0004\t9*\u0001\tdY\u0016\fg.Q2uSZLG/\u001f'pO\"\u001aa$!1\u0002/\u0011,G.\u001a;f%\u0016dW-Y:f%\u00164WM]3oG\u0016\u001cH\u0003\u0003BB\u0005\u0013\u0014YMa4\t\u000f\u0005}u\u00041\u0001\u0002\"\"9!QZ\u0010A\u0002\tU\u0014A\u0003:fY\u0016\f7/Z+jI\"9!\u0011Y\u0010A\u0002\u0005]\u0015!\u00043fY\u0016$XmV5uQVKG\r\u0006\u0004\u0003\u0004\nU'q\u001b\u0005\b\u0003?\u0003\u0003\u0019AAQ\u0011\u001d\u0011i\r\ta\u0001\u0005kB3\u0001IAa\u0003\u0011iwN^3\u0015\r\t\r%q\u001cBr\u0011\u001d\u0011\t/\ta\u0001\u0003C\u000b!b\u001c:jO&t\u0017\r\\%e\u0011\u001d\u0011)/\ta\u0001\u0003C\u000bQA\\3x\u0013\u0012D3!IAa\u0003\u00199W\r^+jIR!!Q^B\u0006!\u0015)%q\u001eBz\u0013\r\u0011\tP\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU8Q\u0001\b\u0005\u0005o\u001c\u0019A\u0004\u0003\u0003z\u000e\u0005a\u0002\u0002B~\u0005\u007ftA!a\u0014\u0003~&\u00111\bP\u0005\u0003siJ!!\u001c\u001d\n\u0007\t\u0005B.\u0003\u0003\u0004\b\r%!!B\"j+&$'b\u0001B\u0011Y\"9\u0011q\u0014\u0012A\u0002\u0005\u0005\u0016!C4fiN#\u0018\r^;t)\u0011\u0011\u0019d!\u0005\t\u000f\u0005}5\u00051\u0001\u0002\"\"\u001a1%!1\u0002\u0017\u001d,Go\u0015;biV\u001cXm\u001d\u000b\u0005\u00073\u0019Y\u0002\u0005\u0004\u0003\u001a\t\r\"1\u0007\u0005\b\u0007;!\u0003\u0019\u0001B\f\u0003\rIGm\u001d\u0015\u0004I\u0005\u0005\u0017!D4fiJK7o[*d_J,7\u000f\u0006\u0003\u0004&\r\u001d\u0002C\u0002B\r\u0005G\u0011)\bC\u0004\u0004\u001e\u0015\u0002\rAa\u0006)\u0007\u0015\n\u0019\fK\u0002&\u0003\u0003\fQb]3u%&\u001c8nU2pe\u0016\u001cH\u0003\u0003BB\u0007c\u0019\u0019da\u000e\t\u000f\t-e\u00051\u0001\u0002\"\"91Q\u0007\u0014A\u0002\tU\u0014!B:d_J,\u0007bBB\u001dM\u0001\u0007!QO\u0001\u000bi>$\u0018\r\\*d_J,\u0007f\u0001\u0014\u0002B\u0006Q\u0011n\u001d+f[Bd\u0017\r^3\u0015\t\u0005]5\u0011\t\u0005\b\u0005\u0017;\u0003\u0019AAQQ\r9\u00131\u0017\u0015\u0004O\u0005\u0005\u0017\u0001C4fiRKG\u000f\\3\u0015\t\u0005\u000561\n\u0005\b\u0003?C\u0003\u0019AAQQ\rA\u00131\u0017\u0015\u0004Q\u0005\u0005\u0017AB;qI\u0006$X\rF\u0002S\u0007+Ba!a7*\u0001\u0004\u0011\u0006fA\u0015\u0002BR)!ka\u0017\u0004`!11Q\f\u0016A\u0002I\u000b\u0001b\u001c:jO&t\u0017\r\u001c\u0005\u0007\u0007CR\u0003\u0019\u0001*\u0002\u000fU\u0004H-\u0019;fI\"\u001a!&!1\u0002\u000fI,\u0007\u000f\\1dKR)!k!\u001b\u0004l!11QL\u0016A\u0002ICaa!\u0019,\u0001\u0004\u0011\u0006fA\u0016\u0002B\u0006Qq-\u001a;BY2$\u0016mZ:\u0015\t\rM4\u0011\u0010\t\u0007\u0005G\u001a)(!)\n\t\r]$Q\r\u0002\u0004'\u0016$\bbBB>Y\u0001\u0007!QO\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fK\u0002-\u0003gC3\u0001LAa\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u0006%\u000e\u00155Q\u0013\u0005\b\u0005\u0017k\u0003\u0019ABD!\u0011\u0019Iia$\u000f\t\t]81R\u0005\u0004\u0007\u001bc\u0017\u0001B\"j\u0013\u0012LAa!%\u0004\u0014\n!1)[%e\u0015\r\u0019i\t\u001c\u0005\b\u0003{l\u0003\u0019AA\u0000\u0003\t\u001a\u0007.Z2l\u0013Ntu\u000e\u001e*fM\u0016\u0014XM\\2fI\nKH)\u001a9f]\u0012,gnY5fgR!!1QBN\u0011\u001d\u0019iJ\fa\u0001\u0007\u000f\u000bq\u0003\u001d7b]&#X-\\%e\u001fJLEo]\"iS2$'/\u001a8\u0002\u001f\u0019Lg\u000eZ*D\u001b\u0012\u000bG/\u0019\"z\u0013\u0012$Baa)\u00042B)QIa<\u0004&B!1qUBW\u001b\t\u0019IK\u0003\u0003\u0004,\n%\u0014\u0001\u00027b]\u001eLAaa,\u0004*\n9\u0011J\u001c;fO\u0016\u0014\bbBAP_\u0001\u0007\u0011\u0011\u0015\u0015\u0004_\u0005M\u0006fA\u0018\u0002B\u0006)b-\u001b8e\u001fZ,'\u000fZ;f%\u0016dW-Y:f\u0013\u0012\u001cHC\u0001B\fQ\r\u0001\u00141\u0017\u0015\u0004a\u0005\u0005\u0017AD4fiJ+G.Z1tK*\u001bxN\u001c\u000b\u0005\u0003C\u001b\u0019\rC\u0004\u0003\fF\u0002\r!!))\u0007E\n\u0019\fK\u00022\u0003\u0003\f1#Y2uSZLG/\u001f'pO\u000ecW-\u00198feN,\"a!4\u0011\r\te!1EBh!\u0011Y5\u0011\u001b*\n\u0007\rM'H\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s\u0003]\t7\r^5wSRLHj\\4DY\u0016\fg.\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0003\u0004\u000ee\u0007\"CBng\u0005\u0005\t\u0019ABg\u0003\rAH%M\u0001\u0015C\u000e$\u0018N^5us2{wm\u00117fC:,'o\u001d\u0011\u00025I,w-[:uKJ\f5\r^5wSRLHj\\4DY\u0016\fg.\u001a:\u0015\t\t\r51\u001d\u0005\b\u0007K,\u0004\u0019ABh\u0003\u001d\u0019G.Z1oKJ\f\u0011c\u00197fC:\f5\r^5wSRLHj\\4t)\u0011\u0011\u0019ia;\t\u000f\r5h\u00071\u0001\u0002\"\u0006!1-[%eQ\r\u00011\u0011\u001f\t\u0005\u0003k\u001b\u00190\u0003\u0003\u0004v\u0006]&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> activityLogCleaners;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public boolean delete$default$2() {
        return ReleaseRepository.delete$default$2$((ReleaseRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id, boolean cleanActivityLog) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid, cleanActivityLog);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid, boolean cleanActivityLog) {
        block0: {
            this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
            scala.collection.immutable.Seq<Integer> taskCiUids = this.taskPersistence().findTaskCiUidsByReleaseCiUid(Predef$.MODULE$.int2Integer(releaseUid));
            this.dependencyPersistence().deleteByTaskUids(taskCiUids);
            this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid), taskCiUids);
            this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
            this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
            this.releaseExtensionsRepository().deleteAll(id);
            this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
            this.interceptDelete(id);
            if (!cleanActivityLog) break block0;
            this.cleanActivityLogs(id);
        }
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid, true);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    public Option<Integer> getUid(String id) {
        return this.releasePersistence.findUidByReleaseId(id);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> activityLogCleaners() {
        return this.activityLogCleaners;
    }

    public void activityLogCleaners_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.activityLogCleaners = x$1;
    }

    public void registerActivityLogCleaner(PersistenceInterceptor<Release> cleaner) {
        PersistenceInterceptor<Release> persistenceInterceptor = cleaner;
        this.activityLogCleaners_$eq((scala.collection.immutable.Seq<PersistenceInterceptor<Release>>)((scala.collection.immutable.Seq)this.activityLogCleaners().$plus$colon(persistenceInterceptor)));
    }

    private void cleanActivityLogs(String ciId) {
        this.activityLogCleaners().foreach((Function1 & Serializable)x$9 -> {
            x$9.onDelete(ciId);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
        this.activityLogCleaners = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }
}

