/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.xlplatform.documentation.PublicApi;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/security/role")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@PublicApi
public interface RoleService {
    @GET
    @Path(value="exists/{name}")
    public boolean exists(@PathParam(value="name") String var1);

    @GET
    @Path(value="v2/{id:.+}")
    public List<Role> list(@PathParam(value="id") String var1, @QueryParam(value="rolePattern") String var2, @BeanParam Paging var3, @QueryParam(value="order") Ordering var4);

    @GET
    @Path(value="v2")
    public List<String> list(@QueryParam(value="rolePattern") String var1, @BeanParam Paging var2, @QueryParam(value="order") Ordering var3);

    @GET
    default public List<String> list() {
        return this.list(null, null, null);
    }

    @GET
    @Path(value="v2/roles")
    public List<String> listMyRoles(@QueryParam(value="rolePattern") String var1, @BeanParam Paging var2, @QueryParam(value="order") Ordering var3);

    @GET
    @Path(value="roles")
    default public List<String> listMyRoles() {
        return this.listMyRoles(null, null, null);
    }

    @GET
    @Path(value="v2/roles/{username}")
    public List<String> listRoles(@PathParam(value="username") String var1, @QueryParam(value="rolePattern") String var2, @BeanParam Paging var3, @QueryParam(value="order") Ordering var4);

    @GET
    @Path(value="roles/{username}")
    default public List<String> listRoles(@PathParam(value="username") String username) {
        return this.listRoles(username, null, null, null);
    }

    @PUT
    @Path(value="{role}")
    public void create(@PathParam(value="role") String var1);

    @POST
    @Path(value="principals")
    public void updatePrincipals(RolePrincipals var1);

    @POST
    @Path(value="{role}/principals")
    public void updatePrincipals(@PathParam(value="role") String var1, List<String> var2);

    @PUT
    @Path(value="{role}/{principal}")
    public void assign(@PathParam(value="role") String var1, @PathParam(value="principal") String var2);

    @DELETE
    @Path(value="{role}/{principal}")
    public void unassign(@PathParam(value="role") String var1, @PathParam(value="principal") String var2);

    @POST
    @Path(value="{role}")
    public void rename(@PathParam(value="role") String var1, String var2);

    @DELETE
    @Path(value="{role}")
    public void delete(@PathParam(value="role") String var1);

    @GET
    @Path(value="v2/principals")
    public List<RolePrincipals> readRolePrincipals(@QueryParam(value="rolePattern") String var1, @BeanParam Paging var2, @QueryParam(value="order") Ordering var3);

    @GET
    @Path(value="principals")
    default public List<RolePrincipals> readRolePrincipals() {
        return this.readRolePrincipals(null, null, null);
    }
}

