/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.util.Dumpable;
import com.dropbox.core.util.StringUtil;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class DumpWriter {
    public abstract DumpWriter recordStart(String var1);

    public abstract DumpWriter recordEnd();

    public abstract DumpWriter fieldStart(String var1);

    public abstract DumpWriter listStart();

    public abstract DumpWriter listEnd();

    public abstract DumpWriter verbatim(String var1);

    public DumpWriter fieldVerbatim(String name, String s) {
        return this.fieldStart(name).verbatim(s);
    }

    public DumpWriter field(String name, String v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter field(String name, int v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter field(String name, long v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter field(String name, boolean v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter field(String name, Date v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter field(String name, Dumpable v) {
        return this.fieldStart(name).value(v);
    }

    public DumpWriter list(Iterable<? extends Dumpable> list) {
        if (list == null) {
            this.verbatim("null");
        } else {
            this.listStart();
            this.values(list);
            this.listEnd();
        }
        return this;
    }

    public DumpWriter value(String v) {
        if (v == null) {
            this.verbatim("null");
        } else {
            this.verbatim(StringUtil.jq(v));
        }
        return this;
    }

    public DumpWriter value(int v) {
        return this.verbatim(Integer.toString(v));
    }

    public DumpWriter value(long v) {
        return this.verbatim(Long.toString(v));
    }

    public DumpWriter value(boolean v) {
        return this.verbatim(Boolean.toString(v));
    }

    public DumpWriter value(Date v) {
        return this.verbatim(DumpWriter.toStringDate(v));
    }

    public DumpWriter value(Dumpable v) {
        if (v == null) {
            this.verbatim("null");
        } else {
            this.recordStart(v.getTypeName());
            v.dumpFields(this);
            this.recordEnd();
        }
        return this;
    }

    public DumpWriter values(Iterable<? extends Dumpable> list) {
        for (Dumpable dumpable : list) {
            this.value(dumpable);
        }
        return this;
    }

    public static String toStringDate(Date date) {
        if (date == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        GregorianCalendar c = new GregorianCalendar(JsonDateReader.UTC);
        c.setTime(date);
        String year = Integer.toString(c.get(1));
        String month = DumpWriter.zeroPad(Integer.toString(c.get(2) + 1), 2);
        String day = DumpWriter.zeroPad(Integer.toString(c.get(5)), 2);
        String hour = DumpWriter.zeroPad(Integer.toString(c.get(11)), 2);
        String minute = DumpWriter.zeroPad(Integer.toString(c.get(12)), 2);
        String second = DumpWriter.zeroPad(Integer.toString(c.get(13)), 2);
        buf.append('\"');
        buf.append(year).append("/").append(month).append("/").append(day).append(" ");
        buf.append(hour).append(":").append(minute).append(":").append(second).append(" UTC");
        buf.append('\"');
        return buf.toString();
    }

    private static String zeroPad(String v, int desiredLength) {
        while (v.length() < desiredLength) {
            v = "0" + v;
        }
        return v;
    }

    public static final class Plain
    extends DumpWriter {
        private StringBuilder buf;
        private boolean needSep = false;

        public Plain(StringBuilder buf) {
            this.buf = buf;
        }

        private void sep() {
            if (this.needSep) {
                this.buf.append(", ");
            } else {
                this.needSep = true;
            }
        }

        @Override
        public DumpWriter recordStart(String name) {
            if (name != null) {
                this.buf.append(name);
            }
            this.buf.append("(");
            this.needSep = false;
            return this;
        }

        @Override
        public DumpWriter recordEnd() {
            this.buf.append(")");
            this.needSep = true;
            return this;
        }

        @Override
        public DumpWriter fieldStart(String name) {
            this.sep();
            this.buf.append(name).append('=');
            this.needSep = false;
            return this;
        }

        @Override
        public DumpWriter listStart() {
            this.sep();
            this.buf.append("[");
            this.needSep = false;
            return this;
        }

        @Override
        public DumpWriter listEnd() {
            this.buf.append("]");
            this.needSep = true;
            return this;
        }

        @Override
        public DumpWriter verbatim(String s) {
            this.sep();
            this.buf.append(s);
            return this;
        }
    }

    public static final class Multiline
    extends DumpWriter {
        private final StringBuilder buf;
        private final int indentAmount;
        private int currentIndent;
        boolean nl = true;

        public Multiline(StringBuilder buf, int indentAmount, int currentIndent, boolean nl) {
            if (buf == null) {
                throw new IllegalArgumentException("'buf' must not be null");
            }
            if (indentAmount < 0) {
                throw new IllegalArgumentException("'indentAmount' must be non-negative");
            }
            if (currentIndent < 0) {
                throw new IllegalArgumentException("'currentIndent' must be non-negative");
            }
            this.buf = buf;
            this.indentAmount = indentAmount;
            this.currentIndent = currentIndent;
            this.nl = nl;
        }

        public Multiline(StringBuilder buf, int indentAmount, boolean nl) {
            this(buf, indentAmount, 0, nl);
        }

        private void prefix() {
            if (this.nl) {
                int l = this.currentIndent;
                for (int i = 0; i < l; ++i) {
                    this.buf.append(' ');
                }
            }
        }

        private void indentMore() {
            this.currentIndent += this.indentAmount;
        }

        private void indentLess() {
            if (this.indentAmount > this.currentIndent) {
                throw new IllegalStateException("indent went negative");
            }
            this.currentIndent -= this.indentAmount;
        }

        @Override
        public DumpWriter recordStart(String name) {
            this.prefix();
            if (name != null) {
                this.buf.append(name).append(" ");
            }
            this.buf.append("{\n");
            this.nl = true;
            this.indentMore();
            return this;
        }

        @Override
        public DumpWriter recordEnd() {
            if (!this.nl) {
                throw new AssertionError((Object)"called recordEnd() in a bad state");
            }
            this.indentLess();
            this.prefix();
            this.buf.append("}\n");
            this.nl = true;
            return this;
        }

        @Override
        public DumpWriter fieldStart(String name) {
            if (!this.nl) {
                throw new AssertionError((Object)"called fieldStart() in a bad state");
            }
            this.prefix();
            this.buf.append(name).append(" = ");
            this.nl = false;
            return this;
        }

        @Override
        public DumpWriter listStart() {
            this.prefix();
            this.buf.append("[\n");
            this.nl = true;
            this.indentMore();
            return this;
        }

        @Override
        public DumpWriter listEnd() {
            if (!this.nl) {
                throw new AssertionError((Object)"called listEnd() in a bad state");
            }
            this.indentLess();
            this.prefix();
            this.buf.append("]\n");
            this.nl = true;
            return this;
        }

        @Override
        public DumpWriter verbatim(String s) {
            this.prefix();
            this.buf.append(s);
            this.buf.append('\n');
            this.nl = true;
            return this;
        }
    }
}

