/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.List;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

public abstract class Expression {
    public static final int MAP_INITIAL = 0;
    public static final int MAP_IN_WINDOW = 1;
    public static final int MAP_IN_AGGREGATE = 2;
    private boolean addedToFilter;

    public static void writeExpressions(StringBuilder stringBuilder, List<? extends Expression> list, boolean bl) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            list.get(i).getSQL(stringBuilder, bl);
        }
    }

    public static void writeExpressions(StringBuilder stringBuilder, Expression[] expressionArray, boolean bl) {
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            Expression expression;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if ((expression = expressionArray[i]) == null) {
                stringBuilder.append("DEFAULT");
                continue;
            }
            expression.getSQL(stringBuilder, bl);
        }
    }

    public abstract Value getValue(Session var1);

    public abstract TypeInfo getType();

    public abstract void mapColumns(ColumnResolver var1, int var2, int var3);

    public abstract Expression optimize(Session var1);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public String getSQL(boolean bl) {
        return this.getSQL(new StringBuilder(), bl).toString();
    }

    public abstract StringBuilder getSQL(StringBuilder var1, boolean var2);

    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, boolean bl) {
        int n = stringBuilder.length();
        int n2 = this.getSQL(stringBuilder, bl).length() - 1;
        if (n2 > n && stringBuilder.charAt(n) == '(' && stringBuilder.charAt(n2) == ')') {
            stringBuilder.setLength(n2);
            stringBuilder.deleteCharAt(n);
        }
        return stringBuilder;
    }

    public abstract void updateAggregate(Session var1, int var2);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public Expression getNotIfPossible(Session session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isNullConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean getBooleanValue(Session session) {
        return this.getValue(session).getBoolean();
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias() {
        return this.getUnenclosedSQL(new StringBuilder(), false).toString();
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter tableFilter) {
        if (!this.addedToFilter && this.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
            tableFilter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }

    public String toString() {
        return this.getSQL(false);
    }

    public Expression[] getExpressionColumns(Session session) {
        return null;
    }

    protected static Expression[] getExpressionColumns(Session session, ValueCollectionBase valueCollectionBase) {
        Value[] valueArray = valueCollectionBase.getList();
        Expression[] expressionArray = new ExpressionColumn[valueArray.length];
        int n = valueArray.length;
        for (int i = 0; i < n; ++i) {
            Value value = valueArray[i];
            Column column = new Column("C" + (i + 1), value.getType());
            expressionArray[i] = new ExpressionColumn(session.getDatabase(), column);
        }
        return expressionArray;
    }

    public static Expression[] getExpressionColumns(Session session, ResultInterface resultInterface) {
        int n = resultInterface.getVisibleColumnCount();
        Expression[] expressionArray = new Expression[n];
        Database database = session == null ? null : session.getDatabase();
        for (int i = 0; i < n; ++i) {
            String string = resultInterface.getColumnName(i);
            TypeInfo typeInfo = resultInterface.getColumnType(i);
            Column column = new Column(string, typeInfo);
            ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
            expressionArray[i] = expressionColumn;
        }
        return expressionArray;
    }

    public int getSubexpressionCount() {
        return 0;
    }

    public Expression getSubexpression(int n) {
        throw new IndexOutOfBoundsException();
    }
}

