/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.CreationService;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.FolderSearch$;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.service.SearchScope;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter$;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.scm.connector.Repository;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.data.GitTag;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\t5d\u0001\u0002\u0010 \u00011B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")Q\u000e\u0001C\u0001]\"I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0018!Q\u0011\u0011\u0007\u0001\t\u0006\u0004%\t!a\r\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003@\u0001!IA!\u0011\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!q\u000b\u0001\u0005\n\te#a\u0006$pY\u0012,'OV3sg&|g.\u001b8h'\u0016\u0014h/[2f\u0015\t\u0001\u0013%A\u0002tG6T!AI\u0012\u0002\r\u0005\u001c8m\u001c3f\u0015\t!S%\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT!AJ\u0014\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0015*\u0003%AXMY5bY\u0006\u00147OC\u0001+\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qf\r\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014!B:mMRR'\"\u0001\u001d\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AO\u001b\u0003\u000f1{wmZ5oO\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\ti\u0004)D\u0001?\u0015\tyT%A\u0004tKJ4\u0018nY3\n\u0005\u0005s$AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\fqbZ3oKJ\fG/Z*feZL7-\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\u007f\u0019S!AI\u0013\n\u0005!+%aD$f]\u0016\u0014\u0018\r^3TKJ4\u0018nY3\u0002\u001f\r\u0014X-\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"\u0001R&\n\u00051+%aD\"sK\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\u001f\u0011,g-\u001b8ji&|g\u000eU1sg\u0016\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\rA\f'o]3s\u0015\t\u0019f)\u0001\u0003zC6d\u0017BA+Q\u0005MAFJ\u0015#fM&t\u0017\u000e^5p]B\u000b'o]3s\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002Y76\t\u0011L\u0003\u0002[K\u0005Q!/\u001a9pg&$xN]=\n\u0005qK&aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003q\u0019wN\u001c4jOV\u0014\u0018\r^5p]Z\u000b'/[1cY\u0016\u001cVM\u001d<jG\u0016\u0004\"!P0\n\u0005\u0001t$\u0001H\"p]\u001aLw-\u001e:bi&|gNV1sS\u0006\u0014G.Z*feZL7-Z\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005u\u001a\u0017B\u00013?\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\u0006\u0019bm\u001c7eKJ\f5oQ8eKN+'O^5dKB\u0011AiZ\u0005\u0003Q\u0016\u00131CR8mI\u0016\u0014\u0018i]\"pI\u0016\u001cVM\u001d<jG\u0016\f1bY5JIN+'O^5dKB\u0011Qh[\u0005\u0003Yz\u00121bQ5JIN+'O^5dK\u00061A(\u001b8jiz\"\"b\\9sgR,ho\u001e=z!\t\u0001\b!D\u0001 \u0011\u0015Y$\u00021\u0001=\u0011\u0015\u0011%\u00021\u0001D\u0011\u0015I%\u00021\u0001K\u0011\u0015i%\u00021\u0001O\u0011\u00151&\u00021\u0001X\u0011\u0015i&\u00021\u0001_\u0011\u0015\t'\u00021\u0001c\u0011\u0015)'\u00021\u0001g\u0011\u0015I'\u00021\u0001kQ\tQ1\u0010E\u0002}\u0003\u001fi\u0011! \u0006\u0003}~\f!\"\u00198o_R\fG/[8o\u0015\u0011\t\t!a\u0001\u0002\u000f\u0019\f7\r^8ss*!\u0011QAA\u0004\u0003\u0015\u0011W-\u00198t\u0015\u0011\tI!a\u0003\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0004\u0002\u0007=\u0014x-C\u0002\u0002\u0012u\u0014\u0011\"Q;u_^L'/\u001a3\u0002\r\rLG+\u001f9f+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005-RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000fI,g\r\\3di*!\u0011\u0011EA\u0012\u0003\r\t\u0007/\u001b\u0006\u0005\u0003K\t9#\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0003S9\u0013\u0001\u00033fa2|\u00170\u001b;\n\t\u00055\u00121\u0004\u0002\u0005)f\u0004X-A\u0004dSRK\b/\u001a\u0011\u0002\u001d]\u0014\u0018\r]#yG\u0016\u0004H/[8ogV\u0011\u0011Q\u0007\t\u0007\u0003o\t9&!\u0018\u000f\t\u0005e\u0012\u0011\u000b\b\u0005\u0003w\tYE\u0004\u0003\u0002>\u0005\u001dc\u0002BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r3&\u0001\u0004=e>|GOP\u0005\u0002a%\u0019\u0011\u0011J\u0018\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001b\ny%A\u0004d_:$(o\u001c7\u000b\u0007\u0005%s&\u0003\u0003\u0002T\u0005U\u0013!C#yG\u0016\u0004H/[8o\u0015\u0011\ti%a\u0014\n\t\u0005e\u00131\f\u0002\u0006\u0007\u0006$8\r\u001b\u0006\u0005\u0003'\n)\u0006E\u0002/\u0003?J1!!\u00190\u0005\u001dqu\u000e\u001e5j]\u001e\fABZ5oIN+G\u000f^5oON$B!a\u001a\u0002~A)a&!\u001b\u0002n%\u0019\u00111N\u0018\u0003\r=\u0003H/[8o!\u0011\ty'!\u001f\u000e\u0005\u0005E$b\u0001\u0012\u0002t)\u0019A%!\u001e\u000b\u0007\u0005]T%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003w\n\tH\u0001\rG_2$WM\u001d,feNLwN\\5oON+G\u000f^5oONDq!a \u000f\u0001\u0004\t\t)\u0001\u0005g_2$WM]%e!\u0011\t\u0019)a#\u000f\t\u0005\u0015\u0015q\u0011\t\u0004\u0003\u007fy\u0013bAAE_\u00051\u0001K]3eK\u001aLA!!$\u0002\u0010\n11\u000b\u001e:j]\u001eT1!!#0\u0003-9W\r^*fiRLgnZ:\u0015\t\u00055\u0014Q\u0013\u0005\b\u0003\u007fz\u0001\u0019AAA\u0003Y\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BA7\u00037Cq!!(\u0011\u0001\u0004\ti'A\u0005oK^\u001cuN\u001c4jO\u0006qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BAR\u0003S\u00032ALAS\u0013\r\t9k\f\u0002\u0005+:LG\u000fC\u0004\u0002\u0000E\u0001\r!!!\u0002\u0017\u001d,GOV3sg&|gn\u001d\u000b\u0005\u0003_\u000by\u000eE\u0004/\u0003c\u000b),a1\n\u0007\u0005MvF\u0001\u0004UkBdWM\r\t\u0005\u0003o\u000by,\u0004\u0002\u0002:*!\u0011\u0011JA^\u0015\t\ti,\u0001\u0003kCZ\f\u0017\u0002BAa\u0003s\u0013A\u0001R1uKB1\u0011QYAf\u0003#tA!!\u0010\u0002H&\u0019\u0011\u0011Z\u0018\u0002\u000fA\f7m[1hK&!\u0011QZAh\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0013|\u0003\u0003BAj\u00037l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\u0005I\u0006$\u0018M\u0003\u0002!K%!\u0011Q\\Ak\u0005-1VM]:j_:LeNZ8\t\u000f\u0005}$\u00031\u0001\u0002\u0002\u0006aa-\u001a;dQ\u000eC\u0017M\\4fgR!\u0011qVAs\u0011\u001d\tyh\u0005a\u0001\u0003\u0003\u000bQb\u0019:fCR,g+\u001a:tS>tG\u0003CAi\u0003W\fi/!=\t\u000f\u0005}D\u00031\u0001\u0002\u0002\"9\u0011q\u001e\u000bA\u0002\u0005\u0005\u0015a\u0002<feNLwN\u001c\u0005\b\u0003g$\u0002\u0019AAA\u0003-!Wm]2sSB$\u0018n\u001c8\u0002\u0019\u0005\u0004\b\u000f\\=WKJ\u001c\u0018n\u001c8\u0015\r\u0005\r\u0016\u0011`A~\u0011\u001d\ty(\u0006a\u0001\u0003\u0003Cq!a<\u0016\u0001\u0004\t\t)A\bhK:,'/\u0019;f!J,g/[3x)\u0019\t\tI!\u0001\u0003\u0004!9\u0011q\u0010\fA\u0002\u0005\u0005\u0005bBAx-\u0001\u0007!Q\u0001\t\u0006]\u0005%\u0014\u0011Q\u0001\u000fO\u0016tWM]1uK\u001a{G\u000eZ3s)!\u0011YAa\u0006\u0003\u001a\tu\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\t\tE\u0011\u0011\\\u0001\nG>tg.Z2u_JLAA!\u0006\u0003\u0010\tA1kY7CY>\u00147\u000fC\u0004\u0002\u0000]\u0001\r!!!\t\u000f\tmq\u00031\u0001\u0002n\u000511m\u001c8gS\u001eDqAa\b\u0018\u0001\u0004\t\t)\u0001\u0005gS2,\u0007+\u0019;i\u00035Ig.\u001b;D_:tWm\u0019;peR!!Q\u0005B\u0018!\u0011\u00119Ca\u000b\u000e\u0005\t%\"b\u0001B\t?%!!Q\u0006B\u0015\u0005M\t5oQ8eK*;\u0015\u000e^\"p]:,7\r^8s\u0011\u001d\u0011Y\u0002\u0007a\u0001\u0003[\n\u0001C^1mS\u0012\fG/Z*fiRLgnZ:\u0015\t\u0005\r&Q\u0007\u0005\b\u00057I\u0002\u0019AA7\u0003U1\u0018\r\\5eCR,7\u000b]3dS\u001aL7-\u0019;j_:$B!a)\u0003<!9!Q\b\u000eA\u0002\u0005\u0005\u0015\u0001B:qK\u000e\f1\"\\3uC\u0012\fG/Y'baR!!1\tB&!\u0015q\u0013\u0011\u000eB#!!\t\u0019Ia\u0012\u0002\u0002\u0006\u0005\u0015\u0002\u0002B%\u0003\u001f\u00131!T1q\u0011\u001d\tyh\u0007a\u0001\u0003\u0003\u000bA\"\u001a=ue\u0006\u001cGo\u00159fGN$BA!\u0015\u0003TA1\u0011QYAf\u0003\u0003CqA!\u0016\u001d\u0001\u0004\u0011Y!A\u0003cY>\u00147/A\u0007nCJ\\\u0017i]!qa2LW\r\u001a\u000b\u0007\u0003G\u0013YF!\u0018\t\u000f\u0005=X\u00041\u0001\u0002\u0002\"9!1D\u000fA\u0002\u00055\u0004f\u0001\u0001\u0003bA!!1\rB5\u001b\t\u0011)G\u0003\u0003\u0003h\u0005\u001d\u0011AC:uKJ,w\u000e^=qK&!!1\u000eB3\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FolderVersioningService
implements Logging {
    private Exception.Catch<Nothing$> wrapExceptions;
    private final UserProfileService userProfileService;
    private final GenerateService generateService;
    private final CreationService creationService;
    private final XLRDefinitionParser definitionParse;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationVariableService configurationVariableService;
    private final ConfigurationService configurationService;
    private final FolderAsCodeService folderAsCodeService;
    private final CiIdService ciIdService;
    private final Type ciType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Type ciType() {
        return this.ciType;
    }

    private Exception.Catch<Nothing$> wrapExceptions$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$0) {
                this.wrapExceptions = Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{AsCodeException.class, GitAPIException.class, JGitInternalException.class})).withApply((Function1 & Serializable)e -> {
                    throw new ScmException(new StringBuilder(44).append("Error performing version control operation: ").append(e.getMessage()).toString(), e.getCause(), ScmException$.MODULE$.apply$default$3());
                });
                this.bitmap$0 = true;
            }
        }
        return this.wrapExceptions;
    }

    public Exception.Catch<Nothing$> wrapExceptions() {
        return !this.bitmap$0 ? this.wrapExceptions$lzycompute() : this.wrapExceptions;
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return (Option)this.wrapExceptions().apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala($this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption());
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)this.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            void var3_6;
            FolderVersioningSettings folderVersioningSettings;
            this.validateSettings(newConfig);
            Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)((Object)some.value()));
                existingConfig.updateWith(newConfig);
                folderVersioningSettings = existingConfig;
            } else if (None$.MODULE$.equals(option)) {
                newConfig.setId($this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
                folderVersioningSettings = newConfig;
            } else {
                throw new MatchError(option);
            }
            FolderVersioningSettings config = folderVersioningSettings;
            $this.configurationService.createOrUpdate((BaseConfiguration)config);
            return var3_6;
        }));
    }

    public void deleteSettings(String folderId) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<FolderVersioningSettings> option = this.findSettings(folderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings config = (FolderVersioningSettings)((Object)((Object)some.value()));
                $this.configurationRepository.delete(config.getId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> getVersions(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.listVersions();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$1 -> x$1.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> fetchChanges(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.pullAndListVersions();
            config.lastFetched_$eq(new Date());
            $this.configurationRepository.update((BaseConfiguration)config);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$2 -> x$2.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public VersionInfo createVersion(String folderId, String version, String description) {
        return (VersionInfo)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            ScmBlobs blobs = this.generateFolder(folderId, config, filePath);
            GitTag tag = new GitTag((String)FolderVersioningSettings$.MODULE$.generateTagName(config.getEffectiveTagPrefix(), version, FolderVersioningSettings$.MODULE$.generateTagName$default$3()).get());
            ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, tag).get();
            UserProfile userProfile = $this.userProfileService.findByUsername(Permissions.getAuthenticatedUserName());
            scmConnector.createNewVersion(blobs, commitInfo, userProfile).get();
            VersionInfo versionInfo = scmConnector.getVersion(commitInfo.tag().refName());
            this.markAsApplied(versionInfo.name(), config);
            return versionInfo;
        });
    }

    public void applyVersion(String folderId, String version) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            ScmBlobs blobs = (ScmBlobs)scmConnector.checkout(filePath, version, scmConnector.checkout$default$3()).get();
            Seq<String> specs = this.extractSpecs(blobs);
            specs.foreach((Function1 & Serializable)spec -> {
                this.validateSpecification((String)spec);
                Definition definition = $this.definitionParse.parse(spec);
                Definition updatedDefinition = new Definition(definition.apiVersion(), this.metadataMap(folderId), definition.kind(), definition.spec());
                return $this.creationService.processBlueprint(updatedDefinition, $this.creationService.processBlueprint$default$2());
            });
            this.markAsApplied(version, config);
        });
    }

    public String generatePreview(String folderId, Option<String> version) {
        return (String)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            ScmBlobs scmBlobs;
            FolderVersioningSettings config = this.getSettings(folderId);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                AsCodeJGitConnector scmConnector = this.initConnector(config);
                scmBlobs = (ScmBlobs)scmConnector.checkout(filePath, ver, false).get();
            } else if (None$.MODULE$.equals(option)) {
                scmBlobs = this.generateFolder(folderId, config, filePath);
            } else {
                throw new MatchError((Object)option);
            }
            ScmBlobs blobs = scmBlobs;
            return new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    private ScmBlobs generateFolder(String folderId, FolderVersioningSettings config, String filePath) {
        ScmBlobs scmBlobs;
        boolean x$1 = config.exportConfiguration();
        boolean x$2 = config.exportDashboards();
        boolean x$3 = config.exportTemplates();
        boolean x$4 = config.exportTriggers();
        boolean x$5 = config.exportVariables();
        boolean x$6 = config.exportPatterns();
        boolean x$7 = config.exportNotifications();
        boolean x$8 = config.exportSecurity();
        boolean x$9 = GenerateService.CisConfig$.MODULE$.apply$default$2();
        boolean x$10 = GenerateService.CisConfig$.MODULE$.apply$default$3();
        boolean x$11 = GenerateService.CisConfig$.MODULE$.apply$default$4();
        boolean x$12 = GenerateService.CisConfig$.MODULE$.apply$default$5();
        boolean x$13 = GenerateService.CisConfig$.MODULE$.apply$default$6();
        boolean x$14 = GenerateService.CisConfig$.MODULE$.apply$default$12();
        boolean x$15 = GenerateService.CisConfig$.MODULE$.apply$default$13();
        boolean x$16 = GenerateService.CisConfig$.MODULE$.apply$default$16();
        GenerateService.CisConfig cisConfig = new GenerateService.CisConfig(x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$4, x$6, x$2, x$1, x$14, x$15, x$5, x$7, x$16);
        try {
            FolderSearch scope = FolderSearch$.MODULE$.apply(this.folderAsCodeService.getFolderPath(folderId), folderId, true);
            List definitions = this.generateService.generate(new GenerateService.GeneratorConfig((Option)None$.MODULE$, (SearchScope)scope, cisConfig, GenerateService.GeneratorConfig$.MODULE$.apply$default$4()));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XLRDefinitionWriter qual$1 = XLRDefinitionWriter$.MODULE$.apply();
            ByteArrayOutputStream x$17 = stream;
            DefinitionWriter.WriterConfig x$18 = new DefinitionWriter.WriterConfig(definitions, false, false);
            boolean x$19 = qual$1.writeYaml$default$3();
            qual$1.writeYaml((OutputStream)x$17, x$18, x$19);
            scmBlobs = new ScmBlobs((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryFile[]{new BinaryFile(filePath, (Function0 & Serializable)() -> stream.toByteArray())})));
        }
        catch (AsCodeException e) {
            throw new ScmException(e.getMessage(), e.getCause(), ScmException$.MODULE$.apply$default$3());
        }
        return scmBlobs;
    }

    public AsCodeJGitConnector initConnector(FolderVersioningSettings config) {
        Repository connectorConfig = config.gitConnection();
        this.configurationVariableService.resolve((Configuration)connectorConfig);
        return new AsCodeJGitConnector(config);
    }

    private void validateSettings(FolderVersioningSettings config) {
        block0: {
            AsCodeJGitConnector connector = this.initConnector(config);
            String url = connector.getConnectionSettings().getUrl();
            if (JGitConnector$.MODULE$.isFileRepo(url)) break block0;
            JGitConnector$.MODULE$.verifyRepositoryPath(url);
            JGitConnector$.MODULE$.verifyRemoteBranch(url, config.branch());
        }
    }

    private void validateSpecification(String spec) {
        Regex taggedValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":\\s*!value\\b"));
        if (taggedValueRegex.findFirstMatchIn((CharSequence)spec).isDefined()) {
            throw new ScmException("Unable to apply: '!value' tags in passwords not supported. Use variables for passwords", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    private Option<Map<String, String>> metadataMap(String folderId) {
        return new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.FOLDER().toString()), (Object)folderId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString()), (Object)this.folderAsCodeService.getFolderPath(folderId))})));
    }

    private Seq<String> extractSpecs(ScmBlobs blobs) {
        Regex SPEC_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\Rspec:"));
        String content = new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\\R---")), (Function1 & Serializable)x$3 -> x$3.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$extractSpecs$2(SPEC_REGEX, spec)))));
    }

    private void markAsApplied(String version, FolderVersioningSettings config) {
        Date now = new Date();
        config.lastFetched_$eq(now);
        config.appliedVersion_$eq(version);
        config.appliedDate_$eq(now);
        config.appliedBy_$eq(Permissions.getAuthenticatedUserName());
        this.configurationRepository.update((BaseConfiguration)config);
    }

    public static final /* synthetic */ boolean $anonfun$extractSpecs$2(Regex SPEC_REGEX$1, String spec) {
        return !spec.isBlank() && SPEC_REGEX$1.findFirstIn((CharSequence)spec).isDefined();
    }

    @Autowired
    public FolderVersioningService(UserProfileService userProfileService, GenerateService generateService, CreationService creationService, XLRDefinitionParser definitionParse, ConfigurationRepository configurationRepository, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, FolderAsCodeService folderAsCodeService, CiIdService ciIdService) {
        this.userProfileService = userProfileService;
        this.generateService = generateService;
        this.creationService = creationService;
        this.definitionParse = definitionParse;
        this.configurationRepository = configurationRepository;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.folderAsCodeService = folderAsCodeService;
        this.ciIdService = ciIdService;
        Logging.$init$((Logging)this);
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

