/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\r%q!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006B\u00026\u0002\t\u0003\u0011\u0019\u0010C\u0004\u0003v\u0006!\tEa=\t\u000f\t]\u0018\u0001\"\u0011\u0003z\"9!Q`\u0001\u0005B\t}h\u0001\u0002*F\u0001\tD\u0001B\u001a\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0006U\u001a!\ta\u001b\u0005\b[\u001a\u0011\r\u0011\"\u0003o\u0011\u0019)h\u0001)A\u0005_\")aO\u0002C\u0001o\"9\u0011q\u0001\u0004\u0005\u0012\u0005%\u0001\"CA\u000b\r\t\u0007I\u0011AA\f\u0011!\tyB\u0002Q\u0001\n\u0005e\u0001\"CA\u0011\r\t\u0007I\u0011AA\f\u0011!\t\u0019C\u0002Q\u0001\n\u0005e\u0001\"CA\u0013\r\t\u0007I\u0011AA\u0014\u0011!\tyC\u0002Q\u0001\n\u0005%\u0002\"CA\u0019\r\t\u0007I\u0011AA\u001a\u0011!\t)E\u0002Q\u0001\n\u0005U\u0002\"CA$\r\t\u0007I\u0011AA%\u0011!\t\tG\u0002Q\u0001\n\u0005-\u0003\"CA2\r\t\u0007I\u0011AA3\u0011!\t9H\u0002Q\u0001\n\u0005\u001d\u0004bBA=\r\u0011\u0005\u00111\u0010\u0005\b\u0003\u00073A\u0011AA\u0014\u0011\u001d\t)I\u0002C\u0001\u0003\u000fCq!!#\u0007\t\u0003\t9\u0003C\u0004\u0002\f\u001a!\t!!$\t\u000f\u0005}e\u0001\"\u0001\u0002|!9\u0011\u0011\u0015\u0004\u0005\u0002\u0005\r\u0006\"CAU\rE\u0005I\u0011AAV\u0011\u001d\t\tM\u0002C\u0001\u0003\u0007Dq!a2\u0007\t\u0003\tI\rC\u0004\u0002N\u001a!\t!a\u001f\t\u000f\u0005=g\u0001\"\u0001\u0002R\"9\u0011Q\u001b\u0004\u0005\u0002\u0005]\u0007\"CA~\rE\u0005I\u0011AA\u007f\u0011%\u0011\tABI\u0001\n\u0003\ti\u0010C\u0005\u0003\u0004\u0019\t\n\u0011\"\u0001\u0003\u0006!9!\u0011\u0002\u0004\u0005\u0002\t-\u0001\"\u0003B\u000e\rE\u0005I\u0011AA\u007f\u0011%\u0011iBBI\u0001\n\u0003\ti\u0010C\u0005\u0003 \u0019\t\n\u0011\"\u0001\u0003\u0006!9!\u0011\u0005\u0004\u0005\u0002\t\r\u0002b\u0002B\u0014\r\u0011\u0005!\u0011\u0006\u0005\b\u0005[1A\u0011\u0001B\u0018\u0011%\u0011YDBI\u0001\n\u0003\ti\u0010C\u0005\u0003>\u0019\t\n\u0011\"\u0001\u0002~\"I!q\b\u0004\u0012\u0002\u0013\u0005!Q\u0001\u0005\b\u0005\u00032A\u0011\u0001B\"\u0011%\u0011\u0019FBI\u0001\n\u0003\ti\u0010C\u0005\u0003V\u0019\t\n\u0011\"\u0001\u0002~\"I!q\u000b\u0004\u0012\u0002\u0013\u0005!Q\u0001\u0005\b\u000532A\u0011\u0002B.\u0011\u001d\u0011yF\u0002C\u0001\u0005CBqAa\u0018\u0007\t\u0003\u0011I\u0007C\u0004\u0003`\u0019!\tAa\u001e\t\u000f\t}c\u0001\"\u0001\u0003\u0006\"9!q\f\u0004\u0005\u0002\tE\u0005b\u0002B0\r\u0011\u0005!1\u0014\u0005\b\u0005K3A\u0011\u0002BT\u0011\u001d\u0011\tL\u0002C\t\u0005gCqA!1\u0007\t#\tY\b\u0003\u0006\u0003D\u001aA)\u0019!C\t\u0005\u000bD!Ba5\u0007\u0011\u000b\u0007I\u0011\u0003Bk\u0011)\u0011\u0019O\u0002EC\u0002\u0013E!Q]\u0001\u0019#V\f'\u000f\u001e>TG\",G-\u001e7fe\u0016CH/\u001a8tS>t'B\u0001$H\u0003\u0019\tX/\u0019:uu*\u0011\u0001*S\u0001\nKb$XM\\:j_:T!AS&\u0002\t\u0005\\7.\u0019\u0006\u0003\u00196\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u001d\u0006\u00191m\\7\u0004\u0001A\u0011\u0011+A\u0007\u0002\u000b\nA\u0012+^1sij\u001c6\r[3ek2,'/\u0012=uK:\u001c\u0018n\u001c8\u0014\u000b\u0005!&L!<\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\r\u0005s\u0017PU3g!\rYv,Y\u0007\u00029*\u0011QLX\u0001\u0006C\u000e$xN\u001d\u0006\u0002\u0015&\u0011\u0001\r\u0018\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002R\rM\u0019a\u0001V2\u0011\u0005m#\u0017BA3]\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u00037\"L!!\u001b/\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\tG\u000eC\u0003g\u0011\u0001\u0007q-A\u0002m_\u001e,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003ez\u000bQ!\u001a<f]RL!\u0001^9\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!\u00035\u00198\r[3ek2,'OT1nKV\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m4V\"\u0001?\u000b\u0005u|\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0000-\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a ,\u0002\r\r|gNZ5h+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005EQBAA\b\u0015\r\t9aS\u0005\u0005\u0003'\tyA\u0001\u0004D_:4\u0017nZ\u0001\fi\"\u0014X-\u00193D_VtG/\u0006\u0002\u0002\u001aA\u0019Q+a\u0007\n\u0007\u0005uaKA\u0002J]R\fA\u0002\u001e5sK\u0006$7i\\;oi\u0002\na\u0002\u001e5sK\u0006$\u0007K]5pe&$\u00180A\buQJ,\u0017\r\u001a)sS>\u0014\u0018\u000e^=!\u0003Q!\u0017-Z7p]RC'/Z1eg~#\u0013/\\1sWV\u0011\u0011\u0011\u0006\t\u0004+\u0006-\u0012bAA\u0017-\n9!i\\8mK\u0006t\u0017!\u00063bK6|g\u000e\u00165sK\u0006$7o\u0018\u0013r[\u0006\u00148\u000eI\u0001\u0010I\u00164\u0017-\u001e7u)&lWM_8oKV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006LA!a\u0011\u0002:\tAA+[7f5>tW-\u0001\teK\u001a\fW\u000f\u001c;US6,'p\u001c8fA\u0005I1o\u00195fIVdWm]\u000b\u0003\u0003\u0017\u0002r!!\u0014\u0002Xa\fY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003+2\u0016AC2pY2,7\r^5p]&!\u0011\u0011LA(\u0005\u001d!&/[3NCB\u00042!UA/\u0013\r\ty&\u0012\u0002\u000f#V\f'\u000f\u001e>TG\",G-\u001e7f\u0003)\u00198\r[3ek2,7\u000fI\u0001\feVtg.\u001b8h\u0015>\u00147/\u0006\u0002\u0002hA9\u0011QJA,q\u0006%\u0004\u0003BA6\u0003gj!!!\u001c\u000b\u0007\u0019\u000byG\u0003\u0002\u0002r\u0005\u0019qN]4\n\t\u0005U\u0014Q\u000e\u0002\u0007\u0015>\u00147*Z=\u0002\u0019I,hN\\5oO*{'m\u001d\u0011\u0002\u000fM$\u0018M\u001c3csR\u0011\u0011Q\u0010\t\u0004+\u0006}\u0014bAAA-\n!QK\\5u\u0003=I7/\u00138Ti\u0006tGMY=N_\u0012,\u0017!B:uCJ$HCAA\u0015\u0003%I7o\u0015;beR,G-A\u0006oKb$HK]5hO\u0016\u0014H\u0003BAH\u00037\u0003R!VAI\u0003+K1!a%W\u0005\u0019y\u0005\u000f^5p]B!\u0011qGAL\u0013\u0011\tI*!\u000f\u0003\t\u0011\u000bG/\u001a\u0005\u0007\u0003;k\u0002\u0019\u0001=\u0002\t9\fW.Z\u0001\u000bgV\u001c\b/\u001a8e\u00032d\u0017\u0001C:ikR$wn\u001e8\u0015\t\u0005u\u0014Q\u0015\u0005\n\u0003O{\u0002\u0013!a\u0001\u0003S\tQc^1ji\u001a{'OS8cgR{7i\\7qY\u0016$X-\u0001\ntQV$Hm\\<oI\u0011,g-Y;mi\u0012\nTCAAWU\u0011\tI#a,,\u0005\u0005E\u0006\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a/W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\u000b)LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!b];ta\u0016tGMS8c)\u0011\tI#!2\t\r\u0005u\u0015\u00051\u0001y\u0003%\u0011Xm];nK*{'\r\u0006\u0003\u0002*\u0005-\u0007BBAOE\u0001\u0007\u00010A\u0005sKN,X.Z!mY\u0006I1-\u00198dK2TuN\u0019\u000b\u0005\u0003S\t\u0019\u000e\u0003\u0004\u0002\u001e\u0012\u0002\r\u0001_\u0001\u0012GJ,\u0017\r^3K_\n\u001c6\r[3ek2,G\u0003EAK\u00033\fY.!:\u0002j\u0006=\u00181_A|\u0011\u0019\ti*\na\u0001q\"9\u0011Q\\\u0013A\u0002\u0005}\u0017\u0001\u0003:fG\u0016Lg/\u001a:\u0011\u0007m\u000b\t/C\u0002\u0002dr\u0013\u0001\"Q2u_J\u0014VM\u001a\u0005\u0007\u0003O,\u0003\u0019\u0001+\u0002\u00075\u001cx\rC\u0005\u0002l\u0016\u0002\n\u00111\u0001\u0002n\u0006YA-Z:de&\u0004H/[8o!\u0011)\u0016\u0011\u0013=\t\r\u0005EX\u00051\u0001y\u00039\u0019'o\u001c8FqB\u0014Xm]:j_:D\u0011\"!>&!\u0003\u0005\r!!<\u0002\u0011\r\fG.\u001a8eCJD\u0011\"!?&!\u0003\u0005\r!!\u000e\u0002\u0011QLW.\u001a>p]\u0016\f1d\u0019:fCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u0012\"TCAA\u0000U\u0011\ti/a,\u00027\r\u0014X-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00137\u0003m\u0019'/Z1uK*{'mU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0001\u0016\u0005\u0003k\ty+A\tva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$\u0002#!&\u0003\u000e\t=!\u0011\u0003B\n\u0005+\u00119B!\u0007\t\r\u0005u\u0015\u00061\u0001y\u0011\u001d\ti.\u000ba\u0001\u0003?Da!a:*\u0001\u0004!\u0006\"CAvSA\u0005\t\u0019AAw\u0011\u0019\t\t0\u000ba\u0001q\"I\u0011Q_\u0015\u0011\u0002\u0003\u0007\u0011Q\u001e\u0005\n\u0003sL\u0003\u0013!a\u0001\u0003k\t1$\u001e9eCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u0012\"\u0014aG;qI\u0006$XMS8c'\u000eDW\rZ;mK\u0012\"WMZ1vYR$c'A\u000eva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$HeN\u0001\u0012I\u0016dW\r^3K_\n\u001c6\r[3ek2,G\u0003BA\u0015\u0005KAa!!(.\u0001\u0004A\u0018!D;og\u000eDW\rZ;mK*{'\r\u0006\u0003\u0002*\t-\u0002BBAO]\u0001\u0007\u00010\u0001\bde\u0016\fG/Z*dQ\u0016$W\u000f\\3\u0015\u0019\u0005u$\u0011\u0007B\u001a\u0005k\u00119D!\u000f\t\r\u0005uu\u00061\u0001y\u0011%\tYo\fI\u0001\u0002\u0004\ti\u000f\u0003\u0004\u0002r>\u0002\r\u0001\u001f\u0005\n\u0003k|\u0003\u0013!a\u0001\u0003[D\u0011\"!?0!\u0003\u0005\r!!\u000e\u00021\r\u0014X-\u0019;f'\u000eDW\rZ;mK\u0012\"WMZ1vYR$#'\u0001\rde\u0016\fG/Z*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIQ\n\u0001d\u0019:fCR,7k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0011Xm]2iK\u0012,H.\u001a&pER\u0001\u0012Q\u0013B#\u0005\u000f\u0012IEa\u0013\u0003N\t=#\u0011\u000b\u0005\u0007\u0003;\u001b\u0004\u0019\u0001=\t\u000f\u0005u7\u00071\u0001\u0002`\"1\u0011q]\u001aA\u0002QC\u0011\"a;4!\u0003\u0005\r!!<\t\r\u0005E8\u00071\u0001y\u0011%\t)p\rI\u0001\u0002\u0004\ti\u000fC\u0005\u0002zN\u0002\n\u00111\u0001\u00026\u00059\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$H\u0005N\u0001\u0018e\u0016\u001c8\r[3ek2,'j\u001c2%I\u00164\u0017-\u001e7uIY\nqC]3tG\",G-\u001e7f\u0015>\u0014G\u0005Z3gCVdG\u000fJ\u001c\u0002\u001dI,Wn\u001c<f'\u000eDW\rZ;mKR!\u00111\nB/\u0011\u0019\tij\u000ea\u0001q\u0006A1o\u00195fIVdW\r\u0006\u0005\u0002\u0016\n\r$Q\rB4\u0011\u0019\ti\n\u000fa\u0001q\"9\u0011Q\u001c\u001dA\u0002\u0005}\u0007BBAtq\u0001\u0007A\u000b\u0006\u0005\u0002\u0016\n-$Q\u000eB;\u0011\u0019\ti*\u000fa\u0001q\"9\u0011Q\\\u001dA\u0002\t=\u0004cA.\u0003r%\u0019!1\u000f/\u0003\u001d\u0005\u001bGo\u001c:TK2,7\r^5p]\"1\u0011q]\u001dA\u0002Q#\u0002\"!&\u0003z\tm$1\u0011\u0005\u0007\u0003;S\u0004\u0019\u0001=\t\u000f\u0005u'\b1\u0001\u0003~A\u0019\u0001Oa \n\u0007\t\u0005\u0015OA\u0006Fm\u0016tGo\u0015;sK\u0006l\u0007BBAtu\u0001\u0007A\u000b\u0006\u0006\u0002\u0016\n\u001d%\u0011\u0012BF\u0005\u001bCa!!(<\u0001\u0004A\bbBAow\u0001\u0007\u0011q\u001c\u0005\u0007\u0003O\\\u0004\u0019\u0001+\t\u000f\t=5\b1\u0001\u0002\u0010\u0006I1\u000f^1si\u0012\u000bG/\u001a\u000b\u000b\u0003+\u0013\u0019J!&\u0003\u0018\ne\u0005BBAOy\u0001\u0007\u0001\u0010C\u0004\u0002^r\u0002\rAa\u001c\t\r\u0005\u001dH\b1\u0001U\u0011\u001d\u0011y\t\u0010a\u0001\u0003\u001f#\"\"!&\u0003\u001e\n}%\u0011\u0015BR\u0011\u0019\ti*\u0010a\u0001q\"9\u0011Q\\\u001fA\u0002\tu\u0004BBAt{\u0001\u0007A\u000bC\u0004\u0003\u0010v\u0002\r!a$\u0002!M\u001c\u0007.\u001a3vY\u0016Le\u000e^3s]\u0006dGCCAK\u0005S\u0013YK!,\u00030\"1\u0011Q\u0014 A\u0002aDa!!8?\u0001\u0004!\u0006BBAt}\u0001\u0007A\u000bC\u0004\u0003\u0010z\u0002\r!a$\u0002\u0017M\u001c\u0007.\u001a3vY\u0016TuN\u0019\u000b\u000b\u0005k\u0013ILa/\u0003>\n}F\u0003BAK\u0005oCqAa\u0018@\u0001\u0004\tY\u0006\u0003\u0004\u0002\u001e~\u0002\r\u0001\u001f\u0005\u0007\u0003;|\u0004\u0019\u0001+\t\r\u0005\u001dx\b1\u0001U\u0011\u001d\u0011yi\u0010a\u0001\u0003\u001f\u000b1#\u001b8ji&\fG.[:f\u0007\u0006dWM\u001c3beN\f!\u0002\u001e5sK\u0006$\u0007k\\8m+\t\u00119\r\u0005\u0003\u0003J\n=WB\u0001Bf\u0015\u0011\u0011i-!\u001c\u0002\u000bMLW\u000e\u001d7\n\t\tE'1\u001a\u0002\u0011'&l\u0007\u000f\\3UQJ,\u0017\r\u001a)p_2\f\u0001B[8c'R|'/Z\u000b\u0003\u0005/\u0004BA!7\u0003`6\u0011!1\u001c\u0006\u0005\u0005;\fi'A\u0002ta&LAA!9\u0003\\\nA!j\u001c2Ti>\u0014X-A\u0005tG\",G-\u001e7feV\u0011!q\u001d\t\u0005\u0003W\u0012I/\u0003\u0003\u0003l\u00065$!C*dQ\u0016$W\u000f\\3s!\rY&q^\u0005\u0004\u0005cd&aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#\u0001)\u0002\r1|wn[;q\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGcA1\u0003|\")a\r\u0002a\u0001O\u0006\u0019q-\u001a;\u0015\u0007\u0005\u001c\t\u0001\u0003\u0004g\u000b\u0001\u000711\u0001\t\u00047\u000e\u0015\u0011bAB\u00049\nY\u0011i\u0019;peNK8\u000f^3n\u0001")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap<String, QuartzSchedule> schedules;
    private final TrieMap<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.system.settings().config().getConfig("akka.quartz").root().toConfig();
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        boolean bl2 = this.isStarted();
        if (bl2) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else if (!bl2) {
            this.scheduler().start();
            bl = true;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        boolean isJobCancelled = this.cancelJob(name);
        TrieMap<String, QuartzSchedule> trieMap = isJobCancelled ? this.removeSchedule(name) : BoxedUnit.UNIT;
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression expr;
        Either either = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable)() -> new CronExpression(cronExpression));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        CronExpression cronExpression2 = expr = (CronExpression)right.value();
        CronExpression expression = cronExpression2;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option option = this.schedules().putIfAbsent((Object)name, (Object)schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq((Object)name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name, calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable)() -> "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq(QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

