import React, {Component} from 'react';
import PropTypes from 'prop-types';
import clickOutside from './click-outside.decorator';

import PopupTrigger from './popup-trigger';

import './popup.less';

const Trigger = clickOutside()(PopupTrigger);

export class Popup extends Component {

  static propTypes = {
      children: PropTypes.oneOfType([
          PropTypes.arrayOf(PropTypes.node),
          PropTypes.node,
      ]).isRequired,
      onStateChange: PropTypes.func
  };

  constructor(props) {
    super(props);

    this.state = {
      isOpen: false,
    };
  }

  onClickOutside = () => {
    const {onStateChange} = this.props;

    this.setState({
      isOpen: false,
    });

    if (onStateChange) {
        onStateChange(false);
    }
  };

  toggleDropdown = (e) => {
    e.stopPropagation();
    const {onStateChange} = this.props;
    const state = !this.state.isOpen;

    this.setState({
      isOpen: state,
    });

    if (onStateChange) {
      onStateChange(state);
    }
  };

  render() {
    return (
      <div className={`popup__container ${this.state.isOpen ? 'popup--expanded' : ''}`}>
        <Trigger
          enable={this.state.isOpen}
          onClick={this.toggleDropdown}
          onClickOutside={this.onClickOutside}
        >
          <div
            className={`popup__content ${this.state.isOpen ? 'popup__content--open' : ''}`}
            role="presentation"
          >
            {this.props.children}
          </div>
        </Trigger>
      </div>
    );
  }
}

