/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;

public class DependencyBuilder {
    private String id;
    private GateTask gateTask;
    private PlanItem target;
    private String targetId;

    private DependencyBuilder() {
    }

    public static DependencyBuilder newDependency() {
        return new DependencyBuilder();
    }

    public DependencyBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DependencyBuilder withGate(GateTask gateTask) {
        this.gateTask = gateTask;
        return this;
    }

    public DependencyBuilder withTarget(PlanItem target) {
        this.target = target;
        return this;
    }

    public DependencyBuilder withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public Dependency build() {
        Dependency dependency = (Dependency)new Dependency().getType().getDescriptor().newInstance(this.id);
        dependency.setGateTask(this.gateTask);
        if (this.gateTask != null) {
            this.gateTask.addDependency(dependency);
        }
        dependency.setTarget(this.target);
        dependency.setTargetId(this.targetId);
        return dependency;
    }
}

